/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.IntBuffer;
import sun.awt.image.SunWritableRaster;
import sun.java2d.DataBufferNIOInt;

public class IntegerNIORaster
extends SunWritableRaster {
    protected IntBuffer data;

    public static WritableRaster createNIORaster(int w, int h, int[] bandMasks, Point location) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("Width (" + w + ") and height (" + h + ") cannot be <= 0");
        }
        DataBufferNIOInt db = new DataBufferNIOInt(w * h);
        if (location == null) {
            location = new Point(0, 0);
        }
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, bandMasks);
        return new IntegerNIORaster(sppsm, db, location);
    }

    public IntegerNIORaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        super(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
        if (!(dataBuffer instanceof DataBufferNIOInt)) {
            throw new RasterFormatException("IntegerNIORasters must have DataBufferNIOInt DataBuffers");
        }
        this.data = ((DataBufferNIOInt)dataBuffer).getBuffer();
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return new IntegerNIORaster(this.sampleModel, new DataBufferNIOInt(this.sampleModel.getWidth() * this.sampleModel.getHeight()), new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException("negative " + (w <= 0 ? "width" : "height"));
        }
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(w, h);
        return new IntegerNIORaster(sm, new DataBufferNIOInt(w * h), new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(Rectangle rect) {
        if (rect == null) {
            throw new NullPointerException("Rect cannot be null");
        }
        return this.createCompatibleWritableRaster(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int x, int y, int w, int h) {
        WritableRaster ret = this.createCompatibleWritableRaster(w, h);
        return ret.createWritableChild(0, 0, w, h, x, y, null);
    }

    public IntBuffer getBuffer() {
        return this.data;
    }

    public String toString() {
        return new String("IntegerNIORaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }
}

