/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;
import sun.awt.image.SunWritableRaster;
import sun.java2d.IntegerNIORaster;
import sun.java2d.OSXSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;

public class OSXOffScreenSurfaceData
extends OSXSurfaceData {
    BufferedImage bim;
    BufferedImage bimBackup;
    static DirectColorModel dcmBackup;
    Object lock;
    WritableRaster bufImgRaster;
    SunWritableRaster bufImgSunRaster;
    private static final int TYPE_3BYTE_RGB = 14;
    protected ByteBuffer fImageInfo;
    IntBuffer fImageInfoInt;
    private static final int kNeedToSyncFromJavaPixelsIndex = 0;
    private static final int kNativePixelsChangedIndex = 1;
    private static final int kImageStolenIndex = 2;
    private static final int kSizeOfParameters = 3;
    BufferedImage copyWithBgColor_cache = null;

    private static native void initIDs();

    public static native SurfaceData getSurfaceData(BufferedImage var0);

    protected static native void setSurfaceData(BufferedImage var0, SurfaceData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SurfaceData createData(BufferedImage bufImg) {
        BufferedImage bufferedImage = bufImg;
        synchronized (bufferedImage) {
            SurfaceData sData = OSXOffScreenSurfaceData.getSurfaceData(bufImg);
            if (sData != null) {
                return sData;
            }
            OSXOffScreenSurfaceData osData = OSXOffScreenSurfaceData.createNewSurface(bufImg);
            OSXOffScreenSurfaceData.setSurfaceData(bufImg, osData);
            osData.cacheRasters(bufImg);
            return osData;
        }
    }

    public static SurfaceData createData(Raster ras, ColorModel cm) {
        throw new InternalError("SurfaceData not implemented for Raster/CM");
    }

    static OSXOffScreenSurfaceData createNewSurface(BufferedImage bufImg) {
        SurfaceData sData = null;
        ColorModel cm = bufImg.getColorModel();
        int type = bufImg.getType();
        switch (type) {
            case 4: {
                sData = OSXOffScreenSurfaceData.createDataIC(bufImg, SurfaceType.IntBgr);
                break;
            }
            case 1: {
                sData = OSXOffScreenSurfaceData.createDataIC(bufImg, SurfaceType.IntRgb);
                break;
            }
            case 2: {
                sData = OSXOffScreenSurfaceData.createDataIC(bufImg, SurfaceType.IntArgb);
                break;
            }
            case 3: {
                sData = OSXOffScreenSurfaceData.createDataIC(bufImg, SurfaceType.IntArgbPre);
                break;
            }
            case 5: {
                sData = OSXOffScreenSurfaceData.createDataBC(bufImg, SurfaceType.ThreeByteBgr, 2);
                break;
            }
            case 6: {
                sData = OSXOffScreenSurfaceData.createDataBC(bufImg, SurfaceType.FourByteAbgr, 3);
                break;
            }
            case 7: {
                sData = OSXOffScreenSurfaceData.createDataBC(bufImg, SurfaceType.FourByteAbgrPre, 3);
                break;
            }
            case 8: {
                sData = OSXOffScreenSurfaceData.createDataSC(bufImg, SurfaceType.Ushort565Rgb, null);
                break;
            }
            case 9: {
                sData = OSXOffScreenSurfaceData.createDataSC(bufImg, SurfaceType.Ushort555Rgb, null);
                break;
            }
            case 13: {
                SurfaceType sType;
                switch (cm.getTransparency()) {
                    case 1: {
                        if (OSXOffScreenSurfaceData.isOpaqueGray((IndexColorModel)cm)) {
                            sType = SurfaceType.Index8Gray;
                            break;
                        }
                        sType = SurfaceType.ByteIndexedOpaque;
                        break;
                    }
                    case 2: {
                        sType = SurfaceType.ByteIndexedBm;
                        break;
                    }
                    case 3: {
                        sType = SurfaceType.ByteIndexed;
                        break;
                    }
                    default: {
                        throw new InternalError("Unrecognized transparency");
                    }
                }
                sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 0);
                break;
            }
            case 10: {
                sData = OSXOffScreenSurfaceData.createDataBC(bufImg, SurfaceType.ByteGray, 0);
                break;
            }
            case 11: {
                sData = OSXOffScreenSurfaceData.createDataSC(bufImg, SurfaceType.UshortGray, null);
                break;
            }
            default: {
                boolean littleendian;
                WritableRaster raster = bufImg.getRaster();
                SampleModel sm = bufImg.getSampleModel();
                SurfaceType sType = SurfaceType.Custom;
                int transferType = cm.getTransferType();
                int pixelSize = cm.getPixelSize();
                int numOfComponents = cm.getNumColorComponents();
                if (numOfComponents != 3 || !(cm instanceof ComponentColorModel) || !(sm instanceof PixelInterleavedSampleModel)) break;
                int[] sizes = cm.getComponentSize();
                boolean validsizes = sizes[0] == 8 && sizes[1] == 8 && sizes[2] == 8;
                int[] offs = ((ComponentSampleModel)sm).getBandOffsets();
                int numBands = raster.getNumBands();
                boolean bigendian = offs[0] == numBands - 3 && offs[1] == numBands - 2 && offs[2] == numBands - 1;
                boolean bl = littleendian = offs[0] == numBands - 1 && offs[1] == numBands - 2 && offs[2] == numBands - 3;
                if (pixelSize == 32 && transferType == 3) {
                    if (validsizes && bigendian && cm.hasAlpha() && cm.isAlphaPremultiplied() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 3);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && bigendian && cm.hasAlpha() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 2);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && littleendian && cm.hasAlpha() && cm.isAlphaPremultiplied() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 7);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && littleendian && cm.hasAlpha() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 6);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (!validsizes || !bigendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 1);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 32 && transferType == 0) {
                    if (validsizes && bigendian && cm.hasAlpha() && cm.isAlphaPremultiplied() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 3);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                    }
                    if (validsizes && bigendian && cm.hasAlpha() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 2);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && littleendian && cm.hasAlpha() && cm.isAlphaPremultiplied() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 7);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && littleendian && cm.hasAlpha() && sizes[3] == 8) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 6);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (validsizes && littleendian) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 4);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (!validsizes || !bigendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 3, 1);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 24 && transferType == 3) {
                    if (validsizes && bigendian) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 1);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (!validsizes || !littleendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataIC(bufImg, sType, 4);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 24 && transferType == 0) {
                    if (validsizes && bigendian) {
                        try {
                            sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 0, 14);
                        }
                        catch (ClassCastException e) {
                            sData = null;
                        }
                        break;
                    }
                    if (!validsizes || !littleendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 0, 5);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 16 && transferType == 1) {
                    boolean bl2 = validsizes = sizes[0] == 5 && sizes[1] == 6 && sizes[2] == 5;
                    if (!validsizes || !bigendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataSC(bufImg, sType, null, 8);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 16 && transferType == 0) {
                    boolean bl3 = validsizes = sizes[0] == 5 && sizes[1] == 6 && sizes[2] == 5;
                    if (!validsizes || !bigendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 1, 8);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize == 15 && transferType == 1) {
                    boolean bl4 = validsizes = sizes[0] == 5 && sizes[1] == 5 && sizes[2] == 5;
                    if (!validsizes || !bigendian) break;
                    try {
                        sData = OSXOffScreenSurfaceData.createDataSC(bufImg, sType, null, 9);
                    }
                    catch (ClassCastException e) {
                        sData = null;
                    }
                    break;
                }
                if (pixelSize != 15 || transferType != 0) break;
                boolean bl5 = validsizes = sizes[0] == 5 && sizes[1] == 5 && sizes[2] == 5;
                if (!validsizes || !bigendian) break;
                try {
                    sData = OSXOffScreenSurfaceData.createDataBC(bufImg, sType, 1, 9);
                    break;
                }
                catch (ClassCastException e) {
                    sData = null;
                }
            }
        }
        if (sData == null) {
            sData = new OSXOffScreenSurfaceData(bufImg, SurfaceType.Custom);
            OSXOffScreenSurfaceData offsd = (OSXOffScreenSurfaceData)sData;
            IntegerNIORaster backupRaster = (IntegerNIORaster)IntegerNIORaster.createNIORaster(bufImg.getWidth(), bufImg.getHeight(), dcmBackup.getMasks(), null);
            offsd.bimBackup = new BufferedImage(dcmBackup, backupRaster, dcmBackup.isAlphaPremultiplied(), null);
            offsd.initCustomRaster(backupRaster.getBuffer(), backupRaster.getWidth(), backupRaster.getHeight(), offsd.fGraphicsStates, offsd.fGraphicsStatesObject, offsd.fImageInfo);
            offsd.fImageInfoInt.put(2, 1);
        }
        return (OSXOffScreenSurfaceData)sData;
    }

    private static SurfaceData createDataIC(BufferedImage bImg, SurfaceType sType, int iType) {
        OSXOffScreenSurfaceData offsd = new OSXOffScreenSurfaceData(bImg, sType);
        IntegerComponentRaster icRaster = (IntegerComponentRaster)bImg.getRaster();
        offsd.initRaster(icRaster.getDataStorage(), icRaster.getDataOffset(0) * 4, icRaster.getWidth(), icRaster.getHeight(), icRaster.getPixelStride() * 4, icRaster.getScanlineStride() * 4, null, iType, offsd.fGraphicsStates, offsd.fGraphicsStatesObject, offsd.fImageInfo);
        offsd.fImageInfoInt.put(2, 1);
        return offsd;
    }

    public static SurfaceData createDataIC(BufferedImage bImg, SurfaceType sType) {
        return OSXOffScreenSurfaceData.createDataIC(bImg, sType, bImg.getType());
    }

    private static SurfaceData createDataSC(BufferedImage bImg, SurfaceType sType, IndexColorModel icm, int iType) {
        OSXOffScreenSurfaceData offsd = new OSXOffScreenSurfaceData(bImg, sType);
        ShortComponentRaster scRaster = (ShortComponentRaster)bImg.getRaster();
        offsd.initRaster(scRaster.getDataStorage(), scRaster.getDataOffset(0) * 2, scRaster.getWidth(), scRaster.getHeight(), scRaster.getPixelStride() * 2, scRaster.getScanlineStride() * 2, icm, iType, offsd.fGraphicsStates, offsd.fGraphicsStatesObject, offsd.fImageInfo);
        offsd.fImageInfoInt.put(2, 1);
        return offsd;
    }

    public static SurfaceData createDataSC(BufferedImage bImg, SurfaceType sType, IndexColorModel icm) {
        return OSXOffScreenSurfaceData.createDataSC(bImg, sType, icm, bImg.getType());
    }

    private static SurfaceData createDataBC(BufferedImage bImg, SurfaceType sType, int primaryBank, int iType) {
        OSXOffScreenSurfaceData offsd = new OSXOffScreenSurfaceData(bImg, sType);
        ByteComponentRaster bcRaster = (ByteComponentRaster)bImg.getRaster();
        ColorModel cm = bImg.getColorModel();
        IndexColorModel icm = cm instanceof IndexColorModel ? (IndexColorModel)cm : null;
        offsd.initRaster(bcRaster.getDataStorage(), bcRaster.getDataOffset(primaryBank), bcRaster.getWidth(), bcRaster.getHeight(), bcRaster.getPixelStride(), bcRaster.getScanlineStride(), icm, iType, offsd.fGraphicsStates, offsd.fGraphicsStatesObject, offsd.fImageInfo);
        offsd.fImageInfoInt.put(2, 1);
        return offsd;
    }

    public static SurfaceData createDataBC(BufferedImage bImg, SurfaceType sType, int primaryBank) {
        return OSXOffScreenSurfaceData.createDataBC(bImg, sType, primaryBank, bImg.getType());
    }

    private static SurfaceData createDataBP(BufferedImage bImg, SurfaceType sType, int iType) {
        OSXOffScreenSurfaceData offsd = new OSXOffScreenSurfaceData(bImg, sType);
        BytePackedRaster bpRaster = (BytePackedRaster)bImg.getRaster();
        ColorModel cm = bImg.getColorModel();
        IndexColorModel icm = cm instanceof IndexColorModel ? (IndexColorModel)cm : null;
        offsd.initRaster(bpRaster.getDataStorage(), bpRaster.getDataBitOffset(), bpRaster.getWidth(), bpRaster.getHeight(), bpRaster.getPixelBitStride(), bpRaster.getScanlineStride() * 8, icm, iType, offsd.fGraphicsStates, offsd.fGraphicsStatesObject, offsd.fImageInfo);
        offsd.fImageInfoInt.put(2, 1);
        return offsd;
    }

    protected native void initRaster(Object var1, int var2, int var3, int var4, int var5, int var6, IndexColorModel var7, int var8, ByteBuffer var9, Object var10, ByteBuffer var11);

    protected native void initCustomRaster(IntBuffer var1, int var2, int var3, ByteBuffer var4, Object var5, ByteBuffer var6);

    public Object getLockObject() {
        return this.lock;
    }

    OSXOffScreenSurfaceData(BufferedImage bufImg, SurfaceType sType) {
        super(sType, bufImg.getColorModel());
        this.setBounds(0, 0, bufImg.getWidth(), bufImg.getHeight());
        this.bim = bufImg;
        this.fImageInfo = ByteBuffer.allocateDirect(12);
        this.fImageInfo.order(ByteOrder.nativeOrder());
        this.fImageInfoInt = this.fImageInfo.asIntBuffer();
        this.fImageInfoInt.put(0, 1);
        this.fImageInfoInt.put(1, 0);
        this.fImageInfoInt.put(2, 0);
        this.lock = new Object();
    }

    @Override
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        int offsetX = 0;
        int offsetY = 0;
        if (sg2d.transformState == 2 || sg2d.transformState == 1) {
            offsetX = (int)sg2d.transform.getTranslateX();
            offsetY = (int)sg2d.transform.getTranslateY();
        } else if (sg2d.transformState != 0) {
            return false;
        }
        Shape clip = sg2d.getClip();
        sg2d.setClip(this.getBounds());
        Rectangle clippedCopyAreaRect = this.clipCopyArea(sg2d, x, y, w, h, dx, dy);
        if (clippedCopyAreaRect == null) {
            return true;
        }
        x = clippedCopyAreaRect.x - offsetX;
        y = clippedCopyAreaRect.y - offsetY;
        w = clippedCopyAreaRect.width;
        h = clippedCopyAreaRect.height;
        sg2d.drawImage(this.bim, x + dx, y + dy, x + dx + w, y + dy + h, x + offsetX, y + offsetY, x + w + offsetX, y + h + offsetY, null);
        sg2d.setClip(clip);
        return true;
    }

    @Override
    public BufferedImage copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, BufferedImage dstImage) {
        if (dstImage == null) {
            dstImage = this.getDeviceConfiguration().createCompatibleImage(w, h);
        }
        Graphics2D g = dstImage.createGraphics();
        g.drawImage(this.bim, 0, 0, w, h, x, y, x + w, y + h, null);
        g.dispose();
        return dstImage;
    }

    @Override
    public boolean xorSurfacePixels(SunGraphics2D sg2d, BufferedImage srcPixels, int x, int y, int w, int h, int colorXOR) {
        int type = this.bim.getType();
        if (type == 3 || type == 2 || type == 1) {
            return this.xorSurfacePixels(OSXOffScreenSurfaceData.createData(srcPixels), colorXOR, x, y, w, h);
        }
        return false;
    }

    native boolean xorSurfacePixels(SurfaceData var1, int var2, int var3, int var4, int var5, int var6);

    @Override
    public void clearRect(BufferedImage bim, int w, int h) {
        OSXOffScreenSurfaceData offsd = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(bim);
        if (!offsd.clearSurfacePixels(w, h)) {
            Graphics2D g = bim.createGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, w, h);
            g.dispose();
        }
    }

    native boolean clearSurfacePixels(int var1, int var2);

    public SurfaceData getCopyWithBgColor(Color bgColor) {
        int bimW = this.bim.getWidth();
        int bimH = this.bim.getHeight();
        if (this.copyWithBgColor_cache == null || this.copyWithBgColor_cache.getWidth() < bimW || this.copyWithBgColor_cache.getHeight() < bimH) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.copyWithBgColor_cache = gc.createCompatibleImage(bimW, bimH);
        }
        Graphics2D g2 = this.copyWithBgColor_cache.createGraphics();
        g2.setColor(bgColor);
        g2.fillRect(0, 0, bimW, bimH);
        g2.drawImage(this.bim, 0, 0, bimW, bimH, null);
        g2.dispose();
        return OSXOffScreenSurfaceData.getSurfaceData(this.copyWithBgColor_cache);
    }

    public void rasterRead() {
        if (this.fImageInfoInt.get(1) == 1) {
            this.syncToJavaPixels();
        }
    }

    public void rasterWrite() {
        if (this.fImageInfoInt.get(1) == 1) {
            this.syncToJavaPixels();
        }
        this.fImageInfoInt.put(0, 1);
    }

    private void syncFromCustom() {
    }

    private void syncToCustom() {
    }

    private native void syncToJavaPixels();

    void cacheRasters(BufferedImage bim) {
        this.bufImgRaster = bim.getRaster();
        if (this.bufImgRaster instanceof SunWritableRaster) {
            this.bufImgSunRaster = (SunWritableRaster)this.bufImgRaster;
        }
    }

    static {
        OSXOffScreenSurfaceData.initIDs();
        dcmBackup = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }
}

