/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.swing.plaf.ColorUIResource;
import sun.awt.SunHints;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.CRenderer;
import sun.java2d.CompositeCRenderer;
import sun.java2d.OSXOffScreenSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.lwawt.macosx.CTextPipe;

public abstract class OSXSurfaceData
extends BufImgSurfaceData {
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;
    protected static CRenderer sQuartzPipe = null;
    protected static CTextPipe sCocoaTextPipe = null;
    protected static CompositeCRenderer sQuartzCompositePipe = null;
    private GraphicsConfiguration fConfig;
    private Rectangle fBounds;
    GraphicsConfiguration sDefaultGraphicsConfiguration = null;
    BufferedImage sSrcComposite = null;
    BufferedImage sDstInComposite = null;
    BufferedImage sDstOutComposite = null;
    static final int kPrimitive = 0;
    static final int kImage = 1;
    static final int kText = 2;
    static final int kCopyArea = 3;
    static final int kExternal = 4;
    static final int kLine = 5;
    static final int kRect = 6;
    static final int kRoundRect = 7;
    static final int kOval = 8;
    static final int kArc = 9;
    static final int kPolygon = 10;
    static final int kShape = 11;
    static final int kString = 13;
    static final int kGlyphs = 14;
    static final int kUnicodes = 15;
    static final int kCommonParameterCount = 10;
    static final int kLineParametersCount = 10;
    static final int kRectParametersCount = 11;
    static final int kRoundRectParametersCount = 13;
    static final int kOvalParametersCount = 11;
    static final int kArcParametersCount = 14;
    static final int kPolygonParametersCount = 0;
    static final int kShapeParametersCount = 0;
    static final int kImageParametersCount = 22;
    static final int kStringParametersCount = 0;
    static final int kGlyphsParametersCount = 0;
    static final int kUnicodesParametersCount = 0;
    static final int kPixelParametersCount = 0;
    static final int kExternalParametersCount = 0;
    static final int kChangeFlagIndex = 0;
    static final int kBoundsXIndex = 1;
    static final int kBoundsYIndex = 2;
    static final int kBoundsWidthIndex = 3;
    static final int kBoundsHeightIndex = 4;
    static final int kClipStateIndex = 5;
    static final int kClipNumTypesIndex = 6;
    static final int kClipNumCoordsIndex = 7;
    static final int kClipWindingRuleIndex = 8;
    static final int kClipXIndex = 9;
    static final int kClipYIndex = 10;
    static final int kClipWidthIndex = 11;
    static final int kClipHeightIndex = 12;
    static final int kCTMaIndex = 13;
    static final int kCTMbIndex = 14;
    static final int kCTMcIndex = 15;
    static final int kCTMdIndex = 16;
    static final int kCTMtxIndex = 17;
    static final int kCTMtyIndex = 18;
    static final int kColorStateIndex = 19;
    static final int kColorRGBValueIndex = 20;
    static final int kColorIndexValueIndex = 21;
    static final int kColorPointerIndex = 22;
    static final int kColorPointerIndex2 = 23;
    static final int kColorRGBValue1Index = 24;
    static final int kColorWidthIndex = 25;
    static final int kColorRGBValue2Index = 26;
    static final int kColorHeightIndex = 27;
    static final int kColorIsCyclicIndex = 28;
    static final int kColorx1Index = 29;
    static final int kColortxIndex = 30;
    static final int kColory1Index = 31;
    static final int kColortyIndex = 32;
    static final int kColorx2Index = 33;
    static final int kColorsxIndex = 34;
    static final int kColory2Index = 35;
    static final int kColorsyIndex = 36;
    static final int kCompositeRuleIndex = 37;
    static final int kCompositeValueIndex = 38;
    static final int kStrokeJoinIndex = 39;
    static final int kStrokeCapIndex = 40;
    static final int kStrokeWidthIndex = 41;
    static final int kStrokeDashPhaseIndex = 42;
    static final int kStrokeLimitIndex = 43;
    static final int kHintsAntialiasIndex = 44;
    static final int kHintsTextAntialiasIndex = 45;
    static final int kHintsFractionalMetricsIndex = 46;
    static final int kHintsRenderingIndex = 47;
    static final int kHintsInterpolationIndex = 48;
    static final int kRadiusIndex = 49;
    static final int kSizeOfParameters = 50;
    static final int kClipCoordinatesIndex = 0;
    static final int kClipTypesIndex = 1;
    static final int kTextureImageIndex = 2;
    static final int kStrokeDashArrayIndex = 3;
    static final int kFontIndex = 4;
    static final int kFontPaintIndex = 5;
    static final int kColorArrayIndex = 6;
    static final int kFractionsArrayIndex = 7;
    static final int kBoundsChangedBit = 1;
    static final int kBoundsNotChangedBit = -2;
    static final int kClipChangedBit = 2;
    static final int kClipNotChangedBit = -3;
    static final int kCTMChangedBit = 4;
    static final int kCTMNotChangedBit = -5;
    static final int kColorChangedBit = 8;
    static final int kColorNotChangedBit = -9;
    static final int kCompositeChangedBit = 16;
    static final int kCompositeNotChangedBit = -17;
    static final int kStrokeChangedBit = 32;
    static final int kStrokeNotChangedBit = -33;
    static final int kHintsChangedBit = 64;
    static final int kHintsNotChangedBit = -65;
    static final int kFontChangedBit = 128;
    static final int kFontNotChangedBit = -129;
    static final int kEverythingChangedFlag = -1;
    static final int kColorSimple = 0;
    static final int kColorSystem = 1;
    static final int kColorGradient = 2;
    static final int kColorTexture = 3;
    static final int kColorLinearGradient = 4;
    static final int kColorRadialGradient = 5;
    static final int kColorNonCyclic = 0;
    static final int kColorCyclic = 1;
    static final int kClipRect = 0;
    static final int kClipShape = 1;
    int fChangeFlag;
    protected ByteBuffer fGraphicsStates = null;
    IntBuffer fGraphicsStatesInt = null;
    FloatBuffer fGraphicsStatesFloat = null;
    LongBuffer fGraphicsStatesLong = null;
    protected Object[] fGraphicsStatesObject = null;
    Rectangle userBounds = new Rectangle();
    float lastUserX = 0.0f;
    float lastUserY = 0.0f;
    float lastUserW = 0.0f;
    float lastUserH = 0.0f;
    FloatBuffer clipCoordinatesArray = null;
    IntBuffer clipTypesArray = null;
    Shape lastClipShape = null;
    float lastClipX = 0.0f;
    float lastClipY = 0.0f;
    float lastClipW = 0.0f;
    float lastClipH = 0.0f;
    final double[] lastCTM = new double[6];
    float lastCTMa = 0.0f;
    float lastCTMb = 0.0f;
    float lastCTMc = 0.0f;
    float lastCTMd = 0.0f;
    float lastCTMtx = 0.0f;
    float lastCTMty = 0.0f;
    static AffineTransform sIdentityMatrix;
    Paint lastPaint = null;
    long lastPaintPtr = 0L;
    int lastPaintRGB = 0;
    int lastPaintIndex = 0;
    BufferedImage texturePaintImage = null;
    Composite lastComposite;
    int lastCompositeAlphaRule = 0;
    float lastCompositeAlphaValue = 0.0f;
    BasicStroke lastStroke = null;
    static BasicStroke defaultBasicStroke;
    Font lastFont;
    SunGraphics2D sg2dCurrent = null;
    Thread threadCurrent = null;
    final float[] segmentCoordinatesArray = new float[6];
    FloatBuffer shapeCoordinatesArray = null;
    IntBuffer shapeTypesArray = null;
    Rectangle srcCopyAreaRect = new Rectangle();
    Rectangle dstCopyAreaRect = new Rectangle();
    Rectangle finalCopyAreaRect = new Rectangle();
    Rectangle copyAreaBounds = new Rectangle();

    public OSXSurfaceData(SurfaceType sType, ColorModel cm) {
        this(sType, cm, null, new Rectangle());
    }

    public OSXSurfaceData(SurfaceType sType, ColorModel cm, GraphicsConfiguration config, Rectangle bounds) {
        super(sType, cm);
        this.fConfig = config;
        this.fBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.y + bounds.height);
        this.fGraphicsStates = OSXSurfaceData.getBufferOfSize(50);
        this.fGraphicsStatesInt = this.fGraphicsStates.asIntBuffer();
        this.fGraphicsStatesFloat = this.fGraphicsStates.asFloatBuffer();
        this.fGraphicsStatesLong = this.fGraphicsStates.asLongBuffer();
        this.fGraphicsStatesObject = new Object[8];
    }

    @Override
    public void validatePipe(SunGraphics2D sg2d) {
        if (sg2d.compositeState <= 1) {
            if (sCocoaTextPipe == null) {
                sCocoaTextPipe = new CTextPipe();
            }
            sg2d.imagepipe = sQuartzPipe;
            sg2d.drawpipe = sQuartzPipe;
            sg2d.fillpipe = sQuartzPipe;
            sg2d.shapepipe = sQuartzPipe;
            sg2d.textpipe = sCocoaTextPipe;
        } else {
            this.setPipesToQuartzComposite(sg2d);
        }
    }

    protected void setPipesToQuartzComposite(SunGraphics2D sg2d) {
        if (sQuartzCompositePipe == null) {
            sQuartzCompositePipe = new CompositeCRenderer();
        }
        if (sCocoaTextPipe == null) {
            sCocoaTextPipe = new CTextPipe();
        }
        sg2d.imagepipe = sQuartzCompositePipe;
        sg2d.drawpipe = sQuartzCompositePipe;
        sg2d.fillpipe = sQuartzCompositePipe;
        sg2d.shapepipe = sQuartzCompositePipe;
        sg2d.textpipe = sCocoaTextPipe;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height - this.fBounds.y);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.fConfig;
    }

    protected void setBounds(int x, int y, int w, int h) {
        this.fBounds.reshape(x, y, w, y + h);
    }

    public abstract BufferedImage copyArea(SunGraphics2D var1, int var2, int var3, int var4, int var5, BufferedImage var6);

    public abstract boolean xorSurfacePixels(SunGraphics2D var1, BufferedImage var2, int var3, int var4, int var5, int var6, int var7);

    protected BufferedImage getCompositingImage(int w, int h) {
        if (this.sDefaultGraphicsConfiguration == null) {
            this.sDefaultGraphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        BufferedImage img = new BufferedImage(w, h, 3);
        this.clearRect(img, w, h);
        return img;
    }

    protected BufferedImage getCompositingImageSame(BufferedImage img, int w, int h) {
        if (img == null || img.getWidth() != w || img.getHeight() != h) {
            img = this.getCompositingImage(w, h);
        }
        return img;
    }

    public BufferedImage getCompositingSrcImage(int w, int h) {
        BufferedImage bim;
        this.sSrcComposite = bim = this.getCompositingImageSame(this.sSrcComposite, w, h);
        return bim;
    }

    public BufferedImage getCompositingDstInImage(int w, int h) {
        BufferedImage bim;
        this.sDstInComposite = bim = this.getCompositingImageSame(this.sDstInComposite, w, h);
        return bim;
    }

    public BufferedImage getCompositingDstOutImage(int w, int h) {
        BufferedImage bim;
        this.sDstOutComposite = bim = this.getCompositingImageSame(this.sDstOutComposite, w, h);
        return bim;
    }

    public void clearRect(BufferedImage bim, int w, int h) {
        Graphics2D g = bim.createGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, w, h);
        g.dispose();
    }

    @Override
    public void invalidate() {
    }

    static int getRendererTypeForPrimitive(int primitiveType) {
        switch (primitiveType) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 13: 
            case 14: 
            case 15: {
                return 2;
            }
        }
        return 0;
    }

    void setUserBounds(SunGraphics2D sg2d, int x, int y, int width, int height) {
        if (this.lastUserX != (float)x || this.lastUserY != (float)y || this.lastUserW != (float)width || this.lastUserH != (float)height) {
            this.lastUserX = x;
            this.lastUserY = y;
            this.lastUserW = width;
            this.lastUserH = height;
            this.fGraphicsStatesInt.put(1, x);
            this.fGraphicsStatesInt.put(2, y);
            this.fGraphicsStatesInt.put(3, width);
            this.fGraphicsStatesInt.put(4, height);
            this.userBounds.setBounds(x, y, width, height);
            this.fChangeFlag |= 1;
        } else {
            this.fChangeFlag &= 0xFFFFFFFE;
        }
    }

    static ByteBuffer getBufferOfSize(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size * 4);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    void setupClip(SunGraphics2D sg2d) {
        switch (sg2d.clipState) {
            case 0: 
            case 1: {
                Region clip = sg2d.getCompClip();
                float x = clip.getLoX();
                float y = clip.getLoY();
                float w = clip.getWidth();
                float h = clip.getHeight();
                if (this.fGraphicsStatesInt.get(5) != 0 || x != this.lastClipX || y != this.lastClipY || w != this.lastClipW || h != this.lastClipH) {
                    this.fGraphicsStatesFloat.put(9, x);
                    this.fGraphicsStatesFloat.put(10, y);
                    this.fGraphicsStatesFloat.put(11, w);
                    this.fGraphicsStatesFloat.put(12, h);
                    this.lastClipX = x;
                    this.lastClipY = y;
                    this.lastClipW = w;
                    this.lastClipH = h;
                    this.fChangeFlag |= 2;
                } else {
                    this.fChangeFlag &= 0xFFFFFFFD;
                }
                this.fGraphicsStatesInt.put(5, 0);
                break;
            }
            case 2: {
                this.lastClipShape = sg2d.usrClip;
                GeneralPath gp = null;
                gp = sg2d.usrClip instanceof GeneralPath ? (GeneralPath)sg2d.usrClip : new GeneralPath(sg2d.usrClip);
                int shapeLength = this.getPathLength(gp);
                if (this.clipCoordinatesArray == null || this.clipCoordinatesArray.capacity() < shapeLength * 6) {
                    this.clipCoordinatesArray = OSXSurfaceData.getBufferOfSize(shapeLength * 6).asFloatBuffer();
                }
                if (this.clipTypesArray == null || this.clipTypesArray.capacity() < shapeLength) {
                    this.clipTypesArray = OSXSurfaceData.getBufferOfSize(shapeLength).asIntBuffer();
                }
                int windingRule = this.getPathCoordinates(gp, this.clipCoordinatesArray, this.clipTypesArray);
                this.fGraphicsStatesInt.put(6, this.clipTypesArray.position());
                this.fGraphicsStatesInt.put(7, this.clipCoordinatesArray.position());
                this.fGraphicsStatesInt.put(8, windingRule);
                this.fGraphicsStatesObject[1] = this.clipTypesArray;
                this.fGraphicsStatesObject[0] = this.clipCoordinatesArray;
                this.fChangeFlag |= 2;
                this.fGraphicsStatesInt.put(5, 1);
                break;
            }
        }
    }

    void setupTransform(SunGraphics2D sg2d) {
        sg2d.transform.getMatrix(this.lastCTM);
        float a = (float)this.lastCTM[0];
        float b = (float)this.lastCTM[1];
        float c = (float)this.lastCTM[2];
        float d = (float)this.lastCTM[3];
        float tx = (float)this.lastCTM[4];
        float ty = (float)this.lastCTM[5];
        if (tx != this.lastCTMtx || ty != this.lastCTMty || a != this.lastCTMa || b != this.lastCTMb || c != this.lastCTMc || d != this.lastCTMd) {
            this.fGraphicsStatesFloat.put(13, a);
            this.fGraphicsStatesFloat.put(14, b);
            this.fGraphicsStatesFloat.put(15, c);
            this.fGraphicsStatesFloat.put(16, d);
            this.fGraphicsStatesFloat.put(17, tx);
            this.fGraphicsStatesFloat.put(18, ty);
            this.lastCTMa = a;
            this.lastCTMb = b;
            this.lastCTMc = c;
            this.lastCTMd = d;
            this.lastCTMtx = tx;
            this.lastCTMty = ty;
            this.fChangeFlag |= 4;
        } else {
            this.fChangeFlag &= 0xFFFFFFFB;
        }
    }

    void setGradientViaRasterPath(SunGraphics2D sg2d) {
        if (this.fGraphicsStatesInt.get(19) != 3 || this.lastPaint != sg2d.paint || (this.fChangeFlag & 1) != 0) {
            PaintContext context = sg2d.paint.createContext(sg2d.getDeviceColorModel(), this.userBounds, this.userBounds, sIdentityMatrix, sg2d.getRenderingHints());
            WritableRaster raster = (WritableRaster)context.getRaster(this.userBounds.x, this.userBounds.y, this.userBounds.width, this.userBounds.height);
            ColorModel cm = context.getColorModel();
            this.texturePaintImage = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
            this.fGraphicsStatesInt.put(19, 3);
            this.fGraphicsStatesInt.put(25, this.texturePaintImage.getWidth());
            this.fGraphicsStatesInt.put(27, this.texturePaintImage.getHeight());
            this.fGraphicsStatesFloat.put(30, (float)this.userBounds.getX());
            this.fGraphicsStatesFloat.put(32, (float)this.userBounds.getY());
            this.fGraphicsStatesFloat.put(34, 1.0f);
            this.fGraphicsStatesFloat.put(36, 1.0f);
            this.fGraphicsStatesObject[2] = OSXOffScreenSurfaceData.createNewSurface(this.texturePaintImage);
            this.fChangeFlag |= 8;
        } else {
            this.fChangeFlag &= 0xFFFFFFF7;
        }
    }

    void setupPaint(SunGraphics2D sg2d, int x, int y, int w, int h) {
        if (sg2d.paint instanceof SystemColor) {
            SystemColor color = (SystemColor)sg2d.paint;
            int index = color.hashCode();
            if (this.fGraphicsStatesInt.get(19) != 1 || index != this.lastPaintIndex) {
                this.lastPaintIndex = index;
                this.fGraphicsStatesInt.put(19, 1);
                this.fGraphicsStatesInt.put(21, index);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sg2d.paint instanceof Color) {
            Color color = (Color)sg2d.paint;
            int rgb = color.getRGB();
            if (this.fGraphicsStatesInt.get(19) != 0 || rgb != this.lastPaintRGB) {
                this.lastPaintRGB = rgb;
                this.fGraphicsStatesInt.put(19, 0);
                this.fGraphicsStatesInt.put(20, rgb);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sg2d.paint instanceof GradientPaint) {
            if (this.fGraphicsStatesInt.get(19) != 2 || this.lastPaint != sg2d.paint) {
                GradientPaint color = (GradientPaint)sg2d.paint;
                this.fGraphicsStatesInt.put(19, 2);
                this.fGraphicsStatesInt.put(24, color.getColor1().getRGB());
                this.fGraphicsStatesInt.put(26, color.getColor2().getRGB());
                this.fGraphicsStatesInt.put(28, color.isCyclic() ? 1 : 0);
                Point2D p = color.getPoint1();
                this.fGraphicsStatesFloat.put(29, (float)p.getX());
                this.fGraphicsStatesFloat.put(31, (float)p.getY());
                p = color.getPoint2();
                this.fGraphicsStatesFloat.put(33, (float)p.getX());
                this.fGraphicsStatesFloat.put(35, (float)p.getY());
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sg2d.paint instanceof LinearGradientPaint) {
            LinearGradientPaint color = (LinearGradientPaint)sg2d.paint;
            if (color.getCycleMethod() == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
                if (this.fGraphicsStatesInt.get(19) != 4 || this.lastPaint != sg2d.paint) {
                    this.fGraphicsStatesInt.put(19, 4);
                    int numColor = color.getColors().length;
                    int[] colorArray = new int[numColor];
                    for (int i = 0; i < numColor; ++i) {
                        colorArray[i] = color.getColors()[i].getRGB();
                    }
                    this.fGraphicsStatesObject[6] = colorArray;
                    int numFractions = color.getFractions().length;
                    float[] fractionArray = new float[numFractions];
                    for (int i = 0; i < numFractions; ++i) {
                        fractionArray[i] = color.getFractions()[i];
                    }
                    this.fGraphicsStatesObject[7] = color.getFractions();
                    Point2D p = color.getStartPoint();
                    this.fGraphicsStatesFloat.put(29, (float)p.getX());
                    this.fGraphicsStatesFloat.put(31, (float)p.getY());
                    p = color.getEndPoint();
                    this.fGraphicsStatesFloat.put(33, (float)p.getX());
                    this.fGraphicsStatesFloat.put(35, (float)p.getY());
                    this.fChangeFlag |= 8;
                } else {
                    this.fChangeFlag &= 0xFFFFFFF7;
                }
            } else {
                this.setGradientViaRasterPath(sg2d);
            }
        } else if (sg2d.paint instanceof RadialGradientPaint) {
            RadialGradientPaint color = (RadialGradientPaint)sg2d.paint;
            if (color.getCycleMethod() == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
                if (this.fGraphicsStatesInt.get(19) != 5 || this.lastPaint != sg2d.paint) {
                    this.fGraphicsStatesInt.put(19, 5);
                    int numColor = color.getColors().length;
                    int[] colorArray = new int[numColor];
                    for (int i = 0; i < numColor; ++i) {
                        colorArray[i] = color.getColors()[i].getRGB();
                    }
                    this.fGraphicsStatesObject[6] = colorArray;
                    int numStops = color.getFractions().length;
                    float[] stopsArray = new float[numStops];
                    for (int i = 0; i < numStops; ++i) {
                        stopsArray[i] = color.getFractions()[i];
                    }
                    this.fGraphicsStatesObject[7] = color.getFractions();
                    Point2D p = color.getFocusPoint();
                    this.fGraphicsStatesFloat.put(29, (float)p.getX());
                    this.fGraphicsStatesFloat.put(31, (float)p.getY());
                    p = color.getCenterPoint();
                    this.fGraphicsStatesFloat.put(33, (float)p.getX());
                    this.fGraphicsStatesFloat.put(35, (float)p.getY());
                    this.fGraphicsStatesFloat.put(49, color.getRadius());
                    this.fChangeFlag |= 8;
                } else {
                    this.fChangeFlag &= 0xFFFFFFF7;
                }
            } else {
                this.setGradientViaRasterPath(sg2d);
            }
        } else if (sg2d.paint instanceof TexturePaint) {
            if (this.fGraphicsStatesInt.get(19) != 3 || this.lastPaint != sg2d.paint) {
                TexturePaint color = (TexturePaint)sg2d.paint;
                this.fGraphicsStatesInt.put(19, 3);
                this.texturePaintImage = color.getImage();
                OSXOffScreenSurfaceData textureSurfaceData = OSXOffScreenSurfaceData.createNewSurface(this.texturePaintImage);
                this.fGraphicsStatesInt.put(25, this.texturePaintImage.getWidth());
                this.fGraphicsStatesInt.put(27, this.texturePaintImage.getHeight());
                Rectangle2D anchor = color.getAnchorRect();
                this.fGraphicsStatesFloat.put(30, (float)anchor.getX());
                this.fGraphicsStatesFloat.put(32, (float)anchor.getY());
                this.fGraphicsStatesFloat.put(34, (float)(anchor.getWidth() / (double)this.texturePaintImage.getWidth()));
                this.fGraphicsStatesFloat.put(36, (float)(anchor.getHeight() / (double)this.texturePaintImage.getHeight()));
                this.fGraphicsStatesObject[2] = textureSurfaceData;
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else {
            this.setGradientViaRasterPath(sg2d);
        }
        this.lastPaint = sg2d.paint;
    }

    void setupComposite(SunGraphics2D sg2d) {
        Composite composite = sg2d.composite;
        if (this.lastComposite != composite) {
            this.lastComposite = composite;
            int alphaRule = 3;
            float alphaValue = 1.0f;
            if (sg2d.compositeState <= 1 && composite != null) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                alphaRule = alphaComposite.getRule();
                alphaValue = alphaComposite.getAlpha();
            }
            if (this.lastCompositeAlphaRule != alphaRule || this.lastCompositeAlphaValue != alphaValue) {
                this.fGraphicsStatesInt.put(37, alphaRule);
                this.fGraphicsStatesFloat.put(38, alphaValue);
                this.lastCompositeAlphaRule = alphaRule;
                this.lastCompositeAlphaValue = alphaValue;
                this.fChangeFlag |= 0x10;
            } else {
                this.fChangeFlag &= 0xFFFFFFEF;
            }
        } else {
            this.fChangeFlag &= 0xFFFFFFEF;
        }
    }

    void setupStroke(SunGraphics2D sg2d) {
        BasicStroke stroke = defaultBasicStroke;
        if (sg2d.stroke instanceof BasicStroke) {
            stroke = (BasicStroke)sg2d.stroke;
        }
        if (this.lastStroke != stroke) {
            this.fGraphicsStatesObject[3] = stroke.getDashArray();
            this.fGraphicsStatesFloat.put(42, stroke.getDashPhase());
            this.fGraphicsStatesInt.put(40, stroke.getEndCap());
            this.fGraphicsStatesInt.put(39, stroke.getLineJoin());
            this.fGraphicsStatesFloat.put(41, stroke.getLineWidth());
            this.fGraphicsStatesFloat.put(43, stroke.getMiterLimit());
            this.fChangeFlag |= 0x20;
            this.lastStroke = stroke;
        } else {
            this.fChangeFlag &= 0xFFFFFFDF;
        }
    }

    void setupFont(Font font, Paint paint) {
        if (font == null) {
            return;
        }
        if (font != this.lastFont || (this.fChangeFlag & 8) != 0) {
            this.fGraphicsStatesObject[4] = font;
            this.fGraphicsStatesObject[5] = paint;
            this.fChangeFlag |= 0x80;
            this.lastFont = font;
        } else {
            this.fChangeFlag &= 0xFFFFFF7F;
        }
    }

    void setupRenderingHints(SunGraphics2D sg2d) {
        Object hintValue;
        int interpolationHint;
        boolean hintsChanged = false;
        int antialiasHint = sg2d.antialiasHint;
        if (this.fGraphicsStatesInt.get(44) != antialiasHint) {
            this.fGraphicsStatesInt.put(44, antialiasHint);
            hintsChanged = true;
        }
        int textAntialiasHint = sg2d.textAntialiasHint;
        if (this.fGraphicsStatesInt.get(45) != textAntialiasHint) {
            this.fGraphicsStatesInt.put(45, textAntialiasHint);
            hintsChanged = true;
        }
        int fractionalMetricsHint = sg2d.fractionalMetricsHint;
        if (this.fGraphicsStatesInt.get(46) != fractionalMetricsHint) {
            this.fGraphicsStatesInt.put(46, fractionalMetricsHint);
            hintsChanged = true;
        }
        int renderHint = sg2d.renderHint;
        if (this.fGraphicsStatesInt.get(47) != renderHint) {
            this.fGraphicsStatesInt.put(47, renderHint);
            hintsChanged = true;
        }
        int n = interpolationHint = (hintValue = sg2d.getRenderingHint(RenderingHints.KEY_INTERPOLATION)) != null ? ((SunHints.Value)hintValue).getIndex() : -1;
        if (this.fGraphicsStatesInt.get(48) != interpolationHint) {
            this.fGraphicsStatesInt.put(48, interpolationHint);
            hintsChanged = true;
        }
        this.fChangeFlag = hintsChanged ? (this.fChangeFlag |= 0x40) : (this.fChangeFlag &= 0xFFFFFFBF);
    }

    void setupGraphicsState(SunGraphics2D sg2d, int primitiveType) {
        this.setupGraphicsState(sg2d, primitiveType, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
    }

    void setupGraphicsState(SunGraphics2D sg2d, int primitiveType, int x, int y, int w, int h) {
        this.setupGraphicsState(sg2d, primitiveType, sg2d.font, x, y, w, h);
    }

    void setupGraphicsState(SunGraphics2D sg2d, int primitiveType, Font font, int x, int y, int w, int h) {
        this.fChangeFlag = 0;
        this.setUserBounds(sg2d, x, y, w, h);
        Thread thread = Thread.currentThread();
        if (this.sg2dCurrent != sg2d || this.threadCurrent != thread) {
            this.sg2dCurrent = sg2d;
            this.threadCurrent = thread;
            this.setupClip(sg2d);
            this.setupTransform(sg2d);
            this.setupPaint(sg2d, x, y, w, h);
            this.setupComposite(sg2d);
            this.setupStroke(sg2d);
            this.setupFont(font, sg2d.paint);
            this.setupRenderingHints(sg2d);
            this.fChangeFlag = -1;
        } else {
            int rendererType = OSXSurfaceData.getRendererTypeForPrimitive(primitiveType);
            this.setupClip(sg2d);
            this.setupTransform(sg2d);
            if (rendererType != 3) {
                this.setupComposite(sg2d);
                this.setupRenderingHints(sg2d);
                if (rendererType != 1) {
                    this.setupPaint(sg2d, x, y, w, h);
                    this.setupStroke(sg2d);
                }
                if (rendererType != 0) {
                    this.setupFont(font, sg2d.paint);
                }
            }
        }
        this.fGraphicsStatesInt.put(0, this.fChangeFlag);
    }

    boolean isCustomPaint(SunGraphics2D sg2d) {
        return !(sg2d.paint instanceof Color) && !(sg2d.paint instanceof SystemColor) && !(sg2d.paint instanceof GradientPaint) && !(sg2d.paint instanceof TexturePaint);
    }

    int getPathLength(GeneralPath gp) {
        int length = 0;
        PathIterator pi = gp.getPathIterator(null);
        while (!pi.isDone()) {
            pi.next();
            ++length;
        }
        return length;
    }

    int getPathCoordinates(GeneralPath gp, FloatBuffer coordinates, IntBuffer types) {
        boolean skip = false;
        coordinates.clear();
        types.clear();
        PathIterator pi = gp.getPathIterator(null);
        while (!pi.isDone()) {
            skip = false;
            int type = pi.currentSegment(this.segmentCoordinatesArray);
            switch (type) {
                case 0: {
                    if (this.segmentCoordinatesArray[0] < 1.7014117E38f && this.segmentCoordinatesArray[0] > -1.7014117E38f && this.segmentCoordinatesArray[1] < 1.7014117E38f && this.segmentCoordinatesArray[1] > -1.7014117E38f) {
                        coordinates.put(this.segmentCoordinatesArray[0]);
                        coordinates.put(this.segmentCoordinatesArray[1]);
                        break;
                    }
                    skip = true;
                    break;
                }
                case 1: {
                    if (this.segmentCoordinatesArray[0] < 1.7014117E38f && this.segmentCoordinatesArray[0] > -1.7014117E38f && this.segmentCoordinatesArray[1] < 1.7014117E38f && this.segmentCoordinatesArray[1] > -1.7014117E38f) {
                        coordinates.put(this.segmentCoordinatesArray[0]);
                        coordinates.put(this.segmentCoordinatesArray[1]);
                        break;
                    }
                    skip = true;
                    break;
                }
                case 2: {
                    if (this.segmentCoordinatesArray[0] < 1.7014117E38f && this.segmentCoordinatesArray[0] > -1.7014117E38f && this.segmentCoordinatesArray[1] < 1.7014117E38f && this.segmentCoordinatesArray[1] > -1.7014117E38f && this.segmentCoordinatesArray[2] < 1.7014117E38f && this.segmentCoordinatesArray[2] > -1.7014117E38f && this.segmentCoordinatesArray[3] < 1.7014117E38f && this.segmentCoordinatesArray[3] > -1.7014117E38f) {
                        coordinates.put(this.segmentCoordinatesArray[0]);
                        coordinates.put(this.segmentCoordinatesArray[1]);
                        coordinates.put(this.segmentCoordinatesArray[2]);
                        coordinates.put(this.segmentCoordinatesArray[3]);
                        break;
                    }
                    skip = true;
                    break;
                }
                case 3: {
                    if (this.segmentCoordinatesArray[0] < 1.7014117E38f && this.segmentCoordinatesArray[0] > -1.7014117E38f && this.segmentCoordinatesArray[1] < 1.7014117E38f && this.segmentCoordinatesArray[1] > -1.7014117E38f && this.segmentCoordinatesArray[2] < 1.7014117E38f && this.segmentCoordinatesArray[2] > -1.7014117E38f && this.segmentCoordinatesArray[3] < 1.7014117E38f && this.segmentCoordinatesArray[3] > -1.7014117E38f && this.segmentCoordinatesArray[4] < 1.7014117E38f && this.segmentCoordinatesArray[4] > -1.7014117E38f && this.segmentCoordinatesArray[5] < 1.7014117E38f && this.segmentCoordinatesArray[5] > -1.7014117E38f) {
                        coordinates.put(this.segmentCoordinatesArray[0]);
                        coordinates.put(this.segmentCoordinatesArray[1]);
                        coordinates.put(this.segmentCoordinatesArray[2]);
                        coordinates.put(this.segmentCoordinatesArray[3]);
                        coordinates.put(this.segmentCoordinatesArray[4]);
                        coordinates.put(this.segmentCoordinatesArray[5]);
                        break;
                    }
                    skip = true;
                    break;
                }
            }
            if (!skip) {
                types.put(type);
            }
            pi.next();
        }
        return pi.getWindingRule();
    }

    public void doLine(CRenderer renderer, SunGraphics2D sg2d, float x1, float y1, float x2, float y2) {
        this.setupGraphicsState(sg2d, 5, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        renderer.doLine(this, x1, y1, x2, y2);
    }

    public void doRect(CRenderer renderer, SunGraphics2D sg2d, float x, float y, float width, float height, boolean isfill) {
        if (isfill && this.isCustomPaint(sg2d)) {
            this.setupGraphicsState(sg2d, 6, (int)x, (int)y, (int)width, (int)height);
        } else {
            this.setupGraphicsState(sg2d, 6, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        renderer.doRect(this, x, y, width, height, isfill);
    }

    public void doRoundRect(CRenderer renderer, SunGraphics2D sg2d, float x, float y, float width, float height, float arcW, float arcH, boolean isfill) {
        if (isfill && this.isCustomPaint(sg2d)) {
            this.setupGraphicsState(sg2d, 7, (int)x, (int)y, (int)width, (int)height);
        } else {
            this.setupGraphicsState(sg2d, 7, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        renderer.doRoundRect(this, x, y, width, height, arcW, arcH, isfill);
    }

    public void doOval(CRenderer renderer, SunGraphics2D sg2d, float x, float y, float width, float height, boolean isfill) {
        if (isfill && this.isCustomPaint(sg2d)) {
            this.setupGraphicsState(sg2d, 8, (int)x, (int)y, (int)width, (int)height);
        } else {
            this.setupGraphicsState(sg2d, 8, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        renderer.doOval(this, x, y, width, height, isfill);
    }

    public void doArc(CRenderer renderer, SunGraphics2D sg2d, float x, float y, float width, float height, float startAngle, float arcAngle, int type, boolean isfill) {
        if (isfill && this.isCustomPaint(sg2d)) {
            this.setupGraphicsState(sg2d, 9, (int)x, (int)y, (int)width, (int)height);
        } else {
            this.setupGraphicsState(sg2d, 9, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        renderer.doArc(this, x, y, width, height, startAngle, arcAngle, type, isfill);
    }

    public void doPolygon(CRenderer renderer, SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints, boolean ispolygon, boolean isfill) {
        if (isfill && this.isCustomPaint(sg2d)) {
            int minx = xpoints[0];
            int miny = ypoints[0];
            int maxx = minx;
            int maxy = miny;
            for (int i = 1; i < npoints; ++i) {
                int x = xpoints[i];
                if (x < minx) {
                    minx = x;
                } else if (x > maxx) {
                    maxx = x;
                }
                int y = ypoints[i];
                if (y < miny) {
                    miny = y;
                    continue;
                }
                if (y <= maxy) continue;
                maxy = y;
            }
            this.setupGraphicsState(sg2d, 10, minx, miny, maxx - minx, maxy - miny);
        } else {
            this.setupGraphicsState(sg2d, 10, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        renderer.doPoly(this, xpoints, ypoints, npoints, ispolygon, isfill);
    }

    public void drawfillShape(CRenderer renderer, SunGraphics2D sg2d, GeneralPath gp, boolean isfill, boolean shouldApplyOffset) {
        if (isfill && this.isCustomPaint(sg2d)) {
            Rectangle bounds = gp.getBounds();
            this.setupGraphicsState(sg2d, 11, bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            this.setupGraphicsState(sg2d, 11, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
        int shapeLength = this.getPathLength(gp);
        if (this.shapeCoordinatesArray == null || this.shapeCoordinatesArray.capacity() < shapeLength * 6) {
            this.shapeCoordinatesArray = OSXSurfaceData.getBufferOfSize(shapeLength * 6).asFloatBuffer();
        }
        if (this.shapeTypesArray == null || this.shapeTypesArray.capacity() < shapeLength) {
            this.shapeTypesArray = OSXSurfaceData.getBufferOfSize(shapeLength).asIntBuffer();
        }
        int windingRule = this.getPathCoordinates(gp, this.shapeCoordinatesArray, this.shapeTypesArray);
        renderer.doShape(this, shapeLength, this.shapeCoordinatesArray, this.shapeTypesArray, windingRule, isfill, shouldApplyOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blitImage(CRenderer renderer, SunGraphics2D sg2d, SurfaceData img, boolean fliph, boolean flipv, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, Color bgColor) {
        OSXOffScreenSurfaceData osxsd = (OSXOffScreenSurfaceData)img;
        Object object = osxsd.getLockObject();
        synchronized (object) {
            int w = osxsd.bim.getWidth();
            int h = osxsd.bim.getHeight();
            this.setupGraphicsState(sg2d, 1, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
            if (bgColor != null) {
                img = osxsd.getCopyWithBgColor(bgColor);
            }
            renderer.doImage(this, img, fliph, flipv, w, h, sx, sy, sw, sh, dx, dy, dw, dh);
        }
    }

    public void drawString(CTextPipe renderer, SunGraphics2D sg2d, long nativeStrikePtr, String str, double x, double y) {
        if (str.length() == 0) {
            return;
        }
        this.setupGraphicsState(sg2d, 13, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        renderer.doDrawString(this, nativeStrikePtr, str, x, y);
    }

    public void drawGlyphs(CTextPipe renderer, SunGraphics2D sg2d, long nativeStrikePtr, GlyphVector gv, float x, float y) {
        this.setupGraphicsState(sg2d, 14, gv.getFont(), 0, 0, this.fBounds.width, this.fBounds.height);
        renderer.doDrawGlyphs(this, nativeStrikePtr, gv, x, y);
    }

    public void drawUnicodes(CTextPipe renderer, SunGraphics2D sg2d, long nativeStrikePtr, char[] unicodes, int offset, int length, float x, float y) {
        this.setupGraphicsState(sg2d, 15, sg2d.font, 0, 0, this.fBounds.width, this.fBounds.height);
        if (length == 1) {
            renderer.doOneUnicode(this, nativeStrikePtr, unicodes[offset], x, y);
        } else {
            renderer.doUnicodes(this, nativeStrikePtr, unicodes, offset, length, x, y);
        }
    }

    void intersection(Rectangle r1, Rectangle r2, Rectangle r3) {
        int tx1 = r1.x;
        int ty1 = r1.y;
        long tx2 = tx1 + r1.width;
        long ty2 = ty1 + r1.height;
        int rx1 = r2.x;
        int ry1 = r2.y;
        long rx2 = rx1 + r2.width;
        long ry2 = ry1 + r2.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        r3.setBounds(tx1, ty1, (int)tx2, (int)ty2);
    }

    protected Rectangle clipCopyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        this.copyAreaBounds.setBounds(sg2d.devClip.getLoX(), sg2d.devClip.getLoY(), sg2d.devClip.getWidth(), sg2d.devClip.getHeight());
        this.srcCopyAreaRect.setBounds(x += sg2d.transX, y += sg2d.transY, w, h);
        this.intersection(this.srcCopyAreaRect, this.copyAreaBounds, this.srcCopyAreaRect);
        if (this.srcCopyAreaRect.width <= 0 || this.srcCopyAreaRect.height <= 0) {
            return null;
        }
        this.dstCopyAreaRect.setBounds(this.srcCopyAreaRect.x + dx, this.srcCopyAreaRect.y + dy, this.srcCopyAreaRect.width, this.srcCopyAreaRect.height);
        this.intersection(this.dstCopyAreaRect, this.copyAreaBounds, this.dstCopyAreaRect);
        if (this.dstCopyAreaRect.width <= 0 || this.dstCopyAreaRect.height <= 0) {
            return null;
        }
        x = this.dstCopyAreaRect.x - dx;
        y = this.dstCopyAreaRect.y - dy;
        w = this.dstCopyAreaRect.width;
        h = this.dstCopyAreaRect.height;
        this.finalCopyAreaRect.setBounds(x, y, w, h);
        return this.finalCopyAreaRect;
    }

    protected void markDirty(boolean markAsDirty) {
    }

    @Override
    public boolean canRenderLCDText(SunGraphics2D sg2d) {
        return sg2d.compositeState <= 0 && sg2d.paintState <= 1 && sg2d.clipState <= 1 && sg2d.antialiasHint != 2;
    }

    public static boolean IsSimpleColor(Object c) {
        return c instanceof Color || c instanceof SystemColor || c instanceof ColorUIResource;
    }

    static {
        sQuartzPipe = new CRenderer();
        sIdentityMatrix = new AffineTransform();
        defaultBasicStroke = new BasicStroke();
    }

    public static interface CGContextDrawable {
        public void drawIntoCGContext(long var1);
    }
}

