/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsDevice;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.macosx.CPlatformView;

public final class CGLGraphicsConfig
extends CGraphicsConfig
implements OGLGraphicsConfig {
    private static final int kOpenGLSwapInterval = 0;
    private static boolean cglAvailable;
    private static ImageCapabilities imageCaps;
    private int pixfmt;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;
    private final Object disposerReferent = new Object();
    private final int maxTextureSize;

    private static native boolean initCGL();

    private static native long getCGLConfigInfo(int var0, int var1, int var2);

    private static native int getOGLCapabilities(long var0);

    private static native int nativeGetMaxTextureSize();

    private CGLGraphicsConfig(CGraphicsDevice device, int pixfmt, long configInfo, int maxTextureSize, ContextCapabilities oglCaps) {
        super(device);
        this.pixfmt = pixfmt;
        this.pConfigInfo = configInfo;
        this.oglCaps = oglCaps;
        this.maxTextureSize = maxTextureSize;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
        Disposer.addRecord(this.disposerReferent, new CGLGCDisposerRecord(this.pConfigInfo));
    }

    @Override
    public Object getProxyKey() {
        return this;
    }

    @Override
    public SurfaceData createManagedSurface(int w, int h, int transparency) {
        return CGLSurfaceData.createData(this, w, h, this.getColorModel(transparency), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGLGraphicsConfig getConfig(CGraphicsDevice device, int pixfmt) {
        if (!cglAvailable) {
            return null;
        }
        long cfginfo = 0L;
        int textureSize = 0;
        String[] ids = new String[1];
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
            cfginfo = CGLGraphicsConfig.getCGLConfigInfo(device.getCGDisplayID(), pixfmt, 0);
            if (cfginfo != 0L) {
                textureSize = CGLGraphicsConfig.nativeGetMaxTextureSize();
                textureSize = textureSize <= 16384 ? textureSize / 2 : 8192;
                OGLContext.setScratchSurface(cfginfo);
                rq.flushAndInvokeNow(() -> {
                    ids[0] = OGLContext.getOGLIdString();
                });
            }
        }
        finally {
            rq.unlock();
        }
        if (cfginfo == 0L) {
            return null;
        }
        int oglCaps = CGLGraphicsConfig.getOGLCapabilities(cfginfo);
        OGLContext.OGLContextCaps caps = new OGLContext.OGLContextCaps(oglCaps, ids[0]);
        return new CGLGraphicsConfig(device, pixfmt, cfginfo, textureSize, caps);
    }

    public static boolean isCGLAvailable() {
        return cglAvailable;
    }

    @Override
    public boolean isCapPresent(int cap) {
        return (this.oglCaps.getCaps() & cap) != 0;
    }

    @Override
    public long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    @Override
    public OGLContext getContext() {
        return this.context;
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        DirectColorModel model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster raster = ((ColorModel)model).createCompatibleWritableRaster(width, height);
        return new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace cs = ColorSpace.getInstance(1000);
                return new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public boolean isDoubleBuffered() {
        return this.isCapPresent(65536);
    }

    public synchronized void displayChanged() {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            rq.unlock();
        }
    }

    public String toString() {
        int displayID = this.getDevice().getCGDisplayID();
        return "CGLGraphicsConfig[dev=" + displayID + ",pixfmt=" + this.pixfmt + "]";
    }

    @Override
    public SurfaceData createSurfaceData(CPlatformView pView) {
        return CGLSurfaceData.createData(pView);
    }

    @Override
    public SurfaceData createSurfaceData(CGLLayer layer) {
        return CGLSurfaceData.createData(layer);
    }

    @Override
    public Image createAcceleratedImage(Component target, int width, int height) {
        ColorModel model = this.getColorModel(1);
        WritableRaster wr = model.createCompatibleWritableRaster(width, height);
        return new OffScreenImage(target, model, wr, model.isAlphaPremultiplied());
    }

    @Override
    public void assertOperationSupported(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers != 2) {
            throw new AWTException("Only double buffering is supported");
        }
        BufferCapabilities configCaps = this.getBufferCapabilities();
        if (!configCaps.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (caps.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    @Override
    public Image createBackBuffer(LWComponentPeer<?, ?> peer) {
        Rectangle r = peer.getBounds();
        int w = Math.max(1, r.width);
        int h = Math.max(1, r.height);
        int transparency = peer.isTranslucent() ? 3 : 1;
        return new SunVolatileImage(this, w, h, transparency, null);
    }

    @Override
    public void destroyBackBuffer(Image backBuffer) {
        if (backBuffer != null) {
            backBuffer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(LWComponentPeer<?, ?> peer, Image backBuffer, int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        Graphics g = peer.getGraphics();
        try {
            g.drawImage(backBuffer, x1, y1, x2, y2, x1, y1, x2, y2, null);
        }
        finally {
            g.dispose();
        }
        if (flipAction == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics2D bg = (Graphics2D)backBuffer.getGraphics();
            try {
                bg.setBackground(peer.getBackground());
                bg.clearRect(0, 0, backBuffer.getWidth(null), backBuffer.getHeight(null));
            }
            finally {
                bg.dispose();
            }
        }
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new CGLBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency, int type) {
        AccelTypedVolatileImage vi;
        Surface sd;
        if (type == 4 || type == 1 || type == 0 || transparency == 2) {
            return null;
        }
        if (type == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (type == 2) {
            boolean isOpaque;
            boolean bl = isOpaque = transparency == 1;
            if (!isOpaque && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((sd = (vi = new AccelTypedVolatileImage((GraphicsConfiguration)this, width, height, transparency, type)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)sd).getType() != type) {
            vi.flush();
            vi = null;
        }
        return vi;
    }

    @Override
    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    @Override
    public void addDeviceEventListener(AccelDeviceEventListener l) {
        int displayID = this.getDevice().getCGDisplayID();
        AccelDeviceEventNotifier.addListener(l, displayID);
    }

    @Override
    public void removeDeviceEventListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.removeListener(l);
    }

    @Override
    public int getMaxTextureWidth() {
        return Math.max(this.maxTextureSize / this.getDevice().getScaleFactor(), this.getBounds().width);
    }

    @Override
    public int getMaxTextureHeight() {
        return Math.max(this.maxTextureSize / this.getDevice().getScaleFactor(), this.getBounds().height);
    }

    static {
        imageCaps = new CGLImageCaps();
        cglAvailable = CGLGraphicsConfig.initCGL();
    }

    private static class CGLImageCaps
    extends ImageCapabilities {
        private CGLImageCaps() {
            super(true);
        }

        @Override
        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class CGLBufferCaps
    extends BufferCapabilities {
        public CGLBufferCaps(boolean dblBuf) {
            super(imageCaps, imageCaps, dblBuf ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class CGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;

        public CGLGCDisposerRecord(long pCfgInfo) {
            this.pCfgInfo = pCfgInfo;
        }

        @Override
        public void dispose() {
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }
}

