/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.lwawt.macosx.CPlatformView;

public abstract class CGLSurfaceData
extends OGLSurfaceData {
    protected final int scale;
    protected final int width;
    protected final int height;
    protected CPlatformView pView;
    private CGLGraphicsConfig graphicsConfig;

    native void validate(int var1, int var2, int var3, int var4, boolean var5);

    private native void initOps(OGLGraphicsConfig var1, long var2, long var4, long var6, int var8, int var9, boolean var10);

    @Override
    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected CGLSurfaceData(CGLGraphicsConfig gc, ColorModel cm, int type, int width, int height) {
        super(gc, cm, type);
        this.scale = type == 3 ? 1 : gc.getDevice().getScaleFactor();
        this.width = width * this.scale;
        this.height = height * this.scale;
    }

    protected CGLSurfaceData(CPlatformView pView, CGLGraphicsConfig gc, ColorModel cm, int type, int width, int height) {
        this(gc, cm, type, width, height);
        this.pView = pView;
        this.graphicsConfig = gc;
        long pConfigInfo = gc.getNativeConfigInfo();
        long pPeerData = 0L;
        boolean isOpaque = true;
        if (pView != null) {
            pPeerData = pView.getAWTView();
            isOpaque = pView.isOpaque();
        }
        this.initOps(gc, pConfigInfo, pPeerData, 0L, 0, 0, isOpaque);
    }

    protected CGLSurfaceData(CGLLayer layer, CGLGraphicsConfig gc, ColorModel cm, int type, int width, int height) {
        this(gc, cm, type, width, height);
        this.graphicsConfig = gc;
        long pConfigInfo = gc.getNativeConfigInfo();
        long layerPtr = 0L;
        boolean isOpaque = true;
        if (layer != null) {
            layerPtr = layer.getPointer();
            isOpaque = layer.isOpaque();
        }
        this.initOps(gc, pConfigInfo, 0L, layerPtr, 0, 0, isOpaque);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static CGLWindowSurfaceData createData(CPlatformView pView) {
        CGLGraphicsConfig gc = CGLSurfaceData.getGC(pView);
        return new CGLWindowSurfaceData(pView, gc);
    }

    public static CGLLayerSurfaceData createData(CGLLayer layer) {
        CGLGraphicsConfig gc = CGLSurfaceData.getGC(layer);
        Rectangle r = layer.getBounds();
        return new CGLLayerSurfaceData(layer, gc, r.width, r.height);
    }

    public static CGLOffScreenSurfaceData createData(CPlatformView pView, Image image, int type) {
        CGLGraphicsConfig gc = CGLSurfaceData.getGC(pView);
        Rectangle r = pView.getBounds();
        if (type == 4) {
            return new CGLOffScreenSurfaceData(pView, gc, r.width, r.height, image, gc.getColorModel(), 4);
        }
        return new CGLVSyncOffScreenSurfaceData(pView, gc, r.width, r.height, image, gc.getColorModel(), type);
    }

    public static CGLOffScreenSurfaceData createData(CGLGraphicsConfig gc, int width, int height, ColorModel cm, Image image, int type) {
        return new CGLOffScreenSurfaceData(null, gc, width, height, image, cm, type);
    }

    public static CGLGraphicsConfig getGC(CPlatformView pView) {
        if (pView != null) {
            return (CGLGraphicsConfig)pView.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (CGLGraphicsConfig)gd.getDefaultConfiguration();
    }

    public static CGLGraphicsConfig getGC(CGLLayer layer) {
        return (CGLGraphicsConfig)layer.getGraphicsConfiguration();
    }

    public void validate() {
    }

    @Override
    public int getDefaultScale() {
        return this.scale;
    }

    @Override
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        int state = sg2d.transformState;
        if (state > 3 || sg2d.compositeState >= 2) {
            return false;
        }
        if (state <= 2) {
            x += sg2d.transX;
            y += sg2d.transY;
        } else if (state == 3) {
            double[] coords = new double[]{x, y, x + w, y + h, x + dx, y + dy};
            sg2d.transform.transform(coords, 0, coords, 0, 3);
            x = (int)Math.ceil(coords[0] - 0.5);
            y = (int)Math.ceil(coords[1] - 0.5);
            w = (int)Math.ceil(coords[2] - 0.5) - x;
            h = (int)Math.ceil(coords[3] - 0.5) - y;
            dx = (int)Math.ceil(coords[4] - 0.5) - x;
            dy = (int)Math.ceil(coords[5] - 0.5) - y;
        }
        oglRenderPipe.copyArea(sg2d, x, y, w, h, dx, dy);
        return true;
    }

    protected native void clearWindow();

    private static native long createCGLContextOnSurface(CGLSurfaceData var0, long var1);

    public static long createOGLContextOnSurface(Graphics g, long sharedContext) {
        SurfaceData sd = ((SunGraphics2D)g).surfaceData;
        if (sd instanceof CGLSurfaceData) {
            CGLSurfaceData cglsd = (CGLSurfaceData)sd;
            return CGLSurfaceData.createCGLContextOnSurface(cglsd, sharedContext);
        }
        return 0L;
    }

    static native boolean makeCGLContextCurrentOnSurface(CGLSurfaceData var0, long var1);

    public static boolean makeOGLContextCurrentOnSurface(Graphics g, long ctx) {
        SurfaceData sd = ((SunGraphics2D)g).surfaceData;
        if (ctx != 0L && sd instanceof CGLSurfaceData) {
            CGLSurfaceData cglsd = (CGLSurfaceData)sd;
            return CGLSurfaceData.makeCGLContextCurrentOnSurface(cglsd, ctx);
        }
        return false;
    }

    private static native void destroyCGLContext(long var0);

    public static void destroyOGLContext(long ctx) {
        if (ctx != 0L) {
            CGLSurfaceData.destroyCGLContext(ctx);
        }
    }

    public static class CGLOffScreenSurfaceData
    extends CGLSurfaceData {
        private Image offscreenImage;

        public CGLOffScreenSurfaceData(CPlatformView pView, CGLGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(pView, gc, cm, type, width, height);
            this.offscreenImage = image;
            this.initSurface(this.width, this.height);
        }

        @Override
        public SurfaceData getReplacement() {
            return CGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle r = this.pView.getBounds();
                return new Rectangle(0, 0, r.width, r.height);
            }
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class CGLVSyncOffScreenSurfaceData
    extends CGLOffScreenSurfaceData {
        private CGLOffScreenSurfaceData flipSurface;

        public CGLVSyncOffScreenSurfaceData(CPlatformView pView, CGLGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(pView, gc, width, height, image, cm, type);
            this.flipSurface = CGLSurfaceData.createData(pView, image, 4);
        }

        public SurfaceData getFlipSurface() {
            return this.flipSurface;
        }

        @Override
        public void flush() {
            this.flipSurface.flush();
            super.flush();
        }
    }

    public static class CGLLayerSurfaceData
    extends CGLSurfaceData {
        private CGLLayer layer;

        public CGLLayerSurfaceData(CGLLayer layer, CGLGraphicsConfig gc, int width, int height) {
            super(layer, gc, gc.getColorModel(), 5, width, height);
            this.layer = layer;
            this.initSurface(this.width, this.height);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.layer.getSurfaceData();
        }

        @Override
        boolean isOnScreen() {
            return true;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.layer.getDestination();
        }

        @Override
        public int getTransparency() {
            return this.layer.getTransparency();
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.clearWindow();
        }
    }

    public static class CGLWindowSurfaceData
    extends CGLSurfaceData {
        public CGLWindowSurfaceData(CPlatformView pView, CGLGraphicsConfig gc) {
            super(pView, gc, gc.getColorModel(), 1, 0, 0);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.pView.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle r = this.pView.getBounds();
            return new Rectangle(0, 0, r.width, r.height);
        }

        @Override
        public Object getDestination() {
            return this.pView.getDestination();
        }

        @Override
        public void validate() {
            OGLRenderQueue rq = OGLRenderQueue.getInstance();
            rq.lock();
            try {
                rq.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle peerBounds = pView.getBounds();
                        this.validate(0, 0, peerBounds.width, peerBounds.height, pView.isOpaque());
                    }
                });
            }
            finally {
                rq.unlock();
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.clearWindow();
        }
    }
}

