/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import java.awt.peer.ComponentPeer;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.BackBufferCapsProvider;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;

public class CGLVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public CGLVolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
        int transparency = vImg.getTransparency();
        CGLGraphicsConfig gc = (CGLGraphicsConfig)vImg.getGraphicsConfig();
        this.accelerationEnabled = transparency == 1 || transparency == 3 && (gc.isCapPresent(12) || gc.isCapPresent(2));
    }

    @Override
    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    @Override
    protected SurfaceData initAcceleratedSurface() {
        CGLSurfaceData.CGLOffScreenSurfaceData sData = null;
        Component comp = this.vImg.getComponent();
        ComponentPeer peer = comp != null ? comp.getPeer() : null;
        try {
            ExtendedBufferCapabilities ebc;
            BackBufferCapsProvider provider;
            BufferCapabilities caps;
            boolean createVSynced = false;
            boolean forceback = false;
            if (this.context instanceof Boolean && (forceback = ((Boolean)this.context).booleanValue()) && peer instanceof BackBufferCapsProvider && (caps = (provider = (BackBufferCapsProvider)((Object)peer)).getBackBufferCaps()) instanceof ExtendedBufferCapabilities && (ebc = (ExtendedBufferCapabilities)caps).getVSync() == ExtendedBufferCapabilities.VSyncType.VSYNC_ON && ebc.getFlipContents() == BufferCapabilities.FlipContents.COPIED) {
                createVSynced = true;
                forceback = false;
            }
            if (!forceback) {
                CGLGraphicsConfig gc = (CGLGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel cm = gc.getColorModel(this.vImg.getTransparency());
                int type = this.vImg.getForcedAccelSurfaceType();
                if (type == 0) {
                    int n = type = gc.isCapPresent(12) ? 5 : 2;
                }
                if (!createVSynced) {
                    sData = CGLSurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, type);
                }
            }
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    @Override
    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return gc == null || gc == this.vImg.getGraphicsConfig();
    }

    @Override
    public void initContents() {
        if (this.vImg.getForcedAccelSurfaceType() != 3) {
            super.initContents();
        }
    }
}

