/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.awt.SunToolkit;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.TransformBlit;
import sun.java2d.pipe.Region;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

class XRPMTransformedBlit
extends TransformBlit {
    final Rectangle compositeBounds = new Rectangle();
    final double[] srcCoords = new double[8];
    final double[] dstCoords = new double[8];

    public XRPMTransformedBlit(SurfaceType srcType, SurfaceType dstType) {
        super(srcType, CompositeType.AnyAlpha, dstType);
    }

    protected void adjustCompositeBounds(boolean isQuadrantRotated, AffineTransform tr, int dstx, int dsty, int width, int height) {
        double maxY;
        double maxX;
        double minY;
        double minX;
        this.srcCoords[0] = dstx;
        this.srcCoords[1] = dsty;
        this.srcCoords[2] = dstx + width;
        this.srcCoords[3] = dsty + height;
        if (isQuadrantRotated) {
            tr.transform(this.srcCoords, 0, this.dstCoords, 0, 2);
            minX = Math.min(this.dstCoords[0], this.dstCoords[2]);
            minY = Math.min(this.dstCoords[1], this.dstCoords[3]);
            maxX = Math.max(this.dstCoords[0], this.dstCoords[2]);
            maxY = Math.max(this.dstCoords[1], this.dstCoords[3]);
            minX = Math.ceil(minX - 0.5);
            minY = Math.ceil(minY - 0.5);
            maxX = Math.ceil(maxX - 0.5);
            maxY = Math.ceil(maxY - 0.5);
        } else {
            this.srcCoords[4] = dstx;
            this.srcCoords[5] = dsty + height;
            this.srcCoords[6] = dstx + width;
            this.srcCoords[7] = dsty;
            tr.transform(this.srcCoords, 0, this.dstCoords, 0, 4);
            minX = Math.min(this.dstCoords[0], Math.min(this.dstCoords[2], Math.min(this.dstCoords[4], this.dstCoords[6])));
            minY = Math.min(this.dstCoords[1], Math.min(this.dstCoords[3], Math.min(this.dstCoords[5], this.dstCoords[7])));
            maxX = Math.max(this.dstCoords[0], Math.max(this.dstCoords[2], Math.max(this.dstCoords[4], this.dstCoords[6])));
            maxY = Math.max(this.dstCoords[1], Math.max(this.dstCoords[3], Math.max(this.dstCoords[5], this.dstCoords[7])));
            minX = Math.floor(minX);
            minY = Math.floor(minY);
            maxX = Math.ceil(maxX);
            maxY = Math.ceil(maxY);
        }
        this.compositeBounds.x = (int)minX;
        this.compositeBounds.y = (int)minY;
        this.compositeBounds.width = (int)(maxX - minX);
        this.compositeBounds.height = (int)(maxY - minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Transform(SurfaceData src, SurfaceData dst, Composite comp, Region clip, AffineTransform xform, int hint, int srcx, int srcy, int dstx, int dsty, int width, int height) {
        try {
            SunToolkit.awtLock();
            XRSurfaceData x11sdDst = (XRSurfaceData)dst;
            XRSurfaceData x11sdSrc = (XRSurfaceData)src;
            XRCompositeManager xrMgr = XRCompositeManager.getInstance(x11sdSrc);
            float extraAlpha = ((AlphaComposite)comp).getAlpha();
            int filter = XRUtils.ATransOpToXRQuality(hint);
            boolean isQuadrantRotated = XRUtils.isTransformQuadrantRotated(xform);
            this.adjustCompositeBounds(isQuadrantRotated, xform, dstx, dsty, width, height);
            x11sdDst.validateAsDestination(null, clip);
            x11sdDst.maskBuffer.validateCompositeState(comp, null, null, null);
            AffineTransform trx = AffineTransform.getTranslateInstance(-this.compositeBounds.x, -this.compositeBounds.y);
            trx.concatenate(xform);
            AffineTransform maskTX = (AffineTransform)trx.clone();
            trx.translate(-srcx, -srcy);
            try {
                trx.invert();
            }
            catch (NoninvertibleTransformException ex) {
                trx.setToIdentity();
            }
            if (!(filter == 0 || isQuadrantRotated && extraAlpha == 1.0f)) {
                XRMaskImage mask = x11sdSrc.maskBuffer.getMaskImage();
                int maskPicture = isQuadrantRotated ? xrMgr.getExtraAlphaMask() : mask.prepareBlitMask(x11sdDst, maskTX, width, height);
                x11sdSrc.validateAsSource(trx, 2, filter);
                x11sdDst.maskBuffer.con.renderComposite(xrMgr.getCompRule(), x11sdSrc.picture, maskPicture, x11sdDst.picture, 0, 0, 0, 0, this.compositeBounds.x, this.compositeBounds.y, this.compositeBounds.width, this.compositeBounds.height);
            } else {
                int repeat = filter == 0 ? 0 : 2;
                x11sdSrc.validateAsSource(trx, repeat, filter);
                x11sdDst.maskBuffer.compositeBlit(x11sdSrc, x11sdDst, 0, 0, this.compositeBounds.x, this.compositeBounds.y, this.compositeBounds.width, this.compositeBounds.height);
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }
}

