/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.beans.Transient;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWCheckboxPeer
extends LWComponentPeer<Checkbox, CheckboxDelegate>
implements CheckboxPeer,
ItemListener {
    LWCheckboxPeer(Checkbox target, PlatformComponent platformComponent) {
        super(target, platformComponent);
    }

    @Override
    CheckboxDelegate createDelegate() {
        return new CheckboxDelegate();
    }

    @Override
    Component getDelegateFocusOwner() {
        return ((CheckboxDelegate)this.getDelegate()).getCurrentButton();
    }

    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setLabel(((Checkbox)this.getTarget()).getLabel());
        this.setState(((Checkbox)this.getTarget()).getState());
        this.setCheckboxGroup(((Checkbox)this.getTarget()).getCheckboxGroup());
    }

    @Override
    public void itemStateChanged(final ItemEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean postEvent = true;
                CheckboxGroup group = ((Checkbox)LWCheckboxPeer.this.getTarget()).getCheckboxGroup();
                if (group != null) {
                    if (e.getStateChange() == 1) {
                        if (group.getSelectedCheckbox() != LWCheckboxPeer.this.getTarget()) {
                            group.setSelectedCheckbox((Checkbox)LWCheckboxPeer.this.getTarget());
                        } else {
                            postEvent = false;
                        }
                    } else {
                        postEvent = false;
                        if (group.getSelectedCheckbox() == LWCheckboxPeer.this.getTarget()) {
                            ((Checkbox)LWCheckboxPeer.this.getTarget()).setState(true);
                        }
                    }
                } else {
                    ((Checkbox)LWCheckboxPeer.this.getTarget()).setState(e.getStateChange() == 1);
                }
                if (postEvent) {
                    LWCheckboxPeer.this.postEvent(new ItemEvent((ItemSelectable)LWCheckboxPeer.this.getTarget(), 701, ((Checkbox)LWCheckboxPeer.this.getTarget()).getLabel(), e.getStateChange()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckboxGroup(CheckboxGroup g) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().removeItemListener(this);
            ((CheckboxDelegate)this.getDelegate()).setRadioButton(g != null);
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().addItemListener(this);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabel(String label) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).setText(label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(boolean state) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().removeItemListener(this);
            ((CheckboxDelegate)this.getDelegate()).setSelected(state);
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().addItemListener(this);
        }
        this.repaintPeer();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    final class CheckboxDelegate
    extends JComponent {
        private final JCheckBox cb;
        private final JRadioButton rb;

        CheckboxDelegate() {
            this.cb = new JCheckBox(){

                @Override
                public boolean hasFocus() {
                    return ((Checkbox)LWCheckboxPeer.this.getTarget()).hasFocus();
                }
            };
            this.rb = new JRadioButton(){

                @Override
                public boolean hasFocus() {
                    return ((Checkbox)LWCheckboxPeer.this.getTarget()).hasFocus();
                }
            };
            this.setLayout(null);
            this.setRadioButton(false);
            this.add(this.rb);
            this.add(this.cb);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.rb.setEnabled(enabled);
            this.cb.setEnabled(enabled);
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            super.setOpaque(isOpaque);
            this.rb.setOpaque(isOpaque);
            this.cb.setOpaque(isOpaque);
        }

        @Override
        @Deprecated
        public void reshape(int x, int y, int w, int h) {
            super.reshape(x, y, w, h);
            this.cb.setBounds(0, 0, w, h);
            this.rb.setBounds(0, 0, w, h);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getCurrentButton().getPreferredSize();
        }

        @Override
        @Transient
        public Dimension getMinimumSize() {
            return this.getCurrentButton().getMinimumSize();
        }

        void setRadioButton(boolean showRadioButton) {
            this.rb.setVisible(showRadioButton);
            this.cb.setVisible(!showRadioButton);
        }

        @Transient
        JToggleButton getCurrentButton() {
            return this.cb.isVisible() ? this.cb : this.rb;
        }

        void setText(String label) {
            this.cb.setText(label);
            this.rb.setText(label);
        }

        void setSelected(boolean state) {
            this.cb.setSelected(state);
            this.rb.setSelected(state);
        }
    }
}

