/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import com.sun.java.swing.SwingUtilities3;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.pipe.Region;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.LWGraphicsConfig;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWRepaintArea;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CDropTarget;
import sun.util.logging.PlatformLogger;

public abstract class LWComponentPeer<T extends Component, D extends JComponent>
implements ComponentPeer,
DropTargetPeer {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.lwawt.focus.LWComponentPeer");
    private final Object stateLock = new Object();
    private static final Object peerTreeLock = new Object();
    private final T target;
    private final LWContainerPeer<?, ?> containerPeer;
    private final LWWindowPeer windowPeer;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final Rectangle bounds = new Rectangle();
    private Region region;
    private boolean visible = false;
    private boolean enabled = true;
    private Color background;
    private Color foreground;
    private Font font;
    private final RepaintArea targetPaintArea;
    private volatile boolean isLayouting;
    private final D delegate;
    private Container delegateContainer;
    private Component delegateDropTarget;
    private final Object dropTargetLock = new Object();
    private int fNumDropTargets = 0;
    private CDropTarget fDropTarget = null;
    private final PlatformComponent platformComponent;
    static final char WIDE_CHAR = '0';
    private Image backBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LWComponentPeer(T target, PlatformComponent platformComponent) {
        this.targetPaintArea = new LWRepaintArea();
        this.target = target;
        this.platformComponent = platformComponent;
        Container container = SunToolkit.getNativeContainer(target);
        this.containerPeer = (LWContainerPeer)LWToolkit.targetToPeer(container);
        LWWindowPeer lWWindowPeer = this.windowPeer = this.containerPeer != null ? this.containerPeer.getWindowPeerOrSelf() : null;
        if (this.containerPeer != null) {
            this.containerPeer.addChildPeer(this);
        }
        AWTEventListener toolkitListener = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        synchronized (toolkit) {
            try {
                toolkitListener = this.getToolkitAWTEventListener();
                this.setToolkitAWTEventListener(null);
                Object object = this.getDelegateLock();
                synchronized (object) {
                    block13: {
                        this.delegate = this.createDelegate();
                        if (this.delegate != null) {
                            ((JComponent)this.delegate).setVisible(false);
                            this.delegateContainer = new DelegateContainer();
                            this.delegateContainer.add((Component)this.delegate);
                            this.delegateContainer.addNotify();
                            ((JComponent)this.delegate).addNotify();
                            LWComponentPeer.resetColorsAndFont(this.delegate);
                            ((JComponent)this.delegate).setOpaque(true);
                            break block13;
                        }
                        return;
                    }
                }
            }
            finally {
                this.setToolkitAWTEventListener(toolkitListener);
            }
            SwingUtilities3.setDelegateRepaintManager(this.delegate, new RepaintManager(){

                @Override
                public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
                    LWComponentPeer.this.repaintPeer(SwingUtilities.convertRectangle(c, new Rectangle(x, y, w, h), LWComponentPeer.this.getDelegate()));
                }
            });
        }
    }

    protected final AWTEventListener getToolkitAWTEventListener() {
        return AccessController.doPrivileged(new PrivilegedAction<AWTEventListener>(){

            @Override
            public AWTEventListener run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    Field field = Toolkit.class.getDeclaredField("eventListener");
                    field.setAccessible(true);
                    return (AWTEventListener)field.get(toolkit);
                }
                catch (Exception e) {
                    throw new InternalError(e.toString());
                }
            }
        });
    }

    protected final void setToolkitAWTEventListener(final AWTEventListener listener) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    Field field = Toolkit.class.getDeclaredField("eventListener");
                    field.setAccessible(true);
                    field.set(toolkit, listener);
                }
                catch (Exception e) {
                    throw new InternalError(e.toString());
                }
                return null;
            }
        });
    }

    D createDelegate() {
        return null;
    }

    final D getDelegate() {
        return this.delegate;
    }

    Component getDelegateFocusOwner() {
        return this.getDelegate();
    }

    public final void initialize() {
        this.platformComponent.initialize(this.getPlatformWindow());
        this.initializeImpl();
        this.setVisible(((Component)this.target).isVisible());
    }

    void initializeImpl() {
        this.setBackground(((Component)this.target).getBackground());
        this.setForeground(((Component)this.target).getForeground());
        this.setFont(((Component)this.target).getFont());
        this.setBounds(((Component)this.target).getBounds());
        this.setEnabled(((Component)this.target).isEnabled());
    }

    private static void resetColorsAndFont(Container c) {
        c.setBackground(null);
        c.setForeground(null);
        c.setFont(null);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            LWComponentPeer.resetColorsAndFont((Container)c.getComponent(i));
        }
    }

    final Object getStateLock() {
        return this.stateLock;
    }

    final Object getDelegateLock() {
        return ((Component)this.getTarget()).getTreeLock();
    }

    protected static final Object getPeerTreeLock() {
        return peerTreeLock;
    }

    public final T getTarget() {
        return this.target;
    }

    protected final LWWindowPeer getWindowPeer() {
        return this.windowPeer;
    }

    protected LWWindowPeer getWindowPeerOrSelf() {
        return this.getWindowPeer();
    }

    protected final LWContainerPeer<?, ?> getContainerPeer() {
        return this.containerPeer;
    }

    public PlatformWindow getPlatformWindow() {
        LWWindowPeer windowPeer = this.getWindowPeer();
        return windowPeer.getPlatformWindow();
    }

    public LWToolkit getLWToolkit() {
        return LWToolkit.getLWToolkit();
    }

    @Override
    public final void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        this.destroyBuffers();
        LWContainerPeer<?, ?> cp = this.getContainerPeer();
        if (cp != null) {
            cp.removeChildPeer(this);
        }
        this.platformComponent.dispose();
        LWToolkit.targetDisposedPeer(this.getTarget(), this);
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getWindowPeer().getGraphicsConfiguration();
    }

    public final LWGraphicsConfig getLWGC() {
        return (LWGraphicsConfig)((Object)this.getGraphicsConfiguration());
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graphics getGraphics() {
        Graphics g = this.getOnscreenGraphics();
        if (g != null) {
            Object object = LWComponentPeer.getPeerTreeLock();
            synchronized (object) {
                this.applyConstrain(g);
            }
        }
        return g;
    }

    public final Graphics getOnscreenGraphics() {
        LWWindowPeer wp = this.getWindowPeerOrSelf();
        return wp.getOnscreenGraphics(this.getForeground(), this.getBackground(), this.getFont());
    }

    private void applyConstrain(Graphics g) {
        SunGraphics2D sg2d = (SunGraphics2D)g;
        Rectangle size = this.localToWindow(this.getSize());
        sg2d.constrain(size.x, size.y, size.width, size.height, this.getVisibleRegion());
    }

    Region getVisibleRegion() {
        return LWComponentPeer.computeVisibleRect(this, this.getRegion());
    }

    static final Region computeVisibleRect(LWComponentPeer<?, ?> c, Region region) {
        LWContainerPeer<?, ?> p = c.getContainerPeer();
        if (p != null) {
            Rectangle r = c.getBounds();
            region = region.getTranslatedRegion(r.x, r.y);
            region = region.getIntersection(p.getRegion());
            region = region.getIntersection(p.getContentSize());
            region = p.cutChildren(region, c);
            region = LWComponentPeer.computeVisibleRect(p, region);
            region = region.getTranslatedRegion(-r.x, -r.y);
        }
        return region;
    }

    @Override
    public ColorModel getColorModel() {
        return this.getGraphicsConfiguration().getColorModel();
    }

    public boolean isTranslucent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        this.getLWGC().assertOperationSupported(numBuffers, caps);
        Image buffer = this.getLWGC().createBackBuffer(this);
        Object object = this.getStateLock();
        synchronized (object) {
            this.backBuffer = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Image getBackBuffer() {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.backBuffer != null) {
                return this.backBuffer;
            }
        }
        throw new IllegalStateException("Buffers have not been created");
    }

    @Override
    public final void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        this.getLWGC().flip(this, this.getBackBuffer(), x1, y1, x2, y2, flipAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroyBuffers() {
        Image oldBB;
        Object object = this.getStateLock();
        synchronized (object) {
            oldBB = this.backBuffer;
            this.backBuffer = null;
        }
        this.getLWGC().destroyBackBuffer(oldBB);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height, 3);
    }

    @Override
    public void setBounds(int x, int y, int w, int h, int op) {
        this.setBounds(x, y, w, h, op, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBounds(int x, int y, int w, int h, int op, boolean notify, boolean updateTarget) {
        boolean resized;
        Rectangle oldBounds;
        Object object = this.getStateLock();
        synchronized (object) {
            oldBounds = new Rectangle(this.bounds);
            if ((op & 3) != 0) {
                this.bounds.x = x;
                this.bounds.y = y;
            }
            if ((op & 3) != 0) {
                this.bounds.width = w;
                this.bounds.height = h;
            }
        }
        boolean moved = oldBounds.x != x || oldBounds.y != y;
        boolean bl = resized = oldBounds.width != w || oldBounds.height != h;
        if (!moved && !resized) {
            return;
        }
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                this.delegateContainer.setBounds(0, 0, w, h);
                ((Component)delegate).setBounds(this.delegateContainer.getBounds());
                ((Container)delegate).validate();
            }
        }
        Point locationInWindow = this.localToWindow(0, 0);
        this.platformComponent.setBounds(locationInWindow.x, locationInWindow.y, w, h);
        if (notify) {
            this.repaintOldNewBounds(oldBounds);
            if (resized) {
                this.handleResize(w, h, updateTarget);
            }
            if (moved) {
                this.handleMove(x, y, updateTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Rectangle getBounds() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.bounds.getBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Rectangle getSize() {
        Object object = this.getStateLock();
        synchronized (object) {
            return new Rectangle(this.bounds.width, this.bounds.height);
        }
    }

    @Override
    public Point getLocationOnScreen() {
        Point windowLocation = this.getWindowPeer().getLocationOnScreen();
        Point locationInWindow = this.localToWindow(0, 0);
        return new Point(windowLocation.x + locationInWindow.x, windowLocation.y + locationInWindow.y);
    }

    Cursor getCursor(Point p) {
        return ((Component)this.getTarget()).getCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color c) {
        Color oldBg = this.getBackground();
        if (oldBg == c || oldBg != null && oldBg.equals(c)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.background = c;
        }
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)delegate).setBackground(c);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Color getBackground() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.background;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForeground(Color c) {
        Color oldFg = this.getForeground();
        if (oldFg == c || oldFg != null && oldFg.equals(c)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.foreground = c;
        }
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)delegate).setForeground(c);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Color getForeground() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.foreground;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font f) {
        Font oldF = this.getFont();
        if (oldF == f || oldF != null && oldF.equals(f)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.font = f;
        }
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)delegate).setFont(f);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Font getFont() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontMetrics getFontMetrics(Font f) {
        Graphics g = this.getOnscreenGraphics();
        if (g != null) {
            try {
                FontMetrics fontMetrics = g.getFontMetrics(f);
                return fontMetrics;
            }
            finally {
                g.dispose();
            }
        }
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.delegateContainer.getFontMetrics(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean e) {
        boolean status = e;
        LWContainerPeer<?, ?> cp = this.getContainerPeer();
        if (cp != null) {
            status &= cp.isEnabled();
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.enabled == status) {
                return;
            }
            this.enabled = status;
        }
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)delegate).setEnabled(status);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean v) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.visible == v) {
                return;
            }
            this.visible = v;
        }
        this.setVisibleImpl(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean v) {
        D delegate = this.getDelegate();
        if (delegate != null) {
            Object object = this.getDelegateLock();
            synchronized (object) {
                ((JComponent)delegate).setVisible(v);
            }
        }
        if (this.visible) {
            this.repaintPeer();
        } else {
            this.repaintParent(this.getBounds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVisible() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.visible;
        }
    }

    @Override
    public void paint(Graphics g) {
        ((Component)this.getTarget()).paint(g);
    }

    @Override
    public void print(Graphics g) {
        ((Component)this.getTarget()).print(g);
    }

    @Override
    public void reparent(ContainerPeer newContainer) {
        throw new UnsupportedOperationException("ComponentPeer.reparent()");
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void setZOrder(ComponentPeer above) {
        LWContainerPeer<?, ?> cp = this.getContainerPeer();
        cp.setChildPeerZOrder(this, (LWComponentPeer)above);
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
        Rectangle r;
        if (!(e instanceof IgnorePaintEvent) && (r = e.getUpdateRect()) != null && !r.isEmpty()) {
            this.targetPaintArea.add(r, e.getID());
        }
    }

    @Override
    public void layout() {
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        Object object = this.getDelegateLock();
        synchronized (object) {
            size = ((JComponent)this.getDelegate()).getPreferredSize();
        }
        return this.validateSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        Dimension size;
        Object object = this.getDelegateLock();
        synchronized (object) {
            size = ((JComponent)this.getDelegate()).getMinimumSize();
        }
        return this.validateSize(size);
    }

    private Dimension validateSize(Dimension size) {
        if (size.width == 0 || size.height == 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            size.width = fm.charWidth('0');
            size.height = fm.getHeight();
        }
        return size;
    }

    @Override
    public void updateCursorImmediately() {
        this.getLWToolkit().getCursorManager().updateCursor();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
            focusLog.finest("lightweightChild=" + lightweightChild + ", temporary=" + temporary + ", focusedWindowChangeAllowed=" + focusedWindowChangeAllowed + ", time= " + time + ", cause=" + (Object)((Object)cause));
        }
        if (LWKeyboardFocusManagerPeer.processSynchronousLightweightTransfer(this.getTarget(), lightweightChild, temporary, focusedWindowChangeAllowed, time)) {
            return true;
        }
        int result = LWKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.getTarget(), lightweightChild, temporary, focusedWindowChangeAllowed, time, cause);
        switch (result) {
            case 0: {
                return false;
            }
            case 2: {
                boolean res;
                Window parentWindow = SunToolkit.getContainingWindow(this.getTarget());
                if (parentWindow == null) {
                    focusLog.fine("request rejected, parentWindow is null");
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                LWWindowPeer parentPeer = (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(parentWindow);
                if (parentPeer == null) {
                    focusLog.fine("request rejected, parentPeer is null");
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                if (!focusedWindowChangeAllowed) {
                    LWWindowPeer decoratedPeer;
                    LWWindowPeer lWWindowPeer = decoratedPeer = parentPeer.isSimpleWindow() ? LWWindowPeer.getOwnerFrameDialog(parentPeer) : parentPeer;
                    if (decoratedPeer == null || !decoratedPeer.getPlatformWindow().isActive()) {
                        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                            focusLog.fine("request rejected, focusedWindowChangeAllowed==false, decoratedPeer is inactive: " + decoratedPeer);
                        }
                        LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                        return false;
                    }
                }
                if (!(res = parentPeer.requestWindowFocus(cause)) || !parentWindow.isFocused()) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("request rejected, res= " + res + ", parentWindow.isFocused()=" + parentWindow.isFocused());
                    }
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                LWKeyboardFocusManagerPeer kfmPeer = LWKeyboardFocusManagerPeer.getInstance();
                Component focusOwner = kfmPeer.getCurrentFocusOwner();
                return LWKeyboardFocusManagerPeer.deliverFocus(lightweightChild, this.getTarget(), temporary, focusedWindowChangeAllowed, time, cause, focusOwner);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final Image createImage(ImageProducer producer) {
        return new ToolkitImage(producer);
    }

    @Override
    public final Image createImage(int width, int height) {
        return this.getLWGC().createAcceleratedImage((Component)this.getTarget(), width, height);
    }

    @Override
    public final VolatileImage createVolatileImage(int w, int h) {
        return new SunVolatileImage((Component)this.getTarget(), w, h);
    }

    @Override
    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().prepareImage(img, w, h, o);
    }

    @Override
    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().checkImage(img, w, h, o);
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void applyShape(Region shape) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.region == shape || this.region != null && this.region.equals(shape)) {
                return;
            }
        }
        this.applyShapeImpl(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyShapeImpl(Region shape) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.region = shape != null ? Region.WHOLE_REGION.getIntersection(shape) : null;
        }
        this.repaintParent(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Region getRegion() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.isShaped() ? this.region : Region.getInstance(this.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShaped() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.region != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDropTarget(DropTarget dt) {
        LWWindowPeer winPeer = this.getWindowPeerOrSelf();
        if (winPeer != null && winPeer != this) {
            winPeer.addDropTarget(dt);
        } else {
            Object object = this.dropTargetLock;
            synchronized (object) {
                if (++this.fNumDropTargets == 1) {
                    if (this.fDropTarget != null) {
                        System.err.println("CComponent.addDropTarget(): current drop target is non-null.");
                    }
                    this.fDropTarget = CDropTarget.createDropTarget(dt, this.target, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDropTarget(DropTarget dt) {
        LWWindowPeer winPeer = this.getWindowPeerOrSelf();
        if (winPeer != null && winPeer != this) {
            winPeer.removeDropTarget(dt);
        } else {
            Object object = this.dropTargetLock;
            synchronized (object) {
                if (--this.fNumDropTargets == 0) {
                    if (this.fDropTarget != null) {
                        this.fDropTarget.dispose();
                        this.fDropTarget = null;
                    } else {
                        System.err.println("CComponent.removeDropTarget(): current drop target is null.");
                    }
                }
            }
        }
    }

    protected final void handleMove(int x, int y, boolean updateTarget) {
        if (updateTarget) {
            AWTAccessor.getComponentAccessor().setLocation((Component)this.getTarget(), x, y);
        }
        this.postEvent(new ComponentEvent((Component)this.getTarget(), 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleResize(int w, int h, boolean updateTarget) {
        Image oldBB = null;
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.backBuffer != null) {
                oldBB = this.backBuffer;
                this.backBuffer = this.getLWGC().createBackBuffer(this);
            }
        }
        this.getLWGC().destroyBackBuffer(oldBB);
        if (updateTarget) {
            AWTAccessor.getComponentAccessor().setSize((Component)this.getTarget(), w, h);
        }
        this.postEvent(new ComponentEvent((Component)this.getTarget(), 101));
    }

    protected final void repaintOldNewBounds(Rectangle oldB) {
        this.repaintParent(oldB);
        this.repaintPeer(this.getSize());
    }

    protected final void repaintParent(Rectangle oldB) {
        LWContainerPeer<?, ?> cp = this.getContainerPeer();
        if (cp != null) {
            cp.repaintPeer(cp.getContentSize().intersection(oldB));
        }
    }

    public void postEvent(AWTEvent event) {
        LWToolkit.postEvent(event);
    }

    protected void postPaintEvent(int x, int y, int w, int h) {
        if (AWTAccessor.getComponentAccessor().getIgnoreRepaint((Component)this.target)) {
            return;
        }
        PaintEvent event = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.getTarget(), x, y, w, h);
        if (event != null) {
            this.postEvent(event);
        }
    }

    @Override
    public void handleEvent(AWTEvent e) {
        if (e instanceof InputEvent && ((InputEvent)e).isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent((FocusEvent)e);
                break;
            }
            case 800: 
            case 801: {
                this.handleJavaPaintEvent();
                break;
            }
            case 501: {
                this.handleJavaMouseEvent((MouseEvent)e);
            }
        }
        this.sendEventToDelegate(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEventToDelegate(AWTEvent e) {
        if (this.getDelegate() == null || !this.isShowing() || !this.isEnabled()) {
            return;
        }
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTEvent delegateEvent = this.createDelegateEvent(e);
            if (delegateEvent != null) {
                AWTAccessor.getComponentAccessor().processEvent((Component)delegateEvent.getSource(), delegateEvent);
                if (delegateEvent instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)delegateEvent;
                    SwingUtilities.processKeyBindings(ke);
                }
            }
        }
    }

    private AWTEvent createDelegateEvent(AWTEvent e) {
        ComponentEvent delegateEvent = null;
        if (e instanceof MouseWheelEvent) {
            MouseWheelEvent me = (MouseWheelEvent)e;
            delegateEvent = new MouseWheelEvent((Component)this.delegate, me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getScrollType(), me.getScrollAmount(), me.getWheelRotation());
        } else if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            Component eventTarget = SwingUtilities.getDeepestComponentAt(this.delegate, me.getX(), me.getY());
            if (me.getID() == 506) {
                if (this.delegateDropTarget == null) {
                    this.delegateDropTarget = eventTarget;
                } else {
                    eventTarget = this.delegateDropTarget;
                }
            }
            if (me.getID() == 502 && this.delegateDropTarget != null) {
                eventTarget = this.delegateDropTarget;
                this.delegateDropTarget = null;
            }
            if (eventTarget == null) {
                eventTarget = this.delegate;
            }
            delegateEvent = SwingUtilities.convertMouseEvent(this.getTarget(), me, eventTarget);
        } else if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            delegateEvent = new KeyEvent(this.getDelegateFocusOwner(), ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            AWTAccessor.getKeyEventAccessor().setExtendedKeyCode((KeyEvent)delegateEvent, ke.getExtendedKeyCode());
        } else if (e instanceof FocusEvent) {
            FocusEvent fe = (FocusEvent)e;
            delegateEvent = new FocusEvent(this.getDelegateFocusOwner(), fe.getID(), fe.isTemporary());
        }
        return delegateEvent;
    }

    protected void handleJavaMouseEvent(MouseEvent e) {
        T target = this.getTarget();
        assert (e.getSource() == target);
        if (!((Component)target).isFocusOwner() && LWKeyboardFocusManagerPeer.shouldFocusOnClick(target)) {
            LWKeyboardFocusManagerPeer.requestFocusFor(target, CausedFocusEvent.Cause.MOUSE_EVENT);
        }
    }

    void handleJavaFocusEvent(FocusEvent e) {
        LWKeyboardFocusManagerPeer kfmPeer = LWKeyboardFocusManagerPeer.getInstance();
        kfmPeer.setCurrentFocusOwner(e.getID() == 1004 ? (Component)this.getTarget() : null);
    }

    protected final boolean shouldClearRectBeforePaint() {
        return true;
    }

    private void handleJavaPaintEvent() {
        if (!this.isLayouting()) {
            this.targetPaintArea.paint(this.getTarget(), this.shouldClearRectBeforePaint());
        }
    }

    LWComponentPeer<?, ?> findPeerAt(int x, int y) {
        Rectangle r = this.getBounds();
        Region sh = this.getRegion();
        boolean found = this.isVisible() && sh.contains(x - r.x, y - r.y);
        return found ? this : null;
    }

    public Point windowToLocal(int x, int y, LWWindowPeer wp) {
        return this.windowToLocal(new Point(x, y), wp);
    }

    public Point windowToLocal(Point p, LWWindowPeer wp) {
        for (LWContainerPeer<?, ?> cp = this; cp != wp; cp = cp.getContainerPeer()) {
            Rectangle cpb = cp.getBounds();
            p.x -= cpb.x;
            p.y -= cpb.y;
        }
        return new Point(p);
    }

    public Rectangle windowToLocal(Rectangle r, LWWindowPeer wp) {
        Point p = this.windowToLocal(r.getLocation(), wp);
        return new Rectangle(p, r.getSize());
    }

    public Point localToWindow(int x, int y) {
        return this.localToWindow(new Point(x, y));
    }

    public Point localToWindow(Point p) {
        Rectangle r = this.getBounds();
        for (LWContainerPeer<?, ?> cp = this.getContainerPeer(); cp != null; cp = cp.getContainerPeer()) {
            p.x += r.x;
            p.y += r.y;
            r = cp.getBounds();
        }
        return new Point(p);
    }

    public Rectangle localToWindow(Rectangle r) {
        Point p = this.localToWindow(r.getLocation());
        return new Rectangle(p, r.getSize());
    }

    public final void repaintPeer() {
        this.repaintPeer(this.getSize());
    }

    void repaintPeer(Rectangle r) {
        Rectangle toPaint = this.getSize().intersection(r);
        if (!this.isShowing() || toPaint.isEmpty()) {
            return;
        }
        this.postPaintEvent(toPaint.x, toPaint.y, toPaint.width, toPaint.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isShowing() {
        Object object = LWComponentPeer.getPeerTreeLock();
        synchronized (object) {
            if (this.isVisible()) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                LWContainerPeer<?, ?> container = this.getContainerPeer();
                return container == null || container.isShowing();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void paintPeer(Graphics g) {
        D delegate = this.getDelegate();
        if (delegate != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new InternalError("Painting must be done on EDT");
            }
            Object object = this.getDelegateLock();
            synchronized (object) {
                ((JComponent)this.getDelegate()).print(g);
            }
        }
    }

    protected static final void flushOnscreenGraphics() {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    protected final void setLayouting(boolean isLayouting) {
        this.isLayouting = isLayouting;
    }

    private final boolean isLayouting() {
        return this.isLayouting;
    }

    private final class DelegateContainer
    extends Container {
        DelegateContainer() {
            this.enableEvents(-1L);
        }

        @Override
        public boolean isLightweight() {
            return false;
        }

        @Override
        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        @Override
        public Point getLocationOnScreen() {
            return LWComponentPeer.this.getLocationOnScreen();
        }

        @Override
        public int getX() {
            return this.getLocation().x;
        }

        @Override
        public int getY() {
            return this.getLocation().y;
        }
    }
}

