/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.peer.ContainerPeer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.SunGraphicsCallback;
import sun.java2d.pipe.Region;
import sun.lwawt.LWCanvasPeer;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

abstract class LWContainerPeer<T extends Container, D extends JComponent>
extends LWCanvasPeer<T, D>
implements ContainerPeer {
    private final List<LWComponentPeer<?, ?>> childPeers = new LinkedList();

    LWContainerPeer(T target, PlatformComponent platformComponent) {
        super(target, platformComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addChildPeer(LWComponentPeer<?, ?> child) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            this.childPeers.add(this.childPeers.size(), child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildPeer(LWComponentPeer<?, ?> child) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            this.childPeers.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setChildPeerZOrder(LWComponentPeer<?, ?> peer, LWComponentPeer<?, ?> above) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            int index;
            this.childPeers.remove(peer);
            int n = index = above != null ? this.childPeers.indexOf(above) : this.childPeers.size();
            if (index >= 0) {
                this.childPeers.add(index, peer);
            }
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public final void beginValidate() {
    }

    @Override
    public final void endValidate() {
    }

    @Override
    public final void beginLayout() {
        this.setLayouting(true);
    }

    @Override
    public final void endLayout() {
        this.setLayouting(false);
        this.postPaintEvent(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<LWComponentPeer<?, ?>> getChildren() {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            Object copy = ((LinkedList)this.childPeers).clone();
            return (List)copy;
        }
    }

    @Override
    final Region getVisibleRegion() {
        return this.cutChildren(super.getVisibleRegion(), null);
    }

    final Region cutChildren(Region r, LWComponentPeer<?, ?> above) {
        boolean aboveFound = above == null;
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            if (!aboveFound && child == above) {
                aboveFound = true;
                continue;
            }
            if (!aboveFound || !child.isVisible()) continue;
            Rectangle cb = child.getBounds();
            Region cr = child.getRegion();
            Region tr = cr.getTranslatedRegion(cb.x, cb.y);
            r = r.getDifference(tr.getIntersection(this.getContentSize()));
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final LWComponentPeer<?, ?> findPeerAt(int x, int y) {
        LWComponentPeer<?, ?> peer = super.findPeerAt(x, y);
        Rectangle r = this.getBounds();
        if (peer != null && this.getContentSize().contains(x -= r.x, y -= r.y)) {
            Object object = LWContainerPeer.getPeerTreeLock();
            synchronized (object) {
                for (int i = this.childPeers.size() - 1; i >= 0; --i) {
                    LWComponentPeer<?, ?> p = this.childPeers.get(i).findPeerAt(x, y);
                    if (p == null) continue;
                    peer = p;
                    break;
                }
            }
        }
        return peer;
    }

    @Override
    final void repaintPeer(Rectangle r) {
        Rectangle toPaint = this.getSize().intersection(r);
        if (!this.isShowing() || toPaint.isEmpty()) {
            return;
        }
        super.repaintPeer(toPaint);
        this.repaintChildren(toPaint);
    }

    private void repaintChildren(Rectangle r) {
        Rectangle content = this.getContentSize();
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            Rectangle childBounds = child.getBounds();
            Rectangle toPaint = r.intersection(childBounds);
            toPaint = toPaint.intersection(content);
            toPaint.translate(-childBounds.x, -childBounds.y);
            child.repaintPeer(toPaint);
        }
    }

    Rectangle getContentSize() {
        return this.getSize();
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            child.setEnabled(e && ((Component)child.getTarget()).isEnabled());
        }
    }

    @Override
    public void setBackground(Color c) {
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            if (((Component)child.getTarget()).isBackgroundSet()) continue;
            child.setBackground(c);
        }
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            if (((Component)child.getTarget()).isForegroundSet()) continue;
            child.setForeground(c);
        }
        super.setForeground(c);
    }

    @Override
    public void setFont(Font f) {
        for (LWComponentPeer<?, ?> child : this.getChildren()) {
            if (((Component)child.getTarget()).isFontSet()) continue;
            child.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
        SunGraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.getTarget()).getComponents(), g, 3);
    }

    @Override
    public final void print(Graphics g) {
        super.print(g);
        SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.getTarget()).getComponents(), g, 3);
    }
}

