/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;

public abstract class LWCursorManager {
    private final AtomicBoolean updatePending = new AtomicBoolean(false);

    protected LWCursorManager() {
    }

    public final void updateCursor() {
        this.updatePending.set(false);
        this.updateCursorImpl();
    }

    public final void updateCursorLater(LWWindowPeer window) {
        if (this.updatePending.compareAndSet(false, true)) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LWCursorManager.this.updateCursor();
                }
            };
            SunToolkit.executeOnEventHandlerThread(window.getTarget(), r);
        }
    }

    private void updateCursorImpl() {
        Cursor cursor;
        Point cursorPos = this.getCursorPosition();
        Component c = LWCursorManager.findComponent(cursorPos);
        Object peer = LWToolkit.targetToPeer(c);
        if (peer instanceof LWComponentPeer) {
            LWComponentPeer lwpeer = (LWComponentPeer)peer;
            Point p = lwpeer.getLocationOnScreen();
            cursor = lwpeer.getCursor(new Point(cursorPos.x - p.x, cursorPos.y - p.y));
        } else {
            cursor = c != null ? c.getCursor() : null;
        }
        this.setCursor(cursor);
    }

    private static final Component findComponent(Point cursorPos) {
        LWComponentPeer<?, ?> peer = LWWindowPeer.getPeerUnderCursor();
        Component c = null;
        if (peer != null && peer.getWindowPeerOrSelf().getBlocker() == null) {
            Object p;
            c = (Component)peer.getTarget();
            if (c instanceof Container) {
                p = peer.getLocationOnScreen();
                c = AWTAccessor.getContainerAccessor().findComponentAt((Container)c, cursorPos.x - ((Point)p).x, cursorPos.y - ((Point)p).y, false);
            }
            while (c != null) {
                p = AWTAccessor.getComponentAccessor().getPeer(c);
                if (c.isVisible() && c.isEnabled() && p != null) break;
                c = c.getParent();
            }
        }
        return c;
    }

    protected abstract Point getCursorPosition();

    protected abstract void setCursor(Cursor var1);
}

