/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWListPeer
extends LWComponentPeer<List, ScrollableJList>
implements ListPeer {
    private static final int DEFAULT_VISIBLE_ROWS = 4;
    private static final String TEXT = "0123456789abcde";

    LWListPeer(List target, PlatformComponent platformComponent) {
        super(target, platformComponent);
        if (!((List)this.getTarget()).isBackgroundSet()) {
            ((List)this.getTarget()).setBackground(SystemColor.text);
        }
    }

    @Override
    ScrollableJList createDelegate() {
        return new ScrollableJList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setMultipleMode(((List)this.getTarget()).isMultipleMode());
        int[] selectedIndices = ((List)this.getTarget()).getSelectedIndexes();
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndices(selectedIndices);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    Component getDelegateFocusOwner() {
        return ((ScrollableJList)this.getDelegate()).getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedIndexes() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((ScrollableJList)this.getDelegate()).getView().getSelectedIndices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String item, int index) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().add(index, item);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delItems(int start, int end) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeRange(start, end);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeAllElements();
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select(int index) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndex(index);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deselect(int index) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().getSelectionModel().removeSelectionInterval(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeVisible(int index) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().ensureIndexIsVisible(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultipleMode(boolean m) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().setSelectionMode(m ? 2 : 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(4);
    }

    @Override
    public Dimension getPreferredSize(int rows) {
        return this.getMinimumSize(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(int rows) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Dimension size = this.getCellSize();
            size.height *= rows;
            JScrollBar vbar = ((ScrollableJList)this.getDelegate()).getVerticalScrollBar();
            size.width = size.width + (vbar != null ? vbar.getMinimumSize().width : 0);
            Insets pi = ((ScrollableJList)this.getDelegate()).getInsets();
            Insets vi = ((ScrollableJList)this.getDelegate()).getView().getInsets();
            size.width += pi.left + pi.right + vi.left + vi.right;
            size.height += pi.top + pi.bottom + vi.top + vi.bottom;
            return size;
        }
    }

    private Dimension getCellSize() {
        JList<String> jList = ((ScrollableJList)this.getDelegate()).getView();
        ListCellRenderer<String> cr = jList.getCellRenderer();
        Component cell = cr.getListCellRendererComponent(jList, TEXT, 0, false, false);
        return cell.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidate() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().invalidate();
            ((ScrollableJList)this.getDelegate()).validate();
        }
    }

    final class ScrollableJList
    extends JScrollPane
    implements ListSelectionListener {
        private boolean skipStateChangedEvent;
        private final DefaultListModel<String> model = new DefaultListModel<String>(){

            @Override
            public void add(int index, String element) {
                if (index == -1) {
                    this.addElement(element);
                } else {
                    super.add(index, element);
                }
            }
        };
        private int[] oldSelectedIndices = new int[0];

        ScrollableJList() {
            this.getViewport().setScrollMode(0);
            JListDelegate list = new JListDelegate();
            list.addListSelectionListener(this);
            this.getViewport().setView(list);
            String[] items = ((List)LWListPeer.this.getTarget()).getItems();
            for (int i = 0; i < items.length; ++i) {
                this.model.add(i, items[i]);
            }
        }

        public boolean isSkipStateChangedEvent() {
            return this.skipStateChangedEvent;
        }

        public void setSkipStateChangedEvent(boolean skipStateChangedEvent) {
            this.skipStateChangedEvent = skipStateChangedEvent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !this.isSkipStateChangedEvent()) {
                JList source = (JList)e.getSource();
                for (int i = 0; i < source.getModel().getSize(); ++i) {
                    boolean isSelected;
                    boolean wasSelected = Arrays.binarySearch(this.oldSelectedIndices, i) >= 0;
                    if (wasSelected == (isSelected = source.isSelectedIndex(i))) continue;
                    int state = !wasSelected && isSelected ? 1 : 2;
                    LWListPeer.this.postEvent(new ItemEvent((ItemSelectable)LWListPeer.this.getTarget(), 701, i, state));
                }
                this.oldSelectedIndices = source.getSelectedIndices();
            }
        }

        public JList<String> getView() {
            return (JList)this.getViewport().getView();
        }

        public DefaultListModel<String> getModel() {
            return this.model;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.getView().setEnabled(enabled);
            super.setEnabled(enabled);
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            super.setOpaque(isOpaque);
            if (this.getView() != null) {
                this.getView().setOpaque(isOpaque);
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.getView() != null) {
                this.getView().setFont(font);
                LWListPeer.this.revalidate();
            }
        }

        private final class JListDelegate
        extends JList<String> {
            JListDelegate() {
                super(ScrollableJList.this.model);
            }

            @Override
            public boolean hasFocus() {
                return ((List)LWListPeer.this.getTarget()).hasFocus();
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                int index;
                super.processMouseEvent(e);
                if (e.getID() == 500 && e.getClickCount() == 2 && 0 <= (index = this.locationToIndex(e.getPoint())) && index < this.getModel().getSize()) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, (String)this.getModel().getElementAt(index), e.getWhen(), e.getModifiers()));
                }
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                String selectedValue;
                super.processKeyEvent(e);
                if (e.getID() == 401 && e.getKeyCode() == 10 && (selectedValue = (String)this.getSelectedValue()) != null) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, selectedValue, e.getWhen(), e.getModifiers()));
                }
            }

            @Override
            public Point getLocationOnScreen() {
                return LWListPeer.this.getLocationOnScreen();
            }
        }
    }
}

