/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ScrollPanePeer;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.PlatformComponent;

final class LWScrollPanePeer
extends LWContainerPeer<ScrollPane, JScrollPane>
implements ScrollPanePeer,
ChangeListener {
    LWScrollPanePeer(ScrollPane target, PlatformComponent platformComponent) {
        super(target, platformComponent);
    }

    @Override
    JScrollPane createDelegate() {
        JScrollPane sp = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setVisible(false);
        sp.getViewport().setView(panel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.getViewport().addChangeListener(this);
        return sp;
    }

    @Override
    public void handleEvent(AWTEvent e) {
        if (e instanceof MouseWheelEvent) {
            MouseWheelEvent wheelEvent = (MouseWheelEvent)e;
            if (((ScrollPane)this.getTarget()).isWheelScrollingEnabled() && wheelEvent.isConsumed()) {
                this.sendEventToDelegate(wheelEvent);
            }
        } else {
            super.handleEvent(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LWComponentPeer<?, ?> viewPeer = LWScrollPanePeer.this.getViewPeer();
                if (viewPeer != null) {
                    Rectangle r;
                    Object object = LWScrollPanePeer.this.getDelegateLock();
                    synchronized (object) {
                        r = ((JScrollPane)LWScrollPanePeer.this.getDelegate()).getViewport().getView().getBounds();
                    }
                    viewPeer.setBounds(r.x, r.y, r.width, r.height, 3, true, true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        int policy = ((ScrollPane)this.getTarget()).getScrollbarDisplayPolicy();
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JScrollPane)this.getDelegate()).getViewport().setScrollMode(0);
            ((JScrollPane)this.getDelegate()).setVerticalScrollBarPolicy(LWScrollPanePeer.convertVPolicy(policy));
            ((JScrollPane)this.getDelegate()).setHorizontalScrollBarPolicy(LWScrollPanePeer.convertHPolicy(policy));
        }
    }

    LWComponentPeer<?, ?> getViewPeer() {
        List<LWComponentPeer<?, ?>> peerList = this.getChildren();
        return peerList.isEmpty() ? null : peerList.get(0);
    }

    @Override
    Rectangle getContentSize() {
        Rectangle viewRect = ((JScrollPane)this.getDelegate()).getViewport().getViewRect();
        return new Rectangle(viewRect.width, viewRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout() {
        super.layout();
        Object object = this.getDelegateLock();
        synchronized (object) {
            LWComponentPeer<?, ?> viewPeer = this.getViewPeer();
            if (viewPeer != null) {
                Component view = ((JScrollPane)this.getDelegate()).getViewport().getView();
                view.setBounds(viewPeer.getBounds());
                view.setPreferredSize(viewPeer.getPreferredSize());
                view.setMinimumSize(viewPeer.getMinimumSize());
                ((JScrollPane)this.getDelegate()).invalidate();
                ((JScrollPane)this.getDelegate()).validate();
                viewPeer.setBounds(view.getBounds());
            }
        }
    }

    @Override
    public void setScrollPosition(int x, int y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHScrollbarHeight() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((JScrollPane)this.getDelegate()).getHorizontalScrollBar().getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVScrollbarWidth() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((JScrollPane)this.getDelegate()).getVerticalScrollBar().getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childResized(int w, int h) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JScrollPane)this.getDelegate()).invalidate();
            ((JScrollPane)this.getDelegate()).validate();
        }
    }

    @Override
    public void setUnitIncrement(Adjustable adj, int u) {
    }

    @Override
    public void setValue(Adjustable adj, int v) {
    }

    private static int convertHPolicy(int policy) {
        switch (policy) {
            case 2: {
                return 31;
            }
            case 1: {
                return 32;
            }
        }
        return 30;
    }

    private static int convertVPolicy(int policy) {
        switch (policy) {
            case 2: {
                return 21;
            }
            case 1: {
                return 22;
            }
        }
        return 20;
    }
}

