/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import sun.lwawt.LWTextComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWTextAreaPeer
extends LWTextComponentPeer<TextArea, ScrollableJTextArea>
implements TextAreaPeer {
    private static final int DEFAULT_COLUMNS = 60;
    private static final int DEFAULT_ROWS = 10;

    LWTextAreaPeer(TextArea target, PlatformComponent platformComponent) {
        super(target, platformComponent);
    }

    @Override
    ScrollableJTextArea createDelegate() {
        return new ScrollableJTextArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        int visibility = ((TextArea)this.getTarget()).getScrollbarVisibility();
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().setWrapStyleWord(true);
            this.setScrollBarVisibility(visibility);
        }
    }

    @Override
    JTextArea getTextComponent() {
        return ((ScrollableJTextArea)this.getDelegate()).getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Cursor getCursor(Point p) {
        boolean isContains;
        Object object = this.getDelegateLock();
        synchronized (object) {
            isContains = ((ScrollableJTextArea)this.getDelegate()).getViewport().getBounds().contains(p);
        }
        return isContains ? super.getCursor(p) : null;
    }

    @Override
    Component getDelegateFocusOwner() {
        return this.getTextComponent();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    @Override
    public Dimension getPreferredSize(int rows, int columns) {
        return this.getMinimumSize(rows, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(int rows, int columns) {
        Dimension size = super.getMinimumSize(rows, columns);
        Object object = this.getDelegateLock();
        synchronized (object) {
            int hsbPolicy;
            Insets pi = ((ScrollableJTextArea)this.getDelegate()).getInsets();
            size.width += pi.left + pi.right;
            size.height += pi.top + pi.bottom;
            int vsbPolicy = ((ScrollableJTextArea)this.getDelegate()).getVerticalScrollBarPolicy();
            if (vsbPolicy == 22) {
                JScrollBar vbar = ((ScrollableJTextArea)this.getDelegate()).getVerticalScrollBar();
                size.width = size.width + (vbar != null ? vbar.getMinimumSize().width : 0);
            }
            if ((hsbPolicy = ((ScrollableJTextArea)this.getDelegate()).getHorizontalScrollBarPolicy()) == 32) {
                JScrollBar hbar = ((ScrollableJTextArea)this.getDelegate()).getHorizontalScrollBar();
                size.height = size.height + (hbar != null ? hbar.getMinimumSize().height : 0);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(String text, int pos) {
        ScrollableJTextArea pane = (ScrollableJTextArea)this.getDelegate();
        Object object = this.getDelegateLock();
        synchronized (object) {
            JScrollBar vbar;
            JTextArea area = pane.getView();
            boolean doScroll = pos >= area.getDocument().getLength() && area.getDocument().getLength() != 0;
            area.insert(text, pos);
            this.revalidate();
            if (doScroll && (vbar = pane.getVerticalScrollBar()) != null) {
                vbar.setValue(vbar.getMaximum() - vbar.getVisibleAmount());
            }
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceRange(String text, int start, int end) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Document document = this.getTextComponent().getDocument();
            document.removeDocumentListener(this);
            this.getTextComponent().replaceRange(text, start, end);
            this.revalidate();
            this.postEvent(new TextEvent(this.getTarget(), 900));
            document.addDocumentListener(this);
        }
        this.repaintPeer();
    }

    private void setScrollBarVisibility(int visibility) {
        ScrollableJTextArea pane = (ScrollableJTextArea)this.getDelegate();
        JTextArea view = pane.getView();
        view.setLineWrap(false);
        switch (visibility) {
            case 3: {
                pane.setHorizontalScrollBarPolicy(31);
                pane.setVerticalScrollBarPolicy(21);
                view.setLineWrap(true);
                break;
            }
            case 1: {
                pane.setHorizontalScrollBarPolicy(31);
                pane.setVerticalScrollBarPolicy(22);
                view.setLineWrap(true);
                break;
            }
            case 2: {
                pane.setVerticalScrollBarPolicy(21);
                pane.setHorizontalScrollBarPolicy(32);
                break;
            }
            default: {
                pane.setHorizontalScrollBarPolicy(32);
                pane.setVerticalScrollBarPolicy(22);
            }
        }
    }

    final class ScrollableJTextArea
    extends JScrollPane {
        ScrollableJTextArea() {
            this.getViewport().setView(new JTextAreaDelegate());
        }

        public JTextArea getView() {
            return (JTextArea)this.getViewport().getView();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.getViewport().getView().setEnabled(enabled);
            super.setEnabled(enabled);
        }

        private final class JTextAreaDelegate
        extends JTextArea {
            JTextAreaDelegate() {
            }

            @Override
            public void replaceSelection(String content) {
                this.getDocument().removeDocumentListener(LWTextAreaPeer.this);
                super.replaceSelection(content);
                LWTextAreaPeer.this.postTextEvent();
                this.getDocument().addDocumentListener(LWTextAreaPeer.this);
            }

            @Override
            public boolean hasFocus() {
                return ((TextArea)LWTextAreaPeer.this.getTarget()).hasFocus();
            }

            @Override
            public Point getLocationOnScreen() {
                return LWTextAreaPeer.this.getLocationOnScreen();
            }
        }
    }
}

