/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextComponentPeer;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

abstract class LWTextComponentPeer<T extends TextComponent, D extends JComponent>
extends LWComponentPeer<T, D>
implements DocumentListener,
TextComponentPeer,
InputMethodListener {
    private volatile boolean firstChangeSkipped;

    LWTextComponentPeer(T target, PlatformComponent platformComponent) {
        super(target, platformComponent);
        if (!((TextComponent)this.getTarget()).isBackgroundSet()) {
            ((TextComponent)this.getTarget()).setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().getDocument().addDocumentListener(this);
        }
        this.setEditable(((TextComponent)this.getTarget()).isEditable());
        this.setText(((TextComponent)this.getTarget()).getText());
        this.setCaretPosition(((TextComponent)this.getTarget()).getCaretPosition());
        ((TextComponent)this.getTarget()).addInputMethodListener(this);
        int start = ((TextComponent)this.getTarget()).getSelectionStart();
        int end = ((TextComponent)this.getTarget()).getSelectionEnd();
        if (end > start) {
            this.select(start, end);
        }
        this.firstChangeSkipped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void disposeImpl() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().getCaret().setVisible(false);
        }
        super.disposeImpl();
    }

    abstract JTextComponent getTextComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(int rows, int columns) {
        Insets insets;
        Object object = this.getDelegateLock();
        synchronized (object) {
            insets = this.getTextComponent().getInsets();
        }
        int borderHeight = insets.top + insets.bottom;
        int borderWidth = insets.left + insets.right;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(fm.charWidth('0') * columns + borderWidth, fm.getHeight() * rows + borderHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEditable(boolean editable) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().setEditable(editable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getText() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setText(String text) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Document document = this.getTextComponent().getDocument();
            document.removeDocumentListener(this);
            this.getTextComponent().setText(text);
            this.revalidate();
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.getTarget(), 900));
            }
            document.addDocumentListener(this);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getSelectionStart() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getSelectionStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getSelectionEnd() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getSelectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void select(int selStart, int selEnd) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().select(selStart, selEnd);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCaretPosition(int pos) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().setCaretPosition(pos);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getCaretPosition() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getCaretPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputMethodRequests getInputMethodRequests() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.getTextComponent().getInputMethodRequests();
        }
    }

    @Override
    public final boolean isFocusable() {
        return ((TextComponent)this.getTarget()).isFocusable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void revalidate() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.getTextComponent().invalidate();
            ((Container)this.getDelegate()).validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postTextEvent() {
        this.postEvent(new TextEvent(this.getTarget(), 900));
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.revalidate();
        }
    }

    @Override
    public final void changedUpdate(DocumentEvent e) {
        this.postTextEvent();
    }

    @Override
    public final void insertUpdate(DocumentEvent e) {
        this.postTextEvent();
    }

    @Override
    public final void removeUpdate(DocumentEvent e) {
        this.postTextEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTAccessor.getComponentAccessor().processEvent(this.getTextComponent(), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTAccessor.getComponentAccessor().processEvent(this.getTextComponent(), event);
        }
    }
}

