/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Properties;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.LightweightFrame;
import sun.awt.SunToolkit;
import sun.lwawt.LWButtonPeer;
import sun.lwawt.LWCanvasPeer;
import sun.lwawt.LWCheckboxPeer;
import sun.lwawt.LWChoicePeer;
import sun.lwawt.LWCursorManager;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWLabelPeer;
import sun.lwawt.LWLightweightFramePeer;
import sun.lwawt.LWListPeer;
import sun.lwawt.LWMouseInfoPeer;
import sun.lwawt.LWPanelPeer;
import sun.lwawt.LWScrollBarPeer;
import sun.lwawt.LWScrollPanePeer;
import sun.lwawt.LWTextAreaPeer;
import sun.lwawt.LWTextFieldPeer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.misc.ThreadGroupUtils;
import sun.print.PrintJob2D;
import sun.security.util.SecurityConstants;

public abstract class LWToolkit
extends SunToolkit
implements Runnable {
    private static final int STATE_NONE = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_MESSAGELOOP = 2;
    private static final int STATE_SHUTDOWN = 3;
    private static final int STATE_CLEANUP = 4;
    private static final int STATE_DONE = 5;
    private int runState = 0;
    private Clipboard clipboard;
    private MouseInfoPeer mouseInfoPeer;
    private volatile boolean dynamicLayoutSetting = true;

    protected LWToolkit() {
    }

    protected final void init() {
        AWTAutoShutdown.notifyToolkitThreadBusy();
        ThreadGroup rootTG = AccessController.doPrivileged(ThreadGroupUtils::getRootThreadGroup);
        Runtime.getRuntime().addShutdownHook(new Thread(rootTG, () -> {
            this.shutdown();
            this.waitForRunState(4);
        }));
        Thread toolkitThread = new Thread(rootTG, this, "AWT-LW");
        toolkitThread.setDaemon(true);
        toolkitThread.setPriority(6);
        toolkitThread.start();
        this.waitForRunState(2);
    }

    protected abstract void platformInit();

    public final void shutdown() {
        this.setRunState(3);
        this.platformShutdown();
    }

    protected abstract void platformShutdown();

    protected abstract void platformCleanup();

    private synchronized int getRunState() {
        return this.runState;
    }

    private synchronized void setRunState(int state) {
        this.runState = state;
        this.notifyAll();
    }

    public final boolean isTerminating() {
        return this.getRunState() >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunState(int state) {
        while (this.getRunState() < state) {
            try {
                LWToolkit lWToolkit = this;
                synchronized (lWToolkit) {
                    this.wait();
                }
            }
            catch (InterruptedException z) {
                break;
            }
        }
    }

    @Override
    public final void run() {
        this.setRunState(1);
        this.platformInit();
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.setRunState(2);
        while (this.getRunState() < 3) {
            try {
                this.platformRunMessage();
                if (!Thread.currentThread().isInterrupted() || !AppContext.getAppContext().isDisposed()) continue;
                break;
            }
            catch (ThreadDeath td) {
                break;
            }
            catch (Throwable t) {
                System.err.println("Exception on the toolkit thread");
                t.printStackTrace(System.err);
            }
        }
        this.setRunState(4);
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.platformCleanup();
        this.setRunState(5);
    }

    protected abstract void platformRunMessage();

    public static LWToolkit getLWToolkit() {
        return (LWToolkit)Toolkit.getDefaultToolkit();
    }

    protected LWWindowPeer createDelegatedPeer(Window target, PlatformComponent platformComponent, PlatformWindow platformWindow, LWWindowPeer.PeerType peerType) {
        LWWindowPeer peer = new LWWindowPeer(target, platformComponent, platformWindow, peerType);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final FramePeer createLightweightFrame(LightweightFrame target) {
        PlatformComponent platformComponent = this.createLwPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.LW_FRAME);
        LWLightweightFramePeer peer = new LWLightweightFramePeer(target, platformComponent, platformWindow);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final WindowPeer createWindow(Window target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.SIMPLEWINDOW);
        return this.createDelegatedPeer(target, platformComponent, platformWindow, LWWindowPeer.PeerType.SIMPLEWINDOW);
    }

    @Override
    public final FramePeer createFrame(Frame target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.FRAME);
        return this.createDelegatedPeer(target, platformComponent, platformWindow, LWWindowPeer.PeerType.FRAME);
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.DIALOG);
        return this.createDelegatedPeer(target, platformComponent, platformWindow, LWWindowPeer.PeerType.DIALOG);
    }

    @Override
    public final FileDialogPeer createFileDialog(FileDialog target) {
        FileDialogPeer peer = this.createFileDialogPeer(target);
        LWToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public final ButtonPeer createButton(Button target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWButtonPeer peer = new LWButtonPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final CheckboxPeer createCheckbox(Checkbox target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCheckboxPeer peer = new LWCheckboxPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final ChoicePeer createChoice(Choice target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWChoicePeer peer = new LWChoicePeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final LabelPeer createLabel(Label target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWLabelPeer peer = new LWLabelPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final CanvasPeer createCanvas(Canvas target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCanvasPeer peer = new LWCanvasPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final ListPeer createList(List target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWListPeer peer = new LWListPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final PanelPeer createPanel(Panel target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWPanelPeer peer = new LWPanelPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final ScrollPanePeer createScrollPane(ScrollPane target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollPanePeer peer = new LWScrollPanePeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final ScrollbarPeer createScrollbar(Scrollbar target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollBarPeer peer = new LWScrollBarPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final TextAreaPeer createTextArea(TextArea target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextAreaPeer peer = new LWTextAreaPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final TextFieldPeer createTextField(TextField target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextFieldPeer peer = new LWTextFieldPeer(target, platformComponent);
        LWToolkit.targetCreatedPeer(target, peer);
        peer.initialize();
        return peer;
    }

    @Override
    public final ColorModel getColorModel() throws HeadlessException {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    @Override
    public final boolean isDesktopSupported() {
        return true;
    }

    @Override
    public final KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() {
        return LWKeyboardFocusManagerPeer.getInstance();
    }

    @Override
    public final synchronized MouseInfoPeer getMouseInfoPeer() {
        if (this.mouseInfoPeer == null) {
            this.mouseInfoPeer = this.createMouseInfoPeerImpl();
        }
        return this.mouseInfoPeer;
    }

    protected final MouseInfoPeer createMouseInfoPeerImpl() {
        return new LWMouseInfoPeer();
    }

    protected abstract PlatformWindow getPlatformWindowUnderMouse();

    @Override
    public final PrintJob getPrintJob(Frame frame, String doctitle, Properties props) {
        return this.getPrintJob(frame, doctitle, null, null);
    }

    @Override
    public final PrintJob getPrintJob(Frame frame, String doctitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob = new PrintJob2D(frame, doctitle, jobAttributes, pageAttributes);
        if (!printJob.printDialog()) {
            printJob = null;
        }
        return printJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Clipboard getSystemClipboard() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.AWT.ACCESS_CLIPBOARD_PERMISSION);
        }
        LWToolkit lWToolkit = this;
        synchronized (lWToolkit) {
            if (this.clipboard == null) {
                this.clipboard = this.createPlatformClipboard();
            }
        }
        return this.clipboard;
    }

    protected abstract SecurityWarningWindow createSecurityWarning(Window var1, LWWindowPeer var2);

    public abstract Clipboard createPlatformClipboard();

    protected abstract PlatformWindow createPlatformWindow(LWWindowPeer.PeerType var1);

    protected abstract PlatformComponent createPlatformComponent();

    protected abstract PlatformComponent createLwPlatformComponent();

    protected abstract FileDialogPeer createFileDialogPeer(FileDialog var1);

    public static final Object targetToPeer(Object target) {
        return SunToolkit.targetToPeer(target);
    }

    public static final void targetDisposedPeer(Object target, Object peer) {
        SunToolkit.targetDisposedPeer(target, peer);
    }

    public abstract LWCursorManager getCursorManager();

    public static void postEvent(AWTEvent event) {
        LWToolkit.postEvent(LWToolkit.targetToAppContext(event.getSource()), event);
    }

    @Override
    public final void grab(Window w) {
        ComponentPeer peer = AWTAccessor.getComponentAccessor().getPeer(w);
        if (peer != null) {
            ((LWWindowPeer)peer).grab();
        }
    }

    @Override
    public final void ungrab(Window w) {
        ComponentPeer peer = AWTAccessor.getComponentAccessor().getPeer(w);
        if (peer != null) {
            ((LWWindowPeer)peer).ungrab(false);
        }
    }

    @Override
    protected final Object lazilyLoadDesktopProperty(String name) {
        if (name.equals("awt.dynamicLayoutSupported")) {
            return this.isDynamicLayoutSupported();
        }
        return super.lazilyLoadDesktopProperty(name);
    }

    @Override
    public final void setDynamicLayout(boolean dynamic) {
        this.dynamicLayoutSetting = dynamic;
    }

    @Override
    protected final boolean isDynamicLayoutSet() {
        return this.dynamicLayoutSetting;
    }

    @Override
    public final boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupported();
    }

    protected final boolean isDynamicLayoutSupported() {
        return true;
    }
}

