/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.WindowPeer;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.DisplayChangedListener;
import sun.awt.ExtendedKeyCodes;
import sun.awt.FullScreenCapable;
import sun.awt.SunToolkit;
import sun.awt.TimedWindowEvent;
import sun.awt.UngrabEvent;
import sun.java2d.NullSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.Region;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWToolkit;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.util.logging.PlatformLogger;

public class LWWindowPeer
extends LWContainerPeer<Window, JComponent>
implements FramePeer,
DialogPeer,
FullScreenCapable,
DisplayChangedListener,
PlatformEventNotifier {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.lwawt.focus.LWWindowPeer");
    private final PlatformWindow platformWindow;
    private static final int MINIMUM_WIDTH = 1;
    private static final int MINIMUM_HEIGHT = 1;
    private Insets insets = new Insets(0, 0, 0, 0);
    private GraphicsDevice graphicsDevice;
    private GraphicsConfiguration graphicsConfig;
    private SurfaceData surfaceData;
    private final Object surfaceDataLock = new Object();
    private volatile int windowState = 0;
    private volatile boolean isMouseOver = false;
    private static volatile LWComponentPeer<?, ?> lastCommonMouseEventPeer;
    private volatile LWComponentPeer<?, ?> lastMouseEventPeer;
    private static final LWComponentPeer<?, ?>[] mouseDownTarget;
    private static int mouseClickButtons;
    private volatile boolean isOpaque = true;
    private static final Font DEFAULT_FONT;
    private static LWWindowPeer grabbingWindow;
    private volatile boolean skipNextFocusChange;
    private static final Color nonOpaqueBackground;
    private volatile boolean textured;
    private final PeerType peerType;
    private final SecurityWarningWindow warningWindow;
    private volatile boolean targetFocusable;
    private LWWindowPeer blocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer(Window target, PlatformComponent platformComponent, PlatformWindow platformWindow, PeerType peerType) {
        super(target, platformComponent);
        this.platformWindow = platformWindow;
        this.peerType = peerType;
        Window owner = target.getOwner();
        LWWindowPeer ownerPeer = owner == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(owner);
        PlatformWindow ownerDelegate = ownerPeer != null ? ownerPeer.getPlatformWindow() : null;
        GraphicsConfiguration gc = ((Window)this.getTarget()).getGraphicsConfiguration();
        Object object = this.getStateLock();
        synchronized (object) {
            this.graphicsConfig = gc;
        }
        if (!target.isFontSet()) {
            target.setFont(DEFAULT_FONT);
        }
        if (!target.isBackgroundSet()) {
            target.setBackground(SystemColor.window);
        }
        if (!target.isForegroundSet()) {
            target.setForeground(SystemColor.windowText);
        }
        platformWindow.initialize(target, this, ownerDelegate);
        SecurityWarningWindow warn = null;
        if (target.getWarningString() != null && !AWTAccessor.getWindowAccessor().isTrayIconWindow(target)) {
            LWToolkit toolkit = (LWToolkit)Toolkit.getDefaultToolkit();
            warn = toolkit.createSecurityWarning(target, this);
        }
        this.warningWindow = warn;
    }

    @Override
    void initializeImpl() {
        float opacity;
        super.initializeImpl();
        if (this.getTarget() instanceof Frame) {
            this.setTitle(((Frame)this.getTarget()).getTitle());
            this.setState(((Frame)this.getTarget()).getExtendedState());
        } else if (this.getTarget() instanceof Dialog) {
            this.setTitle(((Dialog)this.getTarget()).getTitle());
        }
        this.updateAlwaysOnTopState();
        this.updateMinimumSize();
        this.updateFocusableWindowState();
        Shape shape = ((Window)this.getTarget()).getShape();
        if (shape != null) {
            this.applyShape(Region.getInstance(shape, null));
        }
        if ((opacity = ((Window)this.getTarget()).getOpacity()) < 1.0f) {
            this.setOpacity(opacity);
        }
        this.setOpaque(((Window)this.getTarget()).isOpaque());
        this.updateInsets(this.platformWindow.getInsets());
        if (this.getSurfaceData() == null) {
            this.replaceSurfaceData(false);
        }
        this.activateDisplayListener();
    }

    @Override
    public PlatformWindow getPlatformWindow() {
        return this.platformWindow;
    }

    @Override
    protected LWWindowPeer getWindowPeerOrSelf() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeImpl() {
        this.deactivateDisplayListener();
        SurfaceData oldData = this.getSurfaceData();
        Object object = this.surfaceDataLock;
        synchronized (object) {
            this.surfaceData = null;
        }
        if (oldData != null) {
            oldData.invalidate();
        }
        if (this.isGrabbing()) {
            this.ungrab();
        }
        if (this.warningWindow != null) {
            this.warningWindow.dispose();
        }
        this.platformWindow.dispose();
        super.disposeImpl();
    }

    @Override
    protected void setVisibleImpl(boolean visible) {
        if (!visible && this.warningWindow != null) {
            this.warningWindow.setVisible(false, false);
        }
        this.updateFocusableWindowState();
        super.setVisibleImpl(visible);
        this.platformWindow.setVisible(visible);
        if (this.isSimpleWindow()) {
            LWWindowPeer owner;
            LWKeyboardFocusManagerPeer kfmPeer = LWKeyboardFocusManagerPeer.getInstance();
            if (visible) {
                if (!((Window)this.getTarget()).isAutoRequestFocus()) {
                    return;
                }
                this.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            } else if (kfmPeer.getCurrentFocusedWindow() == this.getTarget() && (owner = LWWindowPeer.getOwnerFrameDialog(this)) != null) {
                owner.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.graphicsConfig;
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        this.setGraphicsConfig(gc);
        return false;
    }

    protected final Graphics getOnscreenGraphics(Color fg, Color bg, Font f) {
        if (this.getSurfaceData() == null) {
            return null;
        }
        if (fg == null) {
            fg = SystemColor.windowText;
        }
        if (bg == null) {
            bg = SystemColor.window;
        }
        if (f == null) {
            f = DEFAULT_FONT;
        }
        return this.platformWindow.transformGraphics(new SunGraphics2D(this.getSurfaceData(), fg, bg, f));
    }

    @Override
    public void setBounds(int x, int y, int w, int h, int op) {
        if ((op & 0x4000) == 0 && this.getPeerType() == PeerType.VIEW_EMBEDDED_FRAME) {
            return;
        }
        if ((op & 4) != 0) {
            op &= 0xFFFFFFFB;
            op |= 2;
        }
        Rectangle cb = this.constrainBounds(x, y, w, h);
        Rectangle newBounds = new Rectangle(this.getBounds());
        if ((op & 3) != 0) {
            newBounds.x = cb.x;
            newBounds.y = cb.y;
        }
        if ((op & 3) != 0) {
            newBounds.width = cb.width;
            newBounds.height = cb.height;
        }
        this.platformWindow.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
    }

    public Rectangle constrainBounds(Rectangle bounds) {
        return this.constrainBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Rectangle constrainBounds(int x, int y, int w, int h) {
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        int maxW = this.getLWGC().getMaxTextureWidth();
        int maxH = this.getLWGC().getMaxTextureHeight();
        if (w > maxW) {
            w = maxW;
        }
        if (h > maxH) {
            h = maxH;
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public Point getLocationOnScreen() {
        return this.platformWindow.getLocationOnScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Insets getInsets() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.insets;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.platformWindow.getFontMetrics(f);
    }

    @Override
    public void toFront() {
        this.platformWindow.toFront();
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
    }

    @Override
    public void setZOrder(ComponentPeer above) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void updateAlwaysOnTopState() {
        this.platformWindow.setAlwaysOnTop(((Window)this.getTarget()).isAlwaysOnTop());
    }

    @Override
    public void updateFocusableWindowState() {
        this.targetFocusable = ((Window)this.getTarget()).isFocusableWindow();
        this.platformWindow.updateFocusableWindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModalBlocked(Dialog blocker, boolean blocked) {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            ComponentPeer peer = AWTAccessor.getComponentAccessor().getPeer(blocker);
            this.blocker = blocked && peer instanceof LWWindowPeer ? (LWWindowPeer)peer : null;
        }
        this.platformWindow.setModalBlocked(blocked);
    }

    @Override
    public void updateMinimumSize() {
        Dimension max;
        Dimension min;
        if (((Window)this.getTarget()).isMinimumSizeSet()) {
            min = ((Window)this.getTarget()).getMinimumSize();
            min.width = Math.max(min.width, 1);
            min.height = Math.max(min.height, 1);
        } else {
            min = new Dimension(1, 1);
        }
        if (((Window)this.getTarget()).isMaximumSizeSet()) {
            max = ((Window)this.getTarget()).getMaximumSize();
            max.width = Math.min(max.width, this.getLWGC().getMaxTextureWidth());
            max.height = Math.min(max.height, this.getLWGC().getMaxTextureHeight());
        } else {
            max = new Dimension(this.getLWGC().getMaxTextureWidth(), this.getLWGC().getMaxTextureHeight());
        }
        this.platformWindow.setSizeConstraints(min.width, min.height, max.width, max.height);
    }

    @Override
    public void updateIconImages() {
        this.getPlatformWindow().updateIconImages();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.updateOpaque();
    }

    @Override
    public void setOpacity(float opacity) {
        this.getPlatformWindow().setOpacity(opacity);
        this.repaintPeer();
    }

    @Override
    public final void setOpaque(boolean isOpaque) {
        if (this.isOpaque != isOpaque) {
            this.isOpaque = isOpaque;
            this.updateOpaque();
        }
    }

    private void updateOpaque() {
        this.getPlatformWindow().setOpaque(!this.isTranslucent());
        this.replaceSurfaceData(false);
        this.repaintPeer();
    }

    @Override
    public void updateWindow() {
    }

    public final boolean isTextured() {
        return this.textured;
    }

    public final void setTextured(boolean isTextured) {
        this.textured = isTextured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isTranslucent() {
        Object object = this.getStateLock();
        synchronized (object) {
            return !this.isOpaque || this.isShaped() || this.isTextured();
        }
    }

    @Override
    final void applyShapeImpl(Region shape) {
        super.applyShapeImpl(shape);
        this.updateOpaque();
    }

    @Override
    public void repositionSecurityWarning() {
        if (this.warningWindow != null) {
            AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
            Window target = (Window)this.getTarget();
            int x = compAccessor.getX(target);
            int y = compAccessor.getY(target);
            int width = compAccessor.getWidth(target);
            int height = compAccessor.getHeight(target);
            this.warningWindow.reposition(x, y, width, height);
        }
    }

    @Override
    public void setTitle(String title) {
        this.platformWindow.setTitle(title == null ? "" : title);
    }

    @Override
    public void setMenuBar(MenuBar mb) {
        this.platformWindow.setMenuBar(mb);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.platformWindow.setResizable(resizable);
    }

    @Override
    public void setState(int state) {
        this.platformWindow.setWindowState(state);
    }

    @Override
    public int getState() {
        return this.windowState;
    }

    @Override
    public void setMaximizedBounds(Rectangle bounds) {
    }

    @Override
    public void setBoundsPrivate(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 16387);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void blockWindows(List<Window> windows2) {
        for (Window w : windows2) {
            WindowPeer wp = (WindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
            if (wp == null) continue;
            wp.setModalBlocked((Dialog)this.getTarget(), true);
        }
    }

    @Override
    public void notifyIconify(boolean iconify) {
        WindowEvent iconifyEvent = new WindowEvent((Window)this.getTarget(), iconify ? 203 : 204);
        this.postEvent(iconifyEvent);
        int newWindowState = iconify ? 1 : 0;
        this.postWindowStateChangedEvent(newWindowState);
        if (!iconify) {
            this.repaintPeer();
        }
    }

    @Override
    public void notifyZoom(boolean isZoomed) {
        int newWindowState = isZoomed ? 6 : 0;
        this.postWindowStateChangedEvent(newWindowState);
    }

    @Override
    public void notifyExpose(Rectangle r) {
        this.repaintPeer(r);
    }

    @Override
    public void notifyReshape(int x, int y, int w, int h) {
        boolean resized;
        Rectangle oldBounds = this.getBounds();
        boolean invalid = this.updateInsets(this.platformWindow.getInsets());
        boolean moved = x != oldBounds.x || y != oldBounds.y;
        boolean bl = resized = w != oldBounds.width || h != oldBounds.height;
        if (!(moved || resized || invalid)) {
            return;
        }
        this.setBounds(x, y, w, h, 3, false, false);
        boolean isNewDevice = this.updateGraphicsDevice();
        if (resized || isNewDevice) {
            this.replaceSurfaceData();
            this.updateMinimumSize();
        }
        if (moved || invalid) {
            this.handleMove(x, y, true);
        }
        if (resized || invalid || isNewDevice) {
            this.handleResize(w, h, true);
            this.repaintPeer();
        }
        this.repositionSecurityWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBackground(int w, int h) {
        Graphics g = this.getOnscreenGraphics(this.getForeground(), this.getBackground(), this.getFont());
        if (g != null) {
            try {
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setComposite(AlphaComposite.Src);
                }
                if (this.isTranslucent()) {
                    g.setColor(nonOpaqueBackground);
                    g.fillRect(0, 0, w, h);
                }
                if (!this.isTextured()) {
                    if (g instanceof SunGraphics2D) {
                        ((SunGraphics2D)g).constrain(0, 0, w, h, this.getRegion());
                    }
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, w, h);
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    public void notifyUpdateCursor() {
        this.getLWToolkit().getCursorManager().updateCursorLater(this);
    }

    @Override
    public void notifyActivation(boolean activation, LWWindowPeer opposite) {
        Window oppositeWindow = opposite == null ? null : (Window)opposite.getTarget();
        this.changeFocusedWindow(activation, oppositeWindow);
    }

    @Override
    public void notifyNCMouseDown() {
        if (grabbingWindow != null && !grabbingWindow.isOneOfOwnersOf(this)) {
            grabbingWindow.ungrab();
        }
    }

    @Override
    public void notifyMouseEvent(int id, long when, int button, int x, int y, int screenX, int screenY, int modifiers, int clickCount, boolean popupTrigger, byte[] bdata) {
        Rectangle r = this.getBounds();
        LWWindowPeer targetPeer = this.findPeerAt(r.x + x, r.y + y);
        if (id == 505) {
            this.isMouseOver = false;
            if (this.lastMouseEventPeer != null) {
                if (this.lastMouseEventPeer.isEnabled()) {
                    Point lp = this.lastMouseEventPeer.windowToLocal(x, y, this);
                    Object target = this.lastMouseEventPeer.getTarget();
                    this.postMouseExitedEvent((Component)target, when, modifiers, lp, screenX, screenY, clickCount, popupTrigger, button);
                }
                if (lastCommonMouseEventPeer != null && lastCommonMouseEventPeer.getWindowPeerOrSelf() == this) {
                    lastCommonMouseEventPeer = null;
                }
                this.lastMouseEventPeer = null;
            }
        } else if (id == 504) {
            this.isMouseOver = true;
            if (targetPeer != null) {
                if (targetPeer.isEnabled()) {
                    Point lp = targetPeer.windowToLocal(x, y, this);
                    Object target = targetPeer.getTarget();
                    this.postMouseEnteredEvent((Component)target, when, modifiers, lp, screenX, screenY, clickCount, popupTrigger, button);
                }
                lastCommonMouseEventPeer = targetPeer;
                this.lastMouseEventPeer = targetPeer;
            }
        } else {
            int targetIdx;
            LWWindowPeer topmostWindowPeer;
            PlatformWindow topmostPlatformWindow = LWToolkit.getLWToolkit().getPlatformWindowUnderMouse();
            LWWindowPeer lWWindowPeer = topmostWindowPeer = topmostPlatformWindow != null ? topmostPlatformWindow.getPeer() : null;
            if (topmostWindowPeer == this || topmostWindowPeer == null) {
                this.generateMouseEnterExitEventsForComponents(when, button, x, y, screenX, screenY, modifiers, clickCount, popupTrigger, targetPeer);
            } else {
                LWComponentPeer<?, ?> topmostTargetPeer = topmostWindowPeer.findPeerAt(r.x + x, r.y + y);
                topmostWindowPeer.generateMouseEnterExitEventsForComponents(when, button, x, y, screenX, screenY, modifiers, clickCount, popupTrigger, topmostTargetPeer);
            }
            int eventButtonMask = button > 0 ? MouseEvent.getMaskForButton(button) : 0;
            int otherButtonsPressed = modifiers & ~eventButtonMask;
            int n = targetIdx = button > 3 ? 1 : button - 1;
            if (id == 501) {
                if (!this.isGrabbing() && grabbingWindow != null && !grabbingWindow.isOneOfOwnersOf(this)) {
                    grabbingWindow.ungrab();
                }
                mouseClickButtons = otherButtonsPressed == 0 ? eventButtonMask : (mouseClickButtons |= eventButtonMask);
                this.requestWindowFocus(CausedFocusEvent.Cause.MOUSE_EVENT);
                LWWindowPeer.mouseDownTarget[targetIdx] = targetPeer;
            } else if (id == 506) {
                targetPeer = mouseDownTarget[targetIdx];
                mouseClickButtons &= ~modifiers;
            } else if (id == 502) {
                targetPeer = mouseDownTarget[targetIdx];
                if ((modifiers & eventButtonMask) == 0) {
                    LWWindowPeer.mouseDownTarget[targetIdx] = null;
                }
            }
            if (targetPeer == null) {
                targetPeer = this;
            }
            Point lp = targetPeer.windowToLocal(x, y, this);
            if (targetPeer.isEnabled()) {
                MouseEvent event = new MouseEvent((Component)targetPeer.getTarget(), id, when, modifiers, lp.x, lp.y, screenX, screenY, clickCount, popupTrigger, button);
                this.postEvent(event);
            }
            if (id == 502) {
                if ((mouseClickButtons & eventButtonMask) != 0 && targetPeer.isEnabled()) {
                    this.postEvent(new MouseEvent((Component)targetPeer.getTarget(), 500, when, modifiers, lp.x, lp.y, screenX, screenY, clickCount, popupTrigger, button));
                }
                mouseClickButtons &= ~eventButtonMask;
            }
        }
        this.notifyUpdateCursor();
    }

    private void generateMouseEnterExitEventsForComponents(long when, int button, int x, int y, int screenX, int screenY, int modifiers, int clickCount, boolean popupTrigger, LWComponentPeer<?, ?> targetPeer) {
        Object target;
        if (!this.isMouseOver || targetPeer == this.lastMouseEventPeer) {
            return;
        }
        if (this.lastMouseEventPeer != null && this.lastMouseEventPeer.isEnabled()) {
            Point oldp = this.lastMouseEventPeer.windowToLocal(x, y, this);
            target = this.lastMouseEventPeer.getTarget();
            this.postMouseExitedEvent((Component)target, when, modifiers, oldp, screenX, screenY, clickCount, popupTrigger, button);
        }
        lastCommonMouseEventPeer = targetPeer;
        this.lastMouseEventPeer = targetPeer;
        if (targetPeer != null && targetPeer.isEnabled()) {
            Point newp = targetPeer.windowToLocal(x, y, this);
            target = targetPeer.getTarget();
            this.postMouseEnteredEvent((Component)target, when, modifiers, newp, screenX, screenY, clickCount, popupTrigger, button);
        }
    }

    private void postMouseEnteredEvent(Component target, long when, int modifiers, Point loc, int xAbs, int yAbs, int clickCount, boolean popupTrigger, int button) {
        this.updateSecurityWarningVisibility();
        this.postEvent(new MouseEvent(target, 504, when, modifiers, loc.x, loc.y, xAbs, yAbs, clickCount, popupTrigger, button));
    }

    private void postMouseExitedEvent(Component target, long when, int modifiers, Point loc, int xAbs, int yAbs, int clickCount, boolean popupTrigger, int button) {
        this.updateSecurityWarningVisibility();
        this.postEvent(new MouseEvent(target, 505, when, modifiers, loc.x, loc.y, xAbs, yAbs, clickCount, popupTrigger, button));
    }

    @Override
    public void notifyMouseWheelEvent(long when, int x, int y, int modifiers, int scrollType, int scrollAmount, int wheelRotation, double preciseWheelRotation, byte[] bdata) {
        Rectangle r = this.getBounds();
        LWComponentPeer<?, ?> targetPeer = this.findPeerAt(r.x + x, r.y + y);
        if (targetPeer == null || !targetPeer.isEnabled()) {
            return;
        }
        Point lp = targetPeer.windowToLocal(x, y, this);
        this.postEvent(new MouseWheelEvent((Component)targetPeer.getTarget(), 507, when, modifiers, lp.x, lp.y, 0, 0, 0, false, scrollType, scrollAmount, wheelRotation, preciseWheelRotation));
    }

    @Override
    public void notifyKeyEvent(int id, long when, int modifiers, int keyCode, char keyChar, int keyLocation) {
        LWKeyboardFocusManagerPeer kfmPeer = LWKeyboardFocusManagerPeer.getInstance();
        Component focusOwner = kfmPeer.getCurrentFocusOwner();
        if (focusOwner == null && (focusOwner = kfmPeer.getCurrentFocusedWindow()) == null) {
            focusOwner = this.getTarget();
        }
        KeyEvent keyEvent = new KeyEvent(focusOwner, id, when, modifiers, keyCode, keyChar, keyLocation);
        AWTAccessor.getKeyEventAccessor().setExtendedKeyCode(keyEvent, keyChar == '\uffff' ? (long)keyCode : (long)ExtendedKeyCodes.getExtendedKeyCodeForChar(keyChar));
        this.postEvent(keyEvent);
    }

    private void activateDisplayListener() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ((SunGraphicsEnvironment)ge).addDisplayChangedListener(this);
    }

    private void deactivateDisplayListener() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ((SunGraphicsEnvironment)ge).removeDisplayChangedListener(this);
    }

    private void postWindowStateChangedEvent(int newWindowState) {
        if (this.getTarget() instanceof Frame) {
            AWTAccessor.getFrameAccessor().setExtendedState((Frame)this.getTarget(), newWindowState);
        }
        WindowEvent stateChangedEvent = new WindowEvent((Window)this.getTarget(), 209, this.windowState, newWindowState);
        this.postEvent(stateChangedEvent);
        this.windowState = newWindowState;
        this.updateSecurityWarningVisibility();
    }

    private static int getGraphicsConfigScreen(GraphicsConfiguration gc) {
        GraphicsDevice gd = gc.getDevice();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        for (int i = 0; i < gds.length; ++i) {
            if (gds[i] != gd) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setGraphicsConfig(GraphicsConfiguration gc) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsConfig == gc) {
                return false;
            }
            this.graphicsConfig = gc;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGraphicsDevice() {
        GraphicsDevice newGraphicsDevice = this.platformWindow.getGraphicsDevice();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsDevice == newGraphicsDevice) {
                return false;
            }
            this.graphicsDevice = newGraphicsDevice;
        }
        final GraphicsConfiguration newGC = newGraphicsDevice.getDefaultConfiguration();
        if (!this.setGraphicsConfig(newGC)) {
            return false;
        }
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable(){

            @Override
            public void run() {
                AWTAccessor.getComponentAccessor().setGraphicsConfiguration((Component)LWWindowPeer.this.getTarget(), newGC);
            }
        });
        return true;
    }

    @Override
    public final void displayChanged() {
        if (this.updateGraphicsDevice()) {
            this.updateMinimumSize();
        }
        this.replaceSurfaceData();
        this.repaintPeer();
    }

    @Override
    public final void paletteChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData getSurfaceData() {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            return this.surfaceData;
        }
    }

    private void replaceSurfaceData() {
        this.replaceSurfaceData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSurfaceData(boolean blit) {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            SurfaceData oldData = this.getSurfaceData();
            this.surfaceData = this.platformWindow.replaceSurfaceData();
            Rectangle size = this.getSize();
            if (this.getSurfaceData() != null && oldData != this.getSurfaceData()) {
                this.clearBackground(size.width, size.height);
            }
            if (blit) {
                this.blitSurfaceData(oldData, this.getSurfaceData());
            }
            if (oldData != null && oldData != this.getSurfaceData()) {
                oldData.flush();
            }
        }
        LWWindowPeer.flushOnscreenGraphics();
    }

    private void blitSurfaceData(SurfaceData src, SurfaceData dst) {
        if (src != dst && src != null && dst != null && !(dst instanceof NullSurfaceData) && !(src instanceof NullSurfaceData) && src.getSurfaceType().equals(dst.getSurfaceType()) && src.getDefaultScale() == dst.getDefaultScale()) {
            Rectangle size = src.getBounds();
            Blit blit = Blit.locate(src.getSurfaceType(), CompositeType.Src, dst.getSurfaceType());
            if (blit != null) {
                blit.Blit(src, dst, AlphaComposite.Src, null, 0, 0, 0, 0, size.width, size.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean updateInsets(Insets newInsets) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.insets.equals(newInsets)) {
                return false;
            }
            this.insets = newInsets;
        }
        return true;
    }

    public static LWWindowPeer getWindowUnderCursor() {
        return lastCommonMouseEventPeer != null ? lastCommonMouseEventPeer.getWindowPeerOrSelf() : null;
    }

    public static LWComponentPeer<?, ?> getPeerUnderCursor() {
        return lastCommonMouseEventPeer;
    }

    public boolean requestWindowFocus(CausedFocusEvent.Cause cause) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("requesting native focus to " + this);
        }
        if (!this.focusAllowedFor()) {
            focusLog.fine("focus is not allowed");
            return false;
        }
        if (this.platformWindow.rejectFocusRequest(cause)) {
            return false;
        }
        AppContext targetAppContext = AWTAccessor.getComponentAccessor().getAppContext((Component)this.getTarget());
        KeyboardFocusManager kfm = AWTAccessor.getKeyboardFocusManagerAccessor().getCurrentKeyboardFocusManager(targetAppContext);
        Window currentActive = kfm.getActiveWindow();
        Window opposite = LWKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        if (this.isSimpleWindow()) {
            LWWindowPeer owner = LWWindowPeer.getOwnerFrameDialog(this);
            if (owner != null && !owner.platformWindow.isActive()) {
                LWWindowPeer currentActivePeer;
                if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                    focusLog.fine("requesting native focus to the owner " + owner);
                }
                LWWindowPeer lWWindowPeer = currentActivePeer = currentActive == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(currentActive);
                if (currentActivePeer != null && currentActivePeer.platformWindow.isActive()) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("the opposite is " + currentActivePeer);
                    }
                    currentActivePeer.skipNextFocusChange = true;
                }
                owner.skipNextFocusChange = true;
                owner.platformWindow.requestWindowFocus();
            }
            this.changeFocusedWindow(true, opposite);
            return true;
        }
        if (this.getTarget() == currentActive && !((Window)this.getTarget()).hasFocus()) {
            this.changeFocusedWindow(true, opposite);
            return true;
        }
        return this.platformWindow.requestWindowFocus();
    }

    protected boolean focusAllowedFor() {
        Window window = (Window)this.getTarget();
        return window.isVisible() && window.isEnabled() && this.isFocusableWindow();
    }

    private boolean isFocusableWindow() {
        boolean focusable = this.targetFocusable;
        if (this.isSimpleWindow()) {
            LWWindowPeer ownerPeer = LWWindowPeer.getOwnerFrameDialog(this);
            if (ownerPeer == null) {
                return false;
            }
            return focusable && ownerPeer.targetFocusable;
        }
        return focusable;
    }

    public boolean isSimpleWindow() {
        Window window = (Window)this.getTarget();
        return !(window instanceof Dialog) && !(window instanceof Frame);
    }

    @Override
    public void emulateActivation(boolean activate) {
        this.changeFocusedWindow(activate, null);
    }

    private boolean isOneOfOwnersOf(LWWindowPeer peer) {
        Window owner;
        Window window = owner = peer != null ? ((Window)peer.getTarget()).getOwner() : null;
        while (owner != null) {
            if ((LWWindowPeer)owner.getPeer() == this) {
                return true;
            }
            owner = owner.getOwner();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeFocusedWindow(boolean becomesFocused, Window opposite) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine((becomesFocused ? "gaining" : "loosing") + " focus window: " + this);
        }
        if (this.skipNextFocusChange) {
            focusLog.fine("skipping focus change");
            this.skipNextFocusChange = false;
            return;
        }
        if (!this.isFocusableWindow() && becomesFocused) {
            focusLog.fine("the window is not focusable");
            return;
        }
        if (becomesFocused) {
            Object object = LWWindowPeer.getPeerTreeLock();
            synchronized (object) {
                if (this.blocker != null) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
                        focusLog.finest("the window is blocked by " + this.blocker);
                    }
                    return;
                }
            }
        }
        if (!becomesFocused && (this.isGrabbing() || this.isOneOfOwnersOf(grabbingWindow))) {
            if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                focusLog.fine("ungrabbing on " + grabbingWindow);
            }
            grabbingWindow.ungrab();
        }
        LWKeyboardFocusManagerPeer kfmPeer = LWKeyboardFocusManagerPeer.getInstance();
        if (!becomesFocused && kfmPeer.getCurrentFocusedWindow() != this.getTarget()) {
            return;
        }
        kfmPeer.setCurrentFocusedWindow(becomesFocused ? (Window)this.getTarget() : null);
        int eventID = becomesFocused ? 207 : 208;
        TimedWindowEvent windowEvent = new TimedWindowEvent((Window)this.getTarget(), eventID, opposite, System.currentTimeMillis());
        this.postEvent(windowEvent);
    }

    static LWWindowPeer getOwnerFrameDialog(LWWindowPeer peer) {
        Window owner;
        Window window = owner = peer != null ? ((Window)peer.getTarget()).getOwner() : null;
        while (owner != null && !(owner instanceof Frame) && !(owner instanceof Dialog)) {
            owner = owner.getOwner();
        }
        return owner == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer getBlocker() {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            LWWindowPeer blocker = this.blocker;
            if (blocker == null) {
                return null;
            }
            while (blocker.blocker != null) {
                blocker = blocker.blocker;
            }
            return blocker;
        }
    }

    @Override
    public void enterFullScreenMode() {
        this.platformWindow.enterFullScreenMode();
        this.updateSecurityWarningVisibility();
    }

    @Override
    public void exitFullScreenMode() {
        this.platformWindow.exitFullScreenMode();
        this.updateSecurityWarningVisibility();
    }

    public long getLayerPtr() {
        return this.getPlatformWindow().getLayerPtr();
    }

    void grab() {
        if (grabbingWindow != null && !this.isGrabbing()) {
            grabbingWindow.ungrab();
        }
        grabbingWindow = this;
    }

    final void ungrab(boolean doPost) {
        if (this.isGrabbing()) {
            grabbingWindow = null;
            if (doPost) {
                this.postEvent(new UngrabEvent((Component)this.getTarget()));
            }
        }
    }

    void ungrab() {
        this.ungrab(true);
    }

    private boolean isGrabbing() {
        return this == grabbingWindow;
    }

    public PeerType getPeerType() {
        return this.peerType;
    }

    public void updateSecurityWarningVisibility() {
        if (this.warningWindow == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean show = false;
        if (!this.platformWindow.isFullScreenMode() && this.isVisible()) {
            if (LWKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == this.getTarget()) {
                show = true;
            }
            if (this.platformWindow.isUnderMouse() || this.warningWindow.isUnderMouse()) {
                show = true;
            }
        }
        this.warningWindow.setVisible(show, true);
    }

    public String toString() {
        return super.toString() + " [target is " + this.getTarget() + "]";
    }

    static {
        mouseDownTarget = new LWComponentPeer[3];
        mouseClickButtons = 0;
        DEFAULT_FONT = new Font("Lucida Grande", 0, 13);
        nonOpaqueBackground = new Color(0, 0, 0, 0);
    }

    public static enum PeerType {
        SIMPLEWINDOW,
        FRAME,
        DIALOG,
        EMBEDDED_FRAME,
        VIEW_EMBEDDED_FRAME,
        LW_FRAME;

    }
}

