/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleBundle;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CAccessible;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;

class CAccessibility
implements PropertyChangeListener {
    private static Set<String> ignoredRoles;
    static CAccessibility sAccessibility;
    private static final Field FIELD_KEY;
    static final int JAVA_AX_ALL_CHILDREN = -1;
    static final int JAVA_AX_SELECTED_CHILDREN = -2;
    static final int JAVA_AX_VISIBLE_CHILDREN = -3;

    static synchronized CAccessibility getAccessibility(String[] roles) {
        if (sAccessibility != null) {
            return sAccessibility;
        }
        sAccessibility = new CAccessibility();
        if (roles != null) {
            ignoredRoles = new HashSet<String>(roles.length);
            for (String role : roles) {
                ignoredRoles.add(role);
            }
        } else {
            ignoredRoles = new HashSet<String>();
        }
        return sAccessibility;
    }

    private CAccessibility() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AccessibleContext nvAC;
        AccessibleRole nvRole;
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (newValue instanceof Accessible && !ignoredRoles.contains(CAccessibility.roleKey(nvRole = (nvAC = ((Accessible)newValue).getAccessibleContext()).getAccessibleRole()))) {
            this.focusChanged();
        }
    }

    private native void focusChanged();

    static <T> T invokeAndWait(Callable<T> callable, Component c) {
        try {
            return LWCToolkit.invokeAndWait(callable, c);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static <T> T invokeAndWait(Callable<T> callable, Component c, T defValue) {
        T value = null;
        try {
            value = LWCToolkit.invokeAndWait(callable, c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value != null ? value : (T)defValue;
    }

    static void invokeLater(Runnable runnable, Component c) {
        try {
            LWCToolkit.invokeLater(runnable, c);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String getAccessibleActionDescription(final AccessibleAction aa, final int index, Component c) {
        if (aa == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return aa.getAccessibleActionDescription(index);
            }
        }, c);
    }

    public static void doAccessibleAction(final AccessibleAction aa, final int index, Component c) {
        if (aa == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                aa.doAccessibleAction(index);
            }
        }, c);
    }

    public static Dimension getSize(final AccessibleComponent ac, Component c) {
        if (ac == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Dimension>(){

            @Override
            public Dimension call() throws Exception {
                return ac.getSize();
            }
        }, c);
    }

    public static AccessibleSelection getAccessibleSelection(final AccessibleContext ac, Component c) {
        if (ac == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleSelection>(){

            @Override
            public AccessibleSelection call() throws Exception {
                return ac.getAccessibleSelection();
            }
        }, c);
    }

    public static Accessible ax_getAccessibleSelection(final AccessibleContext ac, final int index, Component c) {
        if (ac == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                AccessibleSelection as = ac.getAccessibleSelection();
                if (as == null) {
                    return null;
                }
                return as.getAccessibleSelection(index);
            }
        }, c);
    }

    public static void addAccessibleSelection(final AccessibleContext ac, final int index, Component c) {
        if (ac == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleSelection as = ac.getAccessibleSelection();
                if (as == null) {
                    return;
                }
                as.addAccessibleSelection(index);
            }
        }, c);
    }

    public static AccessibleContext getAccessibleContext(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return a.getAccessibleContext();
            }
        }, c);
    }

    public static boolean isAccessibleChildSelected(final Accessible a, final int index, Component c) {
        if (a == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return Boolean.FALSE;
                }
                AccessibleSelection as = ac.getAccessibleSelection();
                if (as == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(as.isAccessibleChildSelected(index));
            }
        }, c, false);
    }

    public static AccessibleStateSet getAccessibleStateSet(final AccessibleContext ac, Component c) {
        if (ac == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleStateSet>(){

            @Override
            public AccessibleStateSet call() throws Exception {
                return ac.getAccessibleStateSet();
            }
        }, c);
    }

    public static boolean contains(final AccessibleContext ac, final AccessibleState as, Component c) {
        if (ac == null || as == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleStateSet ass = ac.getAccessibleStateSet();
                if (ass == null) {
                    return null;
                }
                return ass.contains(as);
            }
        }, c, false);
    }

    static Field getAccessibleBundleKeyFieldWithReflection() {
        try {
            Field fieldKey = AccessibleBundle.class.getDeclaredField("key");
            fieldKey.setAccessible(true);
            return fieldKey;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    static String getAccessibleRoleFor(Accessible a) {
        AccessibleContext ac = a.getAccessibleContext();
        if (ac == null) {
            return null;
        }
        AccessibleRole role = ac.getAccessibleRole();
        try {
            return (String)FIELD_KEY.get(role);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getAccessibleRole(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Accessible sa = CAccessible.getSwingAccessible(a);
                String role = CAccessibility.getAccessibleRoleFor(a);
                if (!"text".equals(role)) {
                    return role;
                }
                if (sa instanceof JTextArea || sa instanceof JEditorPane) {
                    return "textarea";
                }
                return role;
            }
        }, c);
    }

    public static Point getLocationOnScreen(final AccessibleComponent ac, Component c) {
        if (ac == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Point>(){

            @Override
            public Point call() throws Exception {
                return ac.getLocationOnScreen();
            }
        }, c);
    }

    public static int getCharCount(final AccessibleText at, Component c) {
        if (at == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return at.getCharCount();
            }
        }, c, 0);
    }

    public static Accessible getAccessibleParent(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleParent();
            }
        }, c);
    }

    public static int getAccessibleIndexInParent(final Accessible a, Component c) {
        if (a == null) {
            return -1;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleIndexInParent();
            }
        }, c, -1);
    }

    public static AccessibleComponent getAccessibleComponent(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleComponent>(){

            @Override
            public AccessibleComponent call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleComponent();
            }
        }, c);
    }

    public static AccessibleValue getAccessibleValue(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleValue>(){

            @Override
            public AccessibleValue call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleValue accessibleValue = ac.getAccessibleValue();
                return accessibleValue;
            }
        }, c);
    }

    public static String getAccessibleName(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                String accessibleName = ac.getAccessibleName();
                if (accessibleName == null) {
                    return ac.getAccessibleDescription();
                }
                return accessibleName;
            }
        }, c);
    }

    public static AccessibleText getAccessibleText(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleText>(){

            @Override
            public AccessibleText call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleText accessibleText = ac.getAccessibleText();
                return accessibleText;
            }
        }, c);
    }

    public static String getAccessibleDescription(final Accessible a, final Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String toolTipText;
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                String accessibleDescription = ac.getAccessibleDescription();
                if (accessibleDescription == null && c instanceof JComponent && (toolTipText = ((JComponent)c).getToolTipText()) != null) {
                    return toolTipText;
                }
                return accessibleDescription;
            }
        }, c);
    }

    public static boolean isFocusTraversable(final Accessible a, Component c) {
        if (a == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleComponent aComp = ac.getAccessibleComponent();
                if (aComp == null) {
                    return null;
                }
                return aComp.isFocusTraversable();
            }
        }, c, false);
    }

    public static Accessible accessibilityHitTest(final Container parent, final float hitPointX, final float hitPointY) {
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                Point p = parent.getLocationOnScreen();
                Point localPoint = new Point((int)((double)hitPointX - p.getX()), (int)((double)hitPointY - p.getY()));
                Component component = parent.findComponentAt(localPoint);
                if (component == null) {
                    return null;
                }
                AccessibleContext axContext = component.getAccessibleContext();
                if (axContext == null) {
                    return null;
                }
                AccessibleComponent axComponent = axContext.getAccessibleComponent();
                if (axComponent == null) {
                    return null;
                }
                int numChildren = axContext.getAccessibleChildrenCount();
                if (numChildren > 0) {
                    Point p2 = axComponent.getLocationOnScreen();
                    Point localP2 = new Point((int)((double)hitPointX - p2.getX()), (int)((double)hitPointY - p2.getY()));
                    return CAccessible.getCAccessible(axComponent.getAccessibleAt(localP2));
                }
                if (!(component instanceof Accessible)) {
                    return null;
                }
                return CAccessible.getCAccessible((Accessible)((Object)component));
            }
        }, parent);
    }

    public static AccessibleAction getAccessibleAction(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleAction>(){

            @Override
            public AccessibleAction call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleAction();
            }
        }, c);
    }

    public static boolean isEnabled(final Accessible a, Component c) {
        if (a == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleComponent aComp = ac.getAccessibleComponent();
                if (aComp == null) {
                    return null;
                }
                return aComp.isEnabled();
            }
        }, c, false);
    }

    public static void requestFocus(final Accessible a, Component c) {
        if (a == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return;
                }
                AccessibleComponent aComp = ac.getAccessibleComponent();
                if (aComp == null) {
                    return;
                }
                aComp.requestFocus();
            }
        }, c);
    }

    public static void requestSelection(final Accessible a, Component c) {
        if (a == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return;
                }
                int i = ac.getAccessibleIndexInParent();
                if (i == -1) {
                    return;
                }
                Accessible parent = ac.getAccessibleParent();
                AccessibleContext pac = parent.getAccessibleContext();
                if (pac == null) {
                    return;
                }
                AccessibleSelection as = pac.getAccessibleSelection();
                if (as == null) {
                    return;
                }
                as.addAccessibleSelection(i);
            }
        }, c);
    }

    public static Number getMaximumAccessibleValue(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleValue av = ac.getAccessibleValue();
                if (av == null) {
                    return null;
                }
                return av.getMaximumAccessibleValue();
            }
        }, c);
    }

    public static Number getMinimumAccessibleValue(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleValue av = ac.getAccessibleValue();
                if (av == null) {
                    return null;
                }
                return av.getMinimumAccessibleValue();
            }
        }, c);
    }

    public static String getAccessibleRoleDisplayString(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleRole ar = ac.getAccessibleRole();
                if (ar == null) {
                    return null;
                }
                return ar.toDisplayString();
            }
        }, c);
    }

    public static Number getCurrentAccessibleValue(final AccessibleValue av, Component c) {
        if (av == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                Number currentAccessibleValue = av.getCurrentAccessibleValue();
                return currentAccessibleValue;
            }
        }, c);
    }

    public static Accessible getFocusOwner(Component c) {
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (c == null || !(c instanceof Accessible)) {
                    return null;
                }
                return CAccessible.getCAccessible((Accessible)((Object)c));
            }
        }, c);
    }

    public static boolean[] getInitialAttributeStates(final Accessible a, Component c) {
        final boolean[] ret = new boolean[7];
        if (a == null) {
            return ret;
        }
        return CAccessibility.invokeAndWait(new Callable<boolean[]>(){

            @Override
            public boolean[] call() throws Exception {
                AccessibleContext aContext = a.getAccessibleContext();
                if (aContext == null) {
                    return ret;
                }
                AccessibleComponent aComponent = aContext.getAccessibleComponent();
                ret[0] = aComponent != null;
                ret[1] = aComponent != null && aComponent.isFocusTraversable();
                ret[2] = aContext.getAccessibleValue() != null;
                ret[3] = aContext.getAccessibleText() != null;
                AccessibleStateSet aStateSet = aContext.getAccessibleStateSet();
                ret[4] = aStateSet.contains(AccessibleState.HORIZONTAL) || aStateSet.contains(AccessibleState.VERTICAL);
                ret[5] = aContext.getAccessibleName() != null;
                ret[6] = aContext.getAccessibleChildrenCount() > 0;
                return ret;
            }
        }, c);
    }

    public static Object[] getChildrenAndRoles(final Accessible a, Component c, final int whichChildren, final boolean allowIgnored) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                AccessibleContext activeDescendantAC;
                ArrayList childrenAndRoles = new ArrayList();
                CAccessibility._addChildren(a, whichChildren, allowIgnored, childrenAndRoles);
                if (whichChildren == -2 && !childrenAndRoles.isEmpty() && (activeDescendantAC = CAccessible.getActiveDescendant(a)) != null) {
                    String activeDescendantName = activeDescendantAC.getAccessibleName();
                    AccessibleRole activeDescendantRole = activeDescendantAC.getAccessibleRole();
                    ArrayList<Object> newArray = new ArrayList<Object>();
                    int count = childrenAndRoles.size();
                    Accessible currentAccessible = null;
                    AccessibleContext currentAC = null;
                    String currentName = null;
                    AccessibleRole currentRole = null;
                    for (int i = 0; i < count; i += 2) {
                        currentAccessible = (Accessible)childrenAndRoles.get(i);
                        currentAC = currentAccessible.getAccessibleContext();
                        currentName = currentAC.getAccessibleName();
                        currentRole = (AccessibleRole)childrenAndRoles.get(i + 1);
                        if (currentName.equals(activeDescendantName) && currentRole.equals(activeDescendantRole)) {
                            newArray.add(0, currentAccessible);
                            newArray.add(1, currentRole);
                            continue;
                        }
                        newArray.add(currentAccessible);
                        newArray.add(currentRole);
                    }
                    childrenAndRoles = newArray;
                }
                if (whichChildren < 0 || whichChildren * 2 >= childrenAndRoles.size()) {
                    return childrenAndRoles.toArray();
                }
                return new Object[]{childrenAndRoles.get(whichChildren * 2), childrenAndRoles.get(whichChildren * 2 + 1)};
            }
        }, c);
    }

    private static AccessibleRole getAccessibleRoleForLabel(JLabel l, AccessibleRole fallback) {
        String text = l.getText();
        if (text != null && text.length() > 0) {
            return fallback;
        }
        Icon icon = l.getIcon();
        if (icon != null) {
            return AccessibleRole.ICON;
        }
        return fallback;
    }

    private static AccessibleRole getAccessibleRole(Accessible a) {
        AccessibleContext ac = a.getAccessibleContext();
        AccessibleRole role = ac.getAccessibleRole();
        Accessible component = CAccessible.getSwingAccessible(a);
        if (role == null) {
            return null;
        }
        String roleString = role.toString();
        if ("label".equals(roleString) && component instanceof JLabel) {
            return CAccessibility.getAccessibleRoleForLabel((JLabel)component, role);
        }
        return role;
    }

    private static void _addChildren(Accessible a, int whichChildren, boolean allowIgnored, ArrayList<Object> childrenAndRoles) {
        if (a == null) {
            return;
        }
        AccessibleContext ac = a.getAccessibleContext();
        if (ac == null) {
            return;
        }
        int numChildren = ac.getAccessibleChildrenCount();
        for (int i = 0; i < numChildren; ++i) {
            AccessibleComponent acomp;
            AccessibleSelection sel;
            AccessibleContext context;
            Accessible child = ac.getAccessibleChild(i);
            if (child == null || (context = child.getAccessibleContext()) == null || (whichChildren != -3 ? whichChildren == -2 && ((sel = ac.getAccessibleSelection()) == null || !sel.isAccessibleChildSelected(i)) : (acomp = context.getAccessibleComponent()) == null || !acomp.isVisible())) continue;
            if (!allowIgnored) {
                AccessibleRole role = context.getAccessibleRole();
                if (role != null && ignoredRoles != null && ignoredRoles.contains(CAccessibility.roleKey(role))) {
                    CAccessibility._addChildren(child, whichChildren, false, childrenAndRoles);
                } else {
                    childrenAndRoles.add(child);
                    childrenAndRoles.add(CAccessibility.getAccessibleRole(child));
                }
            } else {
                childrenAndRoles.add(child);
                childrenAndRoles.add(CAccessibility.getAccessibleRole(child));
            }
            if (whichChildren < 0 || childrenAndRoles.size() / 2 < whichChildren + 1) continue;
            return;
        }
    }

    private static native String roleKey(AccessibleRole var0);

    public static Object[] getChildren(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                int numChildren = ac.getAccessibleChildrenCount();
                Object[] children = new Object[numChildren];
                for (int i = 0; i < numChildren; ++i) {
                    children[i] = ac.getAccessibleChild(i);
                }
                return children;
            }
        }, c);
    }

    private static long getAWTView(Accessible a) {
        final Accessible ax = CAccessible.getSwingAccessible(a);
        if (!(ax instanceof Component)) {
            return 0L;
        }
        return CAccessibility.invokeAndWait(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                LWWindowPeer peer;
                Component cont;
                for (cont = (Component)((Object)ax); cont != null && !(cont instanceof Window); cont = cont.getParent()) {
                }
                if (cont != null && (peer = (LWWindowPeer)cont.getPeer()) != null) {
                    return ((CPlatformWindow)peer.getPlatformWindow()).getContentView().getAWTView();
                }
                return 0L;
            }
        }, (Component)((Object)ax));
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
        FIELD_KEY = CAccessibility.getAccessibleBundleKeyFieldWithReflection();
    }
}

