/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.lwawt.macosx.CFRetainedResource;

class CAccessible
extends CFRetainedResource
implements Accessible {
    private static Field nativeAXResourceField = CAccessible.getNativeAXResourceField();
    private Accessible accessible;
    private AccessibleContext activeDescendant;

    static Field getNativeAXResourceField() {
        try {
            Field field = AccessibleContext.class.getDeclaredField("nativeAXResource");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CAccessible getCAccessible(Accessible a) {
        if (a == null) {
            return null;
        }
        AccessibleContext context = a.getAccessibleContext();
        try {
            CAccessible cachedCAX = (CAccessible)nativeAXResourceField.get(context);
            if (cachedCAX != null) {
                return cachedCAX;
            }
            CAccessible newCAX = new CAccessible(a);
            nativeAXResourceField.set(context, newCAX);
            return newCAX;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static native void unregisterFromCocoaAXSystem(long var0);

    private static native void valueChanged(long var0);

    private static native void selectedTextChanged(long var0);

    private static native void selectionChanged(long var0);

    private static native void menuOpened(long var0);

    private static native void menuClosed(long var0);

    private static native void menuItemSelected(long var0);

    private CAccessible(Accessible accessible) {
        super(0L, true);
        if (accessible == null) {
            throw new NullPointerException();
        }
        this.accessible = accessible;
        if (accessible instanceof Component) {
            this.addNotificationListeners((Component)((Object)accessible));
        }
    }

    @Override
    protected synchronized void dispose() {
        if (this.ptr != 0L) {
            CAccessible.unregisterFromCocoaAXSystem(this.ptr);
        }
        super.dispose();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessible.getAccessibleContext();
    }

    public void addNotificationListeners(Component c) {
        if (c instanceof Accessible) {
            AccessibleContext ac = ((Accessible)((Object)c)).getAccessibleContext();
            ac.addPropertyChangeListener(new AXChangeNotifier());
        }
        if (c instanceof JProgressBar) {
            JProgressBar pb = (JProgressBar)c;
            pb.addChangeListener(new AXProgressChangeNotifier());
        } else if (c instanceof JSlider) {
            JSlider slider = (JSlider)c;
            slider.addChangeListener(new AXProgressChangeNotifier());
        }
    }

    static Accessible getSwingAccessible(Accessible a) {
        return a instanceof CAccessible ? ((CAccessible)a).accessible : a;
    }

    static AccessibleContext getActiveDescendant(Accessible a) {
        return a instanceof CAccessible ? ((CAccessible)a).activeDescendant : null;
    }

    private class AXProgressChangeNotifier
    implements ChangeListener {
        private AXProgressChangeNotifier() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }
    }

    private class AXChangeNotifier
    implements PropertyChangeListener {
        private AXChangeNotifier() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (CAccessible.this.ptr != 0L) {
                Object newValue = e.getNewValue();
                Object oldValue = e.getOldValue();
                if (name.compareTo("AccessibleCaret") == 0) {
                    CAccessible.selectedTextChanged(CAccessible.this.ptr);
                } else if (name.compareTo("AccessibleText") == 0) {
                    CAccessible.valueChanged(CAccessible.this.ptr);
                } else if (name.compareTo("AccessibleSelection") == 0) {
                    CAccessible.selectionChanged(CAccessible.this.ptr);
                } else if (name.compareTo("AccessibleActiveDescendant") == 0) {
                    if (newValue instanceof AccessibleContext) {
                        CAccessible.this.activeDescendant = (AccessibleContext)newValue;
                    }
                } else if (name.compareTo("AccessibleState") == 0) {
                    AccessibleContext thisAC = CAccessible.this.accessible.getAccessibleContext();
                    AccessibleRole thisRole = thisAC.getAccessibleRole();
                    Accessible parentAccessible = thisAC.getAccessibleParent();
                    AccessibleRole parentRole = null;
                    if (parentAccessible != null) {
                        parentRole = parentAccessible.getAccessibleContext().getAccessibleRole();
                    }
                    if (parentRole != AccessibleRole.COMBO_BOX) {
                        if (thisRole == AccessibleRole.POPUP_MENU) {
                            if (newValue != null && (AccessibleState)newValue == AccessibleState.VISIBLE) {
                                CAccessible.menuOpened(CAccessible.this.ptr);
                            } else if (oldValue != null && (AccessibleState)oldValue == AccessibleState.VISIBLE) {
                                CAccessible.menuClosed(CAccessible.this.ptr);
                            }
                        } else if (thisRole == AccessibleRole.MENU_ITEM && newValue != null && (AccessibleState)newValue == AccessibleState.FOCUSED) {
                            CAccessible.menuItemSelected(CAccessible.this.ptr);
                        }
                    }
                }
            }
        }
    }
}

