/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.Callable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleText;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import sun.lwawt.macosx.CAccessibility;
import sun.lwawt.macosx.CAccessible;

class CAccessibleText {
    CAccessibleText() {
    }

    static AccessibleEditableText getAccessibleEditableText(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleEditableText>(){

            @Override
            public AccessibleEditableText call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleEditableText();
            }
        }, c);
    }

    static String getSelectedText(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleText at = ac.getAccessibleText();
                if (at == null) {
                    return null;
                }
                return at.getSelectedText();
            }
        }, c);
    }

    static void setSelectedText(final Accessible a, Component c, final String newText) {
        if (a == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return;
                }
                AccessibleEditableText aet = ac.getAccessibleEditableText();
                if (aet == null) {
                    return;
                }
                int selectionStart = aet.getSelectionStart();
                int selectionEnd = aet.getSelectionEnd();
                aet.replaceText(selectionStart, selectionEnd, newText);
            }
        }, c);
    }

    static void setSelectedTextRange(final Accessible a, Component c, final int startIndex, final int endIndex) {
        if (a == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean validRange;
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return;
                }
                AccessibleEditableText aet = ac.getAccessibleEditableText();
                if (aet == null) {
                    return;
                }
                boolean bl = validRange = startIndex >= 0 && endIndex >= startIndex && endIndex <= aet.getCharCount();
                if (!validRange) {
                    return;
                }
                aet.selectText(startIndex, endIndex);
            }
        }, c);
    }

    static String getTextRange(final AccessibleEditableText aet, final int start, final int stop, Component c) {
        if (aet == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return aet.getTextRange(start, stop);
            }
        }, c);
    }

    static int getCharacterIndexAtPosition(final Accessible a, Component c, final int x, final int y) {
        if (a == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleText at = ac.getAccessibleText();
                if (at == null) {
                    return null;
                }
                Point componentLocation = ac.getAccessibleComponent().getLocationOnScreen();
                int localX = x - (int)componentLocation.getX();
                int localY = y - (int)componentLocation.getY();
                return at.getIndexAtPoint(new Point(localX, localY));
            }
        }, c);
    }

    static int[] getSelectedTextRange(final Accessible a, Component c) {
        if (a == null) {
            return new int[2];
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return new int[2];
                }
                AccessibleText at = ac.getAccessibleText();
                if (at == null) {
                    return new int[2];
                }
                int[] ret = new int[]{at.getSelectionStart(), at.getSelectionEnd()};
                return ret;
            }
        }, c);
    }

    static int[] getVisibleCharacterRange(final Accessible a, Component c) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                return CAccessibleText.getVisibleCharacterRange(a);
            }
        }, c);
    }

    static int getLineNumberForIndex(final Accessible a, Component c, final int index) {
        if (a == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return CAccessibleText.getLineNumberForIndex(a, index);
            }
        }, c);
    }

    static int getLineNumberForInsertionPoint(final Accessible a, Component c) {
        if (a == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return CAccessibleText.getLineNumberForInsertionPoint(a);
            }
        }, c);
    }

    static int[] getRangeForLine(final Accessible a, Component c, final int line) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                return CAccessibleText.getRangeForLine(a, line);
            }
        }, c);
    }

    static int[] getRangeForIndex(final Accessible a, Component c, final int index) {
        if (a == null) {
            return new int[2];
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return new int[2];
                }
                AccessibleEditableText aet = ac.getAccessibleEditableText();
                if (aet == null) {
                    return new int[2];
                }
                int charCount = aet.getCharCount();
                if (index >= charCount) {
                    return new int[2];
                }
                String foundWord = aet.getAtIndex(2, index);
                int foundWordLength = foundWord.length();
                String wholeString = aet.getTextRange(0, charCount - 1);
                int foundWordIndex = -1;
                for (int offset = 0; foundWordIndex == -1 && offset < foundWordLength; ++offset) {
                    if (wholeString.regionMatches(true, index - offset, foundWord, 0, foundWordLength)) {
                        foundWordIndex = index - offset;
                    }
                    if (!wholeString.regionMatches(true, index + offset, foundWord, 0, foundWordLength)) continue;
                    foundWordIndex = index + offset;
                }
                int[] ret = new int[]{foundWordIndex, foundWordIndex + foundWordLength};
                return ret;
            }
        }, c);
    }

    static double[] getBoundsForRange(final Accessible a, Component c, final int location, final int length) {
        final double[] ret = new double[4];
        if (a == null) {
            return ret;
        }
        return CAccessibility.invokeAndWait(new Callable<double[]>(){

            @Override
            public double[] call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return ret;
                }
                AccessibleText at = ac.getAccessibleText();
                if (at == null) {
                    ac.getAccessibleName();
                    ac.getAccessibleEditableText();
                    return ret;
                }
                Rectangle boundsStart = at.getCharacterBounds(location);
                Rectangle boundsEnd = at.getCharacterBounds(location + length - 1);
                if (boundsEnd == null || boundsStart == null) {
                    return ret;
                }
                Rectangle2D boundsUnion = ((Rectangle2D)boundsStart).createUnion(boundsEnd);
                if (boundsUnion.isEmpty()) {
                    return ret;
                }
                double localX = boundsUnion.getX();
                double localY = boundsUnion.getY();
                Point componentLocation = ac.getAccessibleComponent().getLocationOnScreen();
                if (componentLocation == null) {
                    return ret;
                }
                double screenX = componentLocation.getX() + localX;
                double screenY = componentLocation.getY() + localY;
                ret[0] = screenX;
                ret[1] = screenY;
                ret[2] = boundsUnion.getWidth();
                ret[3] = boundsUnion.getHeight();
                return ret;
            }
        }, c);
    }

    static String getStringForRange(final Accessible a, Component c, final int location, final int length) {
        if (a == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext ac = a.getAccessibleContext();
                if (ac == null) {
                    return null;
                }
                AccessibleEditableText aet = ac.getAccessibleEditableText();
                if (aet == null) {
                    return null;
                }
                return aet.getTextRange(location, location + length);
            }
        }, c);
    }

    static int[] getVisibleCharacterRange(Accessible a) {
        Accessible sa = CAccessible.getSwingAccessible(a);
        if (!(sa instanceof JTextComponent)) {
            return null;
        }
        JTextComponent jc = (JTextComponent)sa;
        Rectangle rect = jc.getVisibleRect();
        Point topLeft = new Point(rect.x, rect.y);
        Point topRight = new Point(rect.x + rect.width, rect.y);
        Point bottomLeft = new Point(rect.x, rect.y + rect.height);
        Point bottomRight = new Point(rect.x + rect.width, rect.y + rect.height);
        int start = Math.min(jc.viewToModel(topLeft), jc.viewToModel(topRight));
        int end = Math.max(jc.viewToModel(bottomLeft), jc.viewToModel(bottomRight));
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return new int[]{start, end};
    }

    static int getLineNumberForIndex(Accessible a, int index) {
        Accessible sa = CAccessible.getSwingAccessible(a);
        if (!(sa instanceof JTextComponent)) {
            return -1;
        }
        JTextComponent jc = (JTextComponent)sa;
        Element root = jc.getDocument().getDefaultRootElement();
        if (index == -1) {
            index = jc.getCaretPosition();
        }
        return root.getElementIndex(index);
    }

    static int getLineNumberForInsertionPoint(Accessible a) {
        return CAccessibleText.getLineNumberForIndex(a, -1);
    }

    static int[] getRangeForLine(Accessible a, int lineIndex) {
        Accessible sa = CAccessible.getSwingAccessible(a);
        if (!(sa instanceof JTextComponent)) {
            return null;
        }
        JTextComponent jc = (JTextComponent)sa;
        Element root = jc.getDocument().getDefaultRootElement();
        Element line = root.getElement(lineIndex);
        if (line == null) {
            return null;
        }
        return new int[]{line.getStartOffset(), line.getEndOffset()};
    }
}

