/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;

final class CClipboard
extends SunClipboard {
    public CClipboard(String name) {
        super(name);
    }

    @Override
    public long getID() {
        return 0L;
    }

    @Override
    protected void clearNativeContext() {
    }

    @Override
    public synchronized Transferable getContents(Object requestor) {
        this.checkPasteboardAndNotify();
        return super.getContents(requestor);
    }

    @Override
    protected synchronized Transferable getContextContents() {
        this.checkPasteboardAndNotify();
        return super.getContextContents();
    }

    @Override
    protected void setContentsNative(Transferable contents) {
        FlavorTable flavorMap = CClipboard.getDefaultFlavorTable();
        DataTransferer dataTransferer = DataTransferer.getInstance();
        long[] formatArray = dataTransferer.getFormatsForTransferableAsArray(contents, flavorMap);
        this.declareTypes(formatArray, this);
        SortedMap<Long, DataFlavor> formatMap = dataTransferer.getFormatsForTransferable(contents, flavorMap);
        for (Map.Entry entry : formatMap.entrySet()) {
            long format = (Long)entry.getKey();
            DataFlavor flavor = (DataFlavor)entry.getValue();
            try {
                byte[] bytes = DataTransferer.getInstance().translateTransferable(contents, flavor, format);
                this.setData(bytes, format);
            }
            catch (IOException e) {
                if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref") && e instanceof NotSerializableException) continue;
                e.printStackTrace();
            }
        }
        CClipboard.notifyChanged();
    }

    @Override
    protected native long[] getClipboardFormats();

    @Override
    protected native byte[] getClipboardData(long var1) throws IOException;

    @Override
    protected void unregisterClipboardViewerChecked() {
    }

    @Override
    protected void registerClipboardViewerChecked() {
    }

    private native void declareTypes(long[] var1, SunClipboard var2);

    private native void setData(byte[] var1, long var2);

    void checkPasteboardAndNotify() {
        if (this.checkPasteboardWithoutNotification()) {
            CClipboard.notifyChanged();
            this.lostOwnershipNow(null);
        }
    }

    native boolean checkPasteboardWithoutNotification();

    private void notifyLostOwnership() {
        this.lostOwnershipImpl();
    }

    private static void notifyChanged() {
        CClipboard clipboard = (CClipboard)Toolkit.getDefaultToolkit().getSystemClipboard();
        if (!clipboard.areFlavorListenersRegistered()) {
            return;
        }
        clipboard.checkChange(clipboard.getClipboardFormats());
    }
}

