/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.Point2D;
import sun.lwawt.LWCursorManager;
import sun.lwawt.macosx.CCustomCursor;

final class CCursorManager
extends LWCursorManager {
    private static final int NAMED_CURSOR = -1;
    private static final CCursorManager theInstance = new CCursorManager();
    private volatile Cursor currentCursor;

    private static native Point2D nativeGetCursorPosition();

    private static native void nativeSetBuiltInCursor(int var0, String var1);

    private static native void nativeSetCustomCursor(long var0, double var2, double var4);

    public static native void nativeSetAllowsCursorSetInBackground(boolean var0);

    public static CCursorManager getInstance() {
        return theInstance;
    }

    private CCursorManager() {
    }

    @Override
    protected Point getCursorPosition() {
        Point2D nativePosition = CCursorManager.nativeGetCursorPosition();
        return new Point((int)nativePosition.getX(), (int)nativePosition.getY());
    }

    @Override
    protected void setCursor(Cursor cursor) {
        if (cursor == this.currentCursor) {
            return;
        }
        this.currentCursor = cursor;
        if (cursor == null) {
            CCursorManager.nativeSetBuiltInCursor(0, null);
            return;
        }
        if (cursor instanceof CCustomCursor) {
            CCustomCursor customCursor = (CCustomCursor)cursor;
            long imagePtr = customCursor.getImageData();
            if (imagePtr != 0L) {
                Point hotSpot = customCursor.getHotSpot();
                CCursorManager.nativeSetCustomCursor(imagePtr, hotSpot.x, hotSpot.y);
            }
            return;
        }
        int type = cursor.getType();
        if (type != -1) {
            CCursorManager.nativeSetBuiltInCursor(type, null);
            return;
        }
        String name = cursor.getName();
        if (name != null) {
            CCursorManager.nativeSetBuiltInCursor(-1, name);
            return;
        }
        throw new RuntimeException("Unimplemented");
    }
}

