/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import sun.lwawt.macosx.CImage;

public class CCustomCursor
extends Cursor {
    static Dimension sMaxCursorSize;
    Image fImage;
    Point fHotspot;
    int fWidth;
    int fHeight;
    CImage fCImage;

    static Dimension getMaxCursorSize() {
        if (sMaxCursorSize != null) {
            return sMaxCursorSize;
        }
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        sMaxCursorSize = new Dimension(bounds.width / 2, bounds.height / 2);
        return sMaxCursorSize;
    }

    public CCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException, HeadlessException {
        super(name);
        this.fImage = cursor;
        this.fHotspot = hotSpot;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas c = new Canvas();
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(this.fImage, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int width = this.fImage.getWidth(c);
        int height = this.fImage.getHeight(c);
        if (tracker.isErrorAny() || width < 0 || height < 0) {
            this.fHotspot.y = 0;
            this.fHotspot.x = 0;
            height = 1;
            width = 1;
            this.fImage = CCustomCursor.createTransparentImage(width, height);
        } else {
            Dimension nativeSize = toolkit.getBestCursorSize(width, height);
            width = nativeSize.width;
            height = nativeSize.height;
        }
        this.fWidth = width;
        this.fHeight = height;
        if (this.fHotspot.x >= width || this.fHotspot.y >= height || this.fHotspot.x < 0 || this.fHotspot.y < 0) {
            throw new IndexOutOfBoundsException("invalid hotSpot");
        }
        if (this.fHotspot.x >= width) {
            this.fHotspot.x = width - 1;
        } else if (this.fHotspot.x < 0) {
            this.fHotspot.x = 0;
        }
        if (this.fHotspot.y >= height) {
            this.fHotspot.y = height - 1;
        } else if (this.fHotspot.y < 0) {
            this.fHotspot.y = 0;
        }
    }

    private static BufferedImage createTransparentImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        BufferedImage img = gc.createCompatibleImage(w, h, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, w, h);
        g.dispose();
        return img;
    }

    public static Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        Dimension maxCursorSize = CCustomCursor.getMaxCursorSize();
        Dimension d = new Dimension(Math.max(1, Math.abs(preferredWidth)), Math.max(1, Math.abs(preferredHeight)));
        return new Dimension(Math.min(d.width, maxCursorSize.width), Math.min(d.height, maxCursorSize.height));
    }

    long getImageData() {
        if (this.fCImage != null) {
            return this.fCImage.ptr;
        }
        try {
            this.fCImage = CImage.getCreator().createFromImage(this.fImage);
            if (this.fCImage == null) {
                return 0L;
            }
            this.fCImage.resizeRepresentations(this.fWidth, this.fHeight);
            return this.fCImage.ptr;
        }
        catch (IllegalArgumentException iae) {
            return 0L;
        }
    }

    Point getHotSpot() {
        return this.fHotspot;
    }
}

