/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CToolkitThreadBlockedHandler;

public class CDataTransferer
extends DataTransferer {
    private static final Map<String, Long> predefinedClipboardNameMap;
    private static final Map<Long, String> predefinedClipboardFormatMap;
    private static final String[] predefinedClipboardNames;
    public static final int CF_UNSUPPORTED = 0;
    public static final int CF_STRING = 1;
    public static final int CF_FILE = 2;
    public static final int CF_TIFF = 3;
    public static final int CF_RICH_TEXT = 4;
    public static final int CF_HTML = 5;
    public static final int CF_PDF = 6;
    public static final int CF_URL = 7;
    public static final int CF_PNG = 8;
    public static final int CF_JPEG = 9;
    public static final int CF_XPICT = 10;
    private static CDataTransferer fTransferer;
    private final ToolkitThreadBlockedHandler handler = new CToolkitThreadBlockedHandler();

    private CDataTransferer() {
    }

    static synchronized CDataTransferer getInstanceImpl() {
        if (fTransferer == null) {
            fTransferer = new CDataTransferer();
        }
        return fTransferer;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long format) {
        return format == 1L;
    }

    @Override
    public boolean isFileFormat(long format) {
        return format == 2L;
    }

    @Override
    public boolean isImageFormat(long format) {
        int ifmt = (int)format;
        switch (ifmt) {
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object translateBytes(byte[] bytes, DataFlavor flavor, long format, Transferable transferable) throws IOException {
        if (format == 7L && URL.class.equals(flavor.getRepresentationClass())) {
            String[] strings = this.dragQueryFile(bytes);
            if (strings == null || strings.length == 0) {
                return null;
            }
            return new URL(strings[0]);
        }
        if (this.isUriListFlavor(flavor)) {
            String[] strings = this.dragQueryFile(bytes);
            if (strings == null) {
                return null;
            }
            String separator = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            if (strings.length > 0) {
                for (int i = 0; i < strings.length; ++i) {
                    sb.append(strings[i]);
                    sb.append(separator);
                }
            }
            bytes = sb.toString().getBytes();
            format = 1L;
        } else if (format == 1L) {
            bytes = Normalizer.normalize(new String(bytes, "UTF8"), Normalizer.Form.NFC).getBytes("UTF8");
        }
        return super.translateBytes(bytes, flavor, format, transferable);
    }

    @Override
    protected synchronized Long getFormatForNativeAsLong(String str) {
        Long format = predefinedClipboardNameMap.get(str);
        if (format == null) {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                return -1L;
            }
            format = this.registerFormatWithPasteboard(str);
            predefinedClipboardNameMap.put(str, format);
            predefinedClipboardFormatMap.put(format, str);
        }
        return format;
    }

    private native long registerFormatWithPasteboard(String var1);

    private native String formatForIndex(long var1);

    @Override
    protected String getNativeForFormat(long format) {
        String returnValue = null;
        if (format >= 0L && format < (long)predefinedClipboardNames.length) {
            returnValue = predefinedClipboardNames[(int)format];
        } else {
            Long formatObj = format;
            returnValue = predefinedClipboardFormatMap.get(formatObj);
            if (returnValue == null && (returnValue = this.formatForIndex(format)) != null) {
                predefinedClipboardNameMap.put(returnValue, formatObj);
                predefinedClipboardFormatMap.put(formatObj, returnValue);
            }
        }
        if (returnValue == null) {
            returnValue = predefinedClipboardNames[0];
        }
        return returnValue;
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long format) {
        return CImage.getCreator().getPlatformImageBytes(image);
    }

    private static native String[] nativeDragQueryFile(byte[] var0);

    @Override
    protected String[] dragQueryFile(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (new String(bytes).startsWith("Unsupported type")) {
            return null;
        }
        return CDataTransferer.nativeDragQueryFile(bytes);
    }

    @Override
    protected Image platformImageBytesToImage(byte[] bytes, long format) throws IOException {
        return CImage.getCreator().createImageFromPlatformImageBytes(bytes);
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> fileList) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String file : fileList) {
            byte[] bytes = file.getBytes();
            bos.write(bytes, 0, bytes.length);
            bos.write(0);
        }
        return bos;
    }

    @Override
    protected boolean isURIListFormat(long format) {
        String nat = this.getNativeForFormat(format);
        if (nat == null) {
            return false;
        }
        try {
            DataFlavor df = new DataFlavor(nat);
            if (this.isUriListFlavor(df)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isUriListFlavor(DataFlavor df) {
        return df.getPrimaryType().equals("text") && df.getSubType().equals("uri-list");
    }

    static {
        predefinedClipboardNames = new String[]{"", "STRING", "FILE_NAME", "TIFF", "RICH_TEXT", "HTML", "PDF", "URL", "PNG", "JFIF", "XPICT"};
        HashMap<String, Long> nameMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        HashMap<Long, String> formatMap = new HashMap<Long, String>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            nameMap.put(predefinedClipboardNames[i], Long.valueOf(i));
            formatMap.put(Long.valueOf(i), predefinedClipboardNames[i]);
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(nameMap);
        predefinedClipboardFormatMap = Collections.synchronizedMap(formatMap);
    }
}

