/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;
import sun.security.action.GetPropertyAction;

public final class CDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final CDragSourceContextPeer fInstance = new CDragSourceContextPeer(null);
    private Image fDragImage;
    private CImage fDragCImage;
    private Point fDragImageOffset;
    private static Component hoveringComponent = null;
    private static double fMaxImageSize = 128.0;

    private CDragSourceContextPeer(DragGestureEvent dge) {
        super(dge);
    }

    public static CDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        fInstance.setTrigger(dge);
        return fInstance;
    }

    @Override
    public void startDrag(DragSourceContext dsc, Cursor cursor, Image dragImage, Point dragImageOffset) throws InvalidDnDOperationException {
        this.fDragImage = dragImage;
        this.fDragImageOffset = dragImageOffset;
        super.startDrag(dsc, cursor, dragImage, dragImageOffset);
    }

    @Override
    protected void startDrag(Transferable transferable, long[] formats, Map formatMap) {
        Point dragImageOffset;
        DragGestureEvent trigger = this.getTrigger();
        InputEvent triggerEvent = trigger.getTriggerEvent();
        Point dragOrigin = new Point(trigger.getDragOrigin());
        int extModifiers = triggerEvent.getModifiers() | triggerEvent.getModifiersEx();
        long timestamp = triggerEvent.getWhen();
        int clickCount = triggerEvent instanceof MouseEvent ? ((MouseEvent)triggerEvent).getClickCount() : 1;
        Component component = trigger.getComponent();
        Point loc = component.getLocation();
        Component rootComponent = component;
        while (!(rootComponent instanceof Window)) {
            dragOrigin.translate(loc.x, loc.y);
            rootComponent = rootComponent.getParent();
            loc = rootComponent.getLocation();
        }
        if (this.fDragImage == null) {
            this.setDefaultDragImage(component);
        }
        if (this.fDragImage != null) {
            try {
                this.fDragCImage = CImage.getCreator().createFromImageImmediately(this.fDragImage);
            }
            catch (Exception e) {
                throw new InvalidDnDOperationException("Drag image can not be created.");
            }
            if (this.fDragCImage == null) {
                throw new InvalidDnDOperationException("Drag image is not ready.");
            }
            dragImageOffset = this.fDragImageOffset;
        } else {
            this.fDragCImage = null;
            dragImageOffset = new Point(0, 0);
        }
        try {
            PlatformWindow platformWindow = ((LWComponentPeer)rootComponent.getPeer()).getPlatformWindow();
            long nativeViewPtr = CPlatformWindow.getNativeViewPtr(platformWindow);
            if (nativeViewPtr == 0L) {
                throw new InvalidDnDOperationException("Unsupported platform window implementation");
            }
            long nativeDragSource = this.createNativeDragSource(component, nativeViewPtr, transferable, triggerEvent, (int)dragOrigin.getX(), (int)dragOrigin.getY(), extModifiers, clickCount, timestamp, this.fDragCImage, dragImageOffset.x, dragImageOffset.y, this.getDragSourceContext().getSourceActions(), formats, formatMap);
            if (nativeDragSource == 0L) {
                throw new InvalidDnDOperationException("");
            }
            this.setNativeContext(nativeDragSource);
        }
        catch (Exception e) {
            throw new InvalidDnDOperationException("failed to create native peer: " + e);
        }
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
        CCursorManager.getInstance().setCursor(this.getCursor());
        try {
            Thread dragThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long nativeDragSource = CDragSourceContextPeer.this.getNativeContext();
                    try {
                        CDragSourceContextPeer.this.doDragging(nativeDragSource);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        CDragSourceContextPeer.this.releaseNativeDragSource(nativeDragSource);
                        CDragSourceContextPeer.this.fDragImage = null;
                        if (CDragSourceContextPeer.this.fDragCImage != null) {
                            CDragSourceContextPeer.this.fDragCImage.dispose();
                            CDragSourceContextPeer.this.fDragCImage = null;
                        }
                    }
                }
            };
            dragThread.start();
        }
        catch (Exception e) {
            long nativeDragSource = this.getNativeContext();
            this.setNativeContext(0L);
            this.releaseNativeDragSource(nativeDragSource);
            SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            throw new InvalidDnDOperationException("failed to start dragging thread: " + e);
        }
    }

    private void setDefaultDragImage(Component component) {
        boolean handled = false;
        if (component.isLightweight()) {
            if (component instanceof JTextComponent) {
                this.setDefaultDragImage((JTextComponent)component);
                handled = true;
            } else if (component instanceof JTree) {
                this.setDefaultDragImage((JTree)component);
                handled = true;
            } else if (component instanceof JTable) {
                this.setDefaultDragImage((JTable)component);
                handled = true;
            } else if (component instanceof JList) {
                this.setDefaultDragImage((JList)component);
                handled = true;
            }
        }
        if (!handled) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTextComponent component) {
        DragGestureEvent trigger = this.getTrigger();
        int selectionStart = component.getSelectionStart();
        int selectionEnd = component.getSelectionEnd();
        boolean handled = false;
        int index = component.viewToModel(trigger.getDragOrigin());
        if (selectionStart < selectionEnd && index >= selectionStart && index <= selectionEnd) {
            try {
                Rectangle selectionStartBounds = component.modelToView(selectionStart);
                Rectangle selectionEndBounds = component.modelToView(selectionEnd);
                Rectangle selectionBounds = null;
                if (selectionStartBounds.y == selectionEndBounds.y) {
                    selectionBounds = new Rectangle(selectionStartBounds.x, selectionStartBounds.y, selectionEndBounds.x - selectionStartBounds.x + selectionEndBounds.width, selectionEndBounds.y - selectionStartBounds.y + selectionEndBounds.height);
                } else {
                    AccessibleContext ctx = component.getAccessibleContext();
                    AccessibleText at = (AccessibleText)((Object)ctx);
                    selectionBounds = component.modelToView(selectionStart);
                    for (int i = selectionStart + 1; i <= selectionEnd; ++i) {
                        Rectangle charBounds = at.getCharacterBounds(i);
                        if (charBounds == null) continue;
                        selectionBounds.add(charBounds);
                    }
                }
                this.setOutlineDragImage(selectionBounds);
                handled = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!handled) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTree component) {
        Rectangle selectedOutline = null;
        int[] selectedRows = component.getSelectionRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Rectangle r = component.getRowBounds(selectedRows[i]);
            if (selectedOutline == null) {
                selectedOutline = r;
                continue;
            }
            selectedOutline.add(r);
        }
        if (selectedOutline != null) {
            this.setOutlineDragImage(selectedOutline);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTable component) {
        Rectangle selectedOutline = null;
        int[] selectedRows = component.getSelectedRows();
        int[] selectedColumns = component.getSelectedColumns();
        for (int row = 0; row < selectedRows.length; ++row) {
            for (int col = 0; col < selectedColumns.length; ++col) {
                Rectangle r = component.getCellRect(selectedRows[row], selectedColumns[col], true);
                if (selectedOutline == null) {
                    selectedOutline = r;
                    continue;
                }
                selectedOutline.add(r);
            }
        }
        if (selectedOutline != null) {
            this.setOutlineDragImage(selectedOutline);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JList component) {
        Rectangle selectedOutline = null;
        int[] selectedIndices = component.getSelectedIndices();
        if (selectedIndices.length > 0) {
            selectedOutline = component.getCellBounds(selectedIndices[0], selectedIndices[selectedIndices.length - 1]);
        }
        if (selectedOutline != null) {
            this.setOutlineDragImage(selectedOutline);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage() {
        DragGestureEvent trigger = this.getTrigger();
        Component comp = trigger.getComponent();
        this.setOutlineDragImage(new Rectangle(0, 0, comp.getWidth(), comp.getHeight()), true);
    }

    private void setOutlineDragImage(Rectangle outline) {
        this.setOutlineDragImage(outline, false);
    }

    private void setOutlineDragImage(Rectangle outline, Boolean shouldScale) {
        int maxArea;
        int area;
        int width = (int)outline.getWidth();
        int height = (int)outline.getHeight();
        double scale = 1.0;
        if (shouldScale.booleanValue() && (area = width * height) > (maxArea = (int)(fMaxImageSize * fMaxImageSize))) {
            scale = (double)area / (double)maxArea;
            width = (int)((double)width / scale);
            height = (int)((double)height / scale);
        }
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        DragGestureEvent trigger = this.getTrigger();
        Component comp = trigger.getComponent();
        Point compOffset = comp.getLocation();
        if (comp instanceof JComponent) {
            Rectangle visibleBounds = ((JComponent)comp).getVisibleRect();
            Rectangle clipedOutline = outline.intersection(visibleBounds);
            if (!clipedOutline.isEmpty()) {
                outline = clipedOutline;
            }
            outline.translate(compOffset.x, compOffset.y);
        }
        GraphicsConfiguration config = comp.getGraphicsConfiguration();
        BufferedImage dragImage = config.createCompatibleImage(width, height, 3);
        Color paint = Color.gray;
        BasicStroke stroke = new BasicStroke(2.0f);
        int halfLineWidth = (int)(stroke.getLineWidth() + 1.0f) / 2;
        Graphics2D g2 = (Graphics2D)dragImage.getGraphics();
        g2.setPaint(paint);
        g2.setStroke(stroke);
        g2.drawRect(halfLineWidth, halfLineWidth, width - 2 * halfLineWidth - 1, height - 2 * halfLineWidth - 1);
        g2.dispose();
        this.fDragImage = dragImage;
        Point dragOrigin = trigger.getDragOrigin();
        Point dragImageOffset = new Point(outline.x - dragOrigin.x, outline.y - dragOrigin.y);
        if (comp instanceof JComponent) {
            dragImageOffset.translate(-compOffset.x, -compOffset.y);
        }
        if (shouldScale.booleanValue()) {
            dragImageOffset.x = (int)((double)dragImageOffset.x / scale);
            dragImageOffset.y = (int)((double)dragImageOffset.y / scale);
        }
        this.fDragImageOffset = dragImageOffset;
    }

    private void dragMouseMoved(int targetActions, int modifiers, final int x, final int y) {
        try {
            Component componentAt = LWCToolkit.invokeAndWait(new Callable<Component>(){

                @Override
                public Component call() {
                    LWWindowPeer mouseEventComponent = LWWindowPeer.getWindowUnderCursor();
                    if (mouseEventComponent == null) {
                        return null;
                    }
                    Component root = SwingUtilities.getRoot(mouseEventComponent.getTarget());
                    if (root == null) {
                        return null;
                    }
                    Point rootLocation = root.getLocationOnScreen();
                    return CDragSourceContextPeer.getDropTargetAt(root, x - rootLocation.x, y - rootLocation.y);
                }
            }, this.getComponent());
            if (componentAt != hoveringComponent) {
                if (hoveringComponent != null) {
                    this.dragExit(x, y);
                }
                if (componentAt != null) {
                    this.dragEnter(targetActions, modifiers, x, y);
                }
                hoveringComponent = componentAt;
            }
            this.postDragSourceDragEvent(targetActions, modifiers, x, y, 6);
        }
        catch (Exception e) {
            throw new InvalidDnDOperationException("Failed to handle DragMouseMoved event");
        }
    }

    private static Component getDropTargetAt(Component root, int x, int y) {
        if (!(root.contains(x, y) && root.isEnabled() && root.isVisible())) {
            return null;
        }
        if (root.getDropTarget() != null && root.getDropTarget().isActive()) {
            return root;
        }
        if (root instanceof Container) {
            for (Component comp : ((Container)root).getComponents()) {
                Point loc = comp.getLocation();
                Component dropTarget = CDragSourceContextPeer.getDropTargetAt(comp, x - loc.x, y - loc.y);
                if (dropTarget == null) continue;
                return dropTarget;
            }
        }
        return null;
    }

    private void resetHovering() {
        hoveringComponent = null;
    }

    @Override
    protected void setNativeCursor(long nativeCtxt, Cursor c, int cType) {
        CCursorManager.getInstance().setCursor(c);
    }

    private native long createNativeDragSource(Component var1, long var2, Transferable var4, InputEvent var5, int var6, int var7, int var8, int var9, long var10, CImage var12, int var13, int var14, int var15, long[] var16, Map var17);

    private native void doDragging(long var1);

    private native void releaseNativeDragSource(long var1);

    static {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("apple.awt.dnd.defaultDragImageSize"));
        if (propValue != null) {
            try {
                double value = Double.parseDouble(propValue);
                if (value > 0.0) {
                    fMaxImageSize = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

