/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import javax.swing.SwingUtilities;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.awt.dnd.SunDropTargetEvent;
import sun.lwawt.macosx.LWCToolkit;

final class CDropTargetContextPeer
extends SunDropTargetContextPeer {
    private long fNativeDropTransfer = 0L;
    private long fNativeDataAvailable = 0L;
    private Object fNativeData = null;
    private DropTarget insideTarget = null;
    Object awtLockAccess = new Object();

    static CDropTargetContextPeer getDropTargetContextPeer() {
        return new CDropTargetContextPeer();
    }

    private CDropTargetContextPeer() {
    }

    private void flushEvents(Component c) {
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public synchronized void run() {
                }
            }, c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getNativeData(long format) {
        long nativeDropTarget = this.getNativeDragContext();
        Object object = this.awtLockAccess;
        synchronized (object) {
            this.fNativeDataAvailable = 0L;
            if (this.fNativeDropTransfer == 0L) {
                this.fNativeDropTransfer = this.startTransfer(nativeDropTarget, format);
            } else {
                this.addTransfer(nativeDropTarget, this.fNativeDropTransfer, format);
            }
            while (format != this.fNativeDataAvailable) {
                try {
                    this.awtLockAccess.wait();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return this.fNativeData;
    }

    @Override
    protected void processMotionMessage(SunDropTargetEvent event, boolean operationChanged) {
        boolean eventInsideTarget = this.isEventInsideTarget(event);
        if (event.getComponent().getDropTarget() == this.insideTarget) {
            if (!eventInsideTarget) {
                this.processExitMessage(event);
                return;
            }
        } else if (eventInsideTarget) {
            this.processEnterMessage(event);
        } else {
            return;
        }
        super.processMotionMessage(event, operationChanged);
    }

    @Override
    protected void processEnterMessage(SunDropTargetEvent event) {
        Component c = event.getComponent();
        DropTarget dt = event.getComponent().getDropTarget();
        if (this.isEventInsideTarget(event) && dt != this.insideTarget && c.isShowing() && dt != null && dt.isActive()) {
            this.insideTarget = dt;
            super.processEnterMessage(event);
        }
    }

    @Override
    protected void processExitMessage(SunDropTargetEvent event) {
        if (event.getComponent().getDropTarget() == this.insideTarget) {
            this.insideTarget = null;
            super.processExitMessage(event);
        }
    }

    @Override
    protected void processDropMessage(SunDropTargetEvent event) {
        if (this.isEventInsideTarget(event)) {
            super.processDropMessage(event);
            this.insideTarget = null;
        }
    }

    private boolean isEventInsideTarget(SunDropTargetEvent event) {
        Component eventSource = event.getComponent();
        Point screenPoint = event.getPoint();
        SwingUtilities.convertPointToScreen(screenPoint, eventSource);
        Point locationOnScreen = eventSource.getLocationOnScreen();
        Rectangle screenBounds = new Rectangle(locationOnScreen.x, locationOnScreen.y, eventSource.getWidth(), eventSource.getHeight());
        return screenBounds.contains(screenPoint);
    }

    @Override
    protected int postDropTargetEvent(Component component, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt, int eventID, boolean dispatchType) {
        return super.postDropTargetEvent(component, x, y, dropAction, actions2, formats, nativeCtxt, eventID, true);
    }

    @Override
    protected void doDropDone(boolean success, int dropAction, boolean isLocal) {
        long nativeDropTarget = this.getNativeDragContext();
        this.dropDone(nativeDropTarget, this.fNativeDropTransfer, isLocal, success, dropAction);
    }

    private void newData(long format, byte[] data) {
        this.fNativeDataAvailable = format;
        this.fNativeData = data;
        this.awtLockAccess.notifyAll();
    }

    private void transferFailed(long format) {
        this.fNativeDataAvailable = format;
        this.fNativeData = null;
        this.awtLockAccess.notifyAll();
    }

    private native long startTransfer(long var1, long var3);

    private native void addTransfer(long var1, long var3, long var5);

    private native void dropDone(long var1, long var3, boolean var5, boolean var6, int var7);
}

