/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AWTKeyStroke;
import java.awt.Point;
import java.awt.Toolkit;
import sun.awt.EmbeddedFrame;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CClipboard;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.LWCToolkit;

public class CEmbeddedFrame
extends EmbeddedFrame {
    private CPlatformResponder responder;
    private static final Object classLock = new Object();
    private static volatile CEmbeddedFrame globalFocusedWindow;
    private CEmbeddedFrame browserWindowFocusedApplet;
    private boolean parentWindowActive = true;

    public CEmbeddedFrame() {
        this.show();
    }

    @Override
    public void addNotify() {
        if (this.getPeer() == null) {
            LWCToolkit toolkit = (LWCToolkit)Toolkit.getDefaultToolkit();
            LWWindowPeer peer = toolkit.createEmbeddedFrame(this);
            this.setPeer(peer);
            this.responder = new CPlatformResponder(peer, true);
        }
        super.addNotify();
    }

    @Override
    public void registerAccelerator(AWTKeyStroke stroke) {
    }

    @Override
    public void unregisterAccelerator(AWTKeyStroke stroke) {
    }

    protected long getLayerPtr() {
        LWWindowPeer peer = (LWWindowPeer)this.getPeer();
        return peer.getLayerPtr();
    }

    public void handleMouseEvent(int eventType, int modifierFlags, double pluginX, double pluginY, int buttonNumber, int clickCount) {
        int x = (int)pluginX;
        int y = (int)pluginY;
        Point locationOnScreen = this.getLocationOnScreen();
        int screenX = locationOnScreen.x + x;
        int screenY = locationOnScreen.y + y;
        if (eventType == 5) {
            CCursorManager.nativeSetAllowsCursorSetInBackground(true);
        } else if (eventType == 6) {
            CCursorManager.nativeSetAllowsCursorSetInBackground(false);
        }
        this.responder.handleMouseEvent(eventType, modifierFlags, buttonNumber, clickCount, x, y, screenX, screenY);
    }

    public void handleScrollEvent(double pluginX, double pluginY, int modifierFlags, double deltaX, double deltaY, double deltaZ) {
        int x = (int)pluginX;
        int y = (int)pluginY;
        this.responder.handleScrollEvent(x, y, modifierFlags, deltaX, deltaY, 1);
    }

    public void handleKeyEvent(int eventType, int modifierFlags, String characters, String charsIgnoringMods, boolean isRepeat, short keyCode, boolean needsKeyTyped) {
        this.responder.handleKeyEvent(eventType, modifierFlags, characters, charsIgnoringMods, keyCode, needsKeyTyped, isRepeat);
    }

    public void handleInputEvent(String text) {
        this.responder.handleInputEvent(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFocusEvent(boolean focused) {
        Object object = classLock;
        synchronized (object) {
            globalFocusedWindow = focused ? this : (globalFocusedWindow == this ? null : globalFocusedWindow);
        }
        if (globalFocusedWindow == this) {
            CClipboard clipboard = (CClipboard)Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.checkPasteboardAndNotify();
        }
        if (this.parentWindowActive) {
            this.responder.handleWindowFocusEvent(focused, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWindowFocusEvent(boolean parentWindowActive) {
        this.parentWindowActive = parentWindowActive;
        Object object = classLock;
        synchronized (object) {
            if (!parentWindowActive) {
                this.browserWindowFocusedApplet = globalFocusedWindow;
            }
            if (parentWindowActive && globalFocusedWindow != this && this.isParentWindowChanged()) {
                globalFocusedWindow = this.browserWindowFocusedApplet != null ? this.browserWindowFocusedApplet : this;
            }
        }
        if (globalFocusedWindow == this) {
            this.responder.handleWindowFocusEvent(parentWindowActive, null);
        }
    }

    public boolean isParentWindowActive() {
        return this.parentWindowActive;
    }

    private boolean isParentWindowChanged() {
        return globalFocusedWindow != null ? !globalFocusedWindow.isParentWindowActive() : true;
    }

    @Override
    public void synthesizeWindowActivation(boolean doActivate) {
        if (this.isParentWindowActive() != doActivate) {
            this.handleWindowFocusEvent(doActivate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGlobalFocusedWindow(CEmbeddedFrame newGlobalFocusedWindow) {
        Object object = classLock;
        synchronized (object) {
            if (newGlobalFocusedWindow.isParentWindowActive()) {
                globalFocusedWindow = newGlobalFocusedWindow;
            }
        }
    }
}

