/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CFRetainedResource {
    private final boolean disposeOnAppKitThread;
    protected volatile long ptr;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();

    private static native void nativeCFRelease(long var0, boolean var2);

    protected CFRetainedResource(long ptr, boolean disposeOnAppKitThread) {
        this.disposeOnAppKitThread = disposeOnAppKitThread;
        this.ptr = ptr;
    }

    protected void setPtr(long ptr) {
        this.writeLock.lock();
        try {
            if (this.ptr != 0L) {
                this.dispose();
            }
            this.ptr = ptr;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void dispose() {
        long oldPtr = 0L;
        this.writeLock.lock();
        try {
            if (this.ptr == 0L) {
                return;
            }
            oldPtr = this.ptr;
            this.ptr = 0L;
        }
        finally {
            this.writeLock.unlock();
        }
        CFRetainedResource.nativeCFRelease(oldPtr, this.disposeOnAppKitThread);
    }

    public final void execute(CFNativeAction action) {
        this.readLock.lock();
        try {
            if (this.ptr != 0L) {
                action.run(this.ptr);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long executeGet(CFNativeActionGet action) {
        this.readLock.lock();
        try {
            if (this.ptr != 0L) {
                long l = action.run(this.ptr);
                return l;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return 0L;
    }

    protected final void finalize() throws Throwable {
        this.dispose();
    }

    static interface CFNativeActionGet {
        public long run(long var1);
    }

    public static interface CFNativeAction {
        public void run(long var1);
    }
}

