/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.SunWritableRaster;
import sun.lwawt.macosx.CFRetainedResource;

public class CImage
extends CFRetainedResource {
    static Creator creator = new Creator();

    private static native long nativeCreateNSImageFromArray(int[] var0, int var1, int var2);

    private static native long nativeCreateNSImageFromBytes(byte[] var0);

    private static native long nativeCreateNSImageFromArrays(int[][] var0, int[] var1, int[] var2);

    private static native long nativeCreateNSImageFromFileContents(String var0);

    private static native long nativeCreateNSImageOfFileFromLaunchServices(String var0);

    private static native long nativeCreateNSImageFromImageName(String var0);

    private static native long nativeCreateNSImageFromIconSelector(int var0);

    private static native byte[] nativeGetPlatformImageBytes(int[] var0, int var1, int var2);

    private static native void nativeCopyNSImageIntoArray(long var0, int[] var2, int var3, int var4, int var5, int var6);

    private static native Dimension2D nativeGetNSImageSize(long var0);

    private static native void nativeSetNSImageSize(long var0, double var2, double var4);

    private static native void nativeResizeNSImageRepresentations(long var0, double var2, double var4);

    private static native Dimension2D[] nativeGetNSImageRepresentationSizes(long var0, double var2, double var4);

    public static Creator getCreator() {
        return creator;
    }

    CImage(long nsImagePtr) {
        super(nsImagePtr, true);
    }

    private Image toImage() {
        if (this.ptr == 0L) {
            return null;
        }
        AtomicReference sizeRef = new AtomicReference();
        this.execute(ptr -> sizeRef.set(CImage.nativeGetNSImageSize(ptr)));
        Dimension2D size = (Dimension2D)sizeRef.get();
        if (size == null) {
            return null;
        }
        int w = (int)size.getWidth();
        int h = (int)size.getHeight();
        AtomicReference repRef = new AtomicReference();
        this.execute(ptr -> repRef.set(CImage.nativeGetNSImageRepresentationSizes(ptr, size.getWidth(), size.getHeight())));
        Dimension2D[] sizes = (Dimension2D[])repRef.get();
        return sizes == null || sizes.length < 2 ? new MultiResolutionCachedImage(w, h, (width, height) -> this.toImage(w, h, (int)width, (int)height)) : new MultiResolutionCachedImage(w, h, sizes, (width, height) -> this.toImage(w, h, (int)width, (int)height));
    }

    private BufferedImage toImage(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        BufferedImage bimg = new BufferedImage(dstWidth, dstHeight, 3);
        DataBufferInt dbi = (DataBufferInt)bimg.getRaster().getDataBuffer();
        int[] buffer = SunWritableRaster.stealData(dbi, 0);
        this.execute(ptr -> CImage.nativeCopyNSImageIntoArray(ptr, buffer, srcWidth, srcHeight, dstWidth, dstHeight));
        SunWritableRaster.markDirty(dbi);
        return bimg;
    }

    CImage resize(double w, double h) {
        this.execute(ptr -> CImage.nativeSetNSImageSize(ptr, w, h));
        return this;
    }

    void resizeRepresentations(double w, double h) {
        this.execute(ptr -> CImage.nativeResizeNSImageRepresentations(ptr, w, h));
    }

    public static class Creator {
        Creator() {
        }

        public Image createImageUsingNativeSize(long image) {
            if (image == 0L) {
                return null;
            }
            Dimension2D size = CImage.nativeGetNSImageSize(image);
            return this.createImage(image, size.getWidth(), size.getHeight());
        }

        Image createImage(long image, double width, double height) {
            if (image == 0L) {
                throw new Error("Unable to instantiate CImage with null native image reference.");
            }
            return this.createImageWithSize(image, width, height);
        }

        public Image createImageWithSize(long image, double width, double height) {
            CImage img = new CImage(image);
            img.resize(width, height);
            return img.toImage();
        }

        public Image createImageOfFile(String file, int width, int height) {
            return this.createImage(CImage.nativeCreateNSImageOfFileFromLaunchServices(file), width, height);
        }

        public Image createImageFromFile(String file, double width, double height) {
            long image = CImage.nativeCreateNSImageFromFileContents(file);
            CImage.nativeSetNSImageSize(image, width, height);
            return this.createImage(image, width, height);
        }

        public Image createSystemImageFromSelector(String iconSelector, int width, int height) {
            return this.createImage(CImage.nativeCreateNSImageFromIconSelector(Creator.getSelectorAsInt(iconSelector)), width, height);
        }

        public Image createImageFromName(String name, int width, int height) {
            return this.createImage(CImage.nativeCreateNSImageFromImageName(name), width, height);
        }

        public Image createImageFromName(String name) {
            return this.createImageUsingNativeSize(CImage.nativeCreateNSImageFromImageName(name));
        }

        private static int[] imageToArray(Image image, boolean prepareImage) {
            if (image == null) {
                return null;
            }
            if (prepareImage && !(image instanceof BufferedImage)) {
                MediaTracker mt = new MediaTracker(new Label());
                boolean id = false;
                mt.addImage(image, 0);
                try {
                    mt.waitForID(0);
                }
                catch (InterruptedException e) {
                    return null;
                }
                if (mt.isErrorID(0)) {
                    return null;
                }
            }
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w < 0 || h < 0) {
                return null;
            }
            BufferedImage bimg = new BufferedImage(w, h, 3);
            Graphics2D g2 = bimg.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.drawImage(image, 0, 0, null);
            g2.dispose();
            return ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
        }

        public byte[] getPlatformImageBytes(Image image) {
            int[] buffer = Creator.imageToArray(image, false);
            if (buffer == null) {
                return null;
            }
            return CImage.nativeGetPlatformImageBytes(buffer, image.getWidth(null), image.getHeight(null));
        }

        public Image createImageFromPlatformImageBytes(byte[] buffer) {
            return this.createImageUsingNativeSize(CImage.nativeCreateNSImageFromBytes(buffer));
        }

        public CImage createFromImage(Image image) {
            return this.createFromImage(image, true);
        }

        public CImage createFromImageImmediately(Image image) {
            return this.createFromImage(image, false);
        }

        private CImage createFromImage(Image image, boolean prepareImage) {
            if (image instanceof MultiResolutionImage) {
                List<Image> resolutionVariants = ((MultiResolutionImage)((Object)image)).getResolutionVariants();
                return this.createFromImages(resolutionVariants, prepareImage);
            }
            int[] buffer = Creator.imageToArray(image, prepareImage);
            if (buffer == null) {
                return null;
            }
            return new CImage(CImage.nativeCreateNSImageFromArray(buffer, image.getWidth(null), image.getHeight(null)));
        }

        public CImage createFromImages(List<Image> images) {
            return this.createFromImages(images, true);
        }

        private CImage createFromImages(List<Image> images, boolean prepareImage) {
            if (images == null || images.isEmpty()) {
                return null;
            }
            int num = images.size();
            int[][] buffers = new int[num][];
            int[] w = new int[num];
            int[] h = new int[num];
            num = 0;
            for (Image img : images) {
                buffers[num] = Creator.imageToArray(img, prepareImage);
                if (buffers[num] == null) continue;
                w[num] = img.getWidth(null);
                h[num] = img.getHeight(null);
                ++num;
            }
            if (num == 0) {
                return null;
            }
            return new CImage(CImage.nativeCreateNSImageFromArrays((int[][])Arrays.copyOf(buffers, num), Arrays.copyOf(w, num), Arrays.copyOf(h, num)));
        }

        static int getSelectorAsInt(String fromString) {
            byte[] b = fromString.getBytes();
            int len = Math.min(b.length, 4);
            int result = 0;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    result <<= 8;
                }
                result |= b[i] & 0xFF;
            }
            return result;
        }
    }
}

