/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.JTextComponent;
import sun.awt.im.InputMethodAdapter;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.macosx.CInputMethodDescriptor;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;

public class CInputMethod
extends InputMethodAdapter {
    private InputMethodContext fIMContext;
    private Component fAwtFocussedComponent;
    private LWComponentPeer fAwtFocussedComponentPeer;
    private boolean isActive;
    private static Map<TextAttribute, Integer>[] sHighlightStyles;
    private AttributedString fCurrentText = null;
    private String fCurrentTextAsString = null;
    private int fCurrentTextLength = 0;
    private static final int kCaretPosition = 0;
    private static final int kRawText = 1;
    private static final int kSelectedRawText = 2;
    private static final int kConvertedText = 3;
    private static final int kSelectedConvertedText = 4;

    @Override
    public void setInputMethodContext(InputMethodContext context) {
        this.fIMContext = context;
    }

    @Override
    public boolean setLocale(Locale lang) {
        return this.setLocale(lang, false);
    }

    private boolean setLocale(Locale lang, boolean onActivate) {
        Object[] available = CInputMethodDescriptor.getAvailableLocalesInternal();
        for (int i = 0; i < available.length; ++i) {
            Locale locale = (Locale)available[i];
            if (!lang.equals(locale) && (!locale.equals(Locale.JAPAN) || !lang.equals(Locale.JAPANESE)) && (!locale.equals(Locale.KOREA) || !lang.equals(Locale.KOREAN))) continue;
            if (this.isActive) {
                CInputMethod.setNativeLocale(locale.toString(), onActivate);
            }
            return true;
        }
        return false;
    }

    @Override
    public Locale getLocale() {
        Locale returnValue = CInputMethod.getNativeLocale();
        if (returnValue == null) {
            returnValue = Locale.getDefault();
        }
        return returnValue;
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    @Override
    public void setCompositionEnabled(boolean enable) {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    @Override
    public boolean isCompositionEnabled() {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
    }

    @Override
    public void activate() {
        this.isActive = true;
    }

    @Override
    public void deactivate(boolean isTemporary) {
        this.isActive = false;
    }

    @Override
    public void hideWindows() {
    }

    long getNativeViewPtr(LWComponentPeer peer) {
        if (peer.getPlatformWindow() instanceof CPlatformWindow) {
            CPlatformWindow platformWindow = (CPlatformWindow)peer.getPlatformWindow();
            CPlatformView platformView = platformWindow.getContentView();
            return platformView.getAWTView();
        }
        return 0L;
    }

    @Override
    public void removeNotify() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.getNativeViewPtr(this.fAwtFocussedComponentPeer));
        }
        this.fAwtFocussedComponentPeer = null;
    }

    @Override
    protected void setAWTFocussedComponent(Component component) {
        LWComponentPeer peer = null;
        long modelPtr = 0L;
        CInputMethod imInstance = this;
        if (component == null) {
            peer = this.fAwtFocussedComponentPeer;
            imInstance = null;
        } else {
            peer = this.getNearestNativePeer(component);
            if (component.getInputMethodRequests() == null) {
                imInstance = null;
            }
        }
        if (peer != null) {
            modelPtr = this.getNativeViewPtr(peer);
            this.nativeNotifyPeer(modelPtr, imInstance);
        }
        this.fAwtFocussedComponent = component;
        this.fAwtFocussedComponentPeer = this.getNearestNativePeer(component);
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        int index;
        int state = highlight.getState();
        if (state == 0) {
            index = 0;
        } else if (state == 1) {
            index = 2;
        } else {
            return null;
        }
        if (highlight.isSelected()) {
            ++index;
        }
        return sHighlightStyles[index];
    }

    @Override
    public void endComposition() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.getNativeViewPtr(this.fAwtFocussedComponentPeer));
        }
    }

    @Override
    public void dispose() {
        this.fIMContext = null;
        this.fAwtFocussedComponent = null;
        this.fAwtFocussedComponentPeer = null;
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    private LWComponentPeer getNearestNativePeer(Component comp) {
        if (comp == null) {
            return null;
        }
        ComponentPeer peer = comp.getPeer();
        if (peer == null) {
            return null;
        }
        while (peer instanceof LightweightPeer) {
            if ((comp = comp.getParent()) == null) {
                return null;
            }
            peer = comp.getPeer();
            if (peer != null) continue;
            return null;
        }
        if (peer instanceof LWComponentPeer) {
            return (LWComponentPeer)peer;
        }
        return null;
    }

    private synchronized void insertText(String aString) {
        AttributedString attribString = new AttributedString(aString);
        attribString.addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, this.getLocale(), 0, aString.length());
        TextHitInfo theCaret = TextHitInfo.afterOffset(aString.length() - 1);
        InputMethodEvent event = new InputMethodEvent(this.fAwtFocussedComponent, 1100, attribString.getIterator(), aString.length(), theCaret, theCaret);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), event);
        this.fCurrentText = null;
        this.fCurrentTextAsString = null;
        this.fCurrentTextLength = 0;
    }

    private void startIMUpdate(String rawText) {
        this.fCurrentTextAsString = new String(rawText);
        this.fCurrentText = new AttributedString(this.fCurrentTextAsString);
        this.fCurrentTextLength = rawText.length();
    }

    private void addAttribute(boolean isThickUnderline, boolean isGray, int start, int length) {
        InputMethodHighlight theHighlight;
        int begin = start;
        int end = start + length;
        int markupType = 1;
        if (isThickUnderline && isGray) {
            markupType = 1;
        } else if (!isThickUnderline && isGray) {
            markupType = 1;
        } else if (isThickUnderline && !isGray) {
            markupType = 4;
        } else if (!isThickUnderline && !isGray) {
            markupType = 3;
        }
        switch (markupType) {
            case 2: {
                theHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 3: {
                theHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                theHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                theHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        this.fCurrentText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, theHighlight, begin, end);
    }

    private void selectPreviousGlyph() {
        if (this.fIMContext == null) {
            return;
        }
        try {
            LWCToolkit.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int offset = CInputMethod.this.fIMContext.getInsertPositionOffset();
                    if (offset < 1) {
                        return;
                    }
                    if (CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent) {
                        ((JTextComponent)CInputMethod.this.fAwtFocussedComponent).select(offset - 1, offset);
                        return;
                    }
                    if (CInputMethod.this.fAwtFocussedComponent instanceof TextComponent) {
                        ((TextComponent)CInputMethod.this.fAwtFocussedComponent).select(offset - 1, offset);
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectNextGlyph() {
        if (this.fIMContext == null || !(this.fAwtFocussedComponent instanceof JTextComponent)) {
            return;
        }
        try {
            LWCToolkit.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int offset = CInputMethod.this.fIMContext.getInsertPositionOffset();
                    if (offset < 0) {
                        return;
                    }
                    ((JTextComponent)CInputMethod.this.fAwtFocussedComponent).select(offset, offset + 1);
                }
            }, this.fAwtFocussedComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dispatchText(int selectStart, int selectLength, boolean pressAndHold) {
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo theCaret = selectLength == 0 ? TextHitInfo.beforeOffset(selectStart) : null;
        TextHitInfo visiblePosition = TextHitInfo.beforeOffset(0);
        InputMethodEvent event = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), 0, theCaret, visiblePosition);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), event);
        if (pressAndHold) {
            this.selectNextGlyph();
        }
    }

    private synchronized void unmarkText() {
        TextHitInfo theCaret;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo visiblePosition = theCaret = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent event = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), this.fCurrentTextLength, theCaret, visiblePosition);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), event);
        this.fCurrentText = null;
        this.fCurrentTextAsString = null;
        this.fCurrentTextLength = 0;
    }

    private synchronized boolean hasMarkedText() {
        return this.fCurrentText != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String attributedSubstringFromRange(final int locationIn, final int lengthIn) {
        final String[] retString = new String[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String[] stringArray = retString;
                    synchronized (retString) {
                        int insertSpot;
                        int location = locationIn;
                        int length = lengthIn;
                        if (location + length > CInputMethod.this.fIMContext.getCommittedTextLength() + CInputMethod.this.fCurrentTextLength) {
                            length = CInputMethod.this.fIMContext.getCommittedTextLength() - location;
                        }
                        AttributedCharacterIterator theIterator = null;
                        theIterator = CInputMethod.this.fCurrentText == null ? CInputMethod.this.fIMContext.getCommittedText(location, location + length, null) : (location < (insertSpot = CInputMethod.this.fIMContext.getInsertPositionOffset()) ? CInputMethod.this.fIMContext.getCommittedText(location, location + length, null) : (location >= insertSpot && location < insertSpot + CInputMethod.this.fCurrentTextLength ? CInputMethod.this.fCurrentText.getIterator(null, location - insertSpot, location - insertSpot + length) : CInputMethod.this.fIMContext.getCommittedText(location - CInputMethod.this.fCurrentTextLength, location - CInputMethod.this.fCurrentTextLength + length, null)));
                        char[] selectedText = new char[theIterator.getEndIndex() - theIterator.getBeginIndex()];
                        char current = theIterator.first();
                        int index = 0;
                        while (current != '\uffff') {
                            selectedText[index++] = current;
                            current = theIterator.next();
                        }
                        retString[0] = new String(selectedText);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        String[] stringArray = retString;
        synchronized (retString) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return retString[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] selectedRange() {
        final int[] returnValue = new int[2];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray = returnValue;
                    synchronized (returnValue) {
                        int startLocation;
                        AttributedCharacterIterator theIterator = CInputMethod.this.fIMContext.getSelectedText(null);
                        if (theIterator == null) {
                            returnValue[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                            returnValue[1] = 0;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        if (CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent) {
                            JTextComponent theComponent = (JTextComponent)CInputMethod.this.fAwtFocussedComponent;
                            startLocation = theComponent.getSelectionStart();
                        } else if (CInputMethod.this.fAwtFocussedComponent instanceof TextComponent) {
                            TextComponent theComponent = (TextComponent)CInputMethod.this.fAwtFocussedComponent;
                            startLocation = theComponent.getSelectionStart();
                        } else {
                            startLocation = CInputMethod.this.fIMContext.getInsertPositionOffset() - (theIterator.getEndIndex() - theIterator.getBeginIndex());
                            if (startLocation < 0) {
                                startLocation = CInputMethod.this.fIMContext.getInsertPositionOffset() + (theIterator.getEndIndex() - theIterator.getBeginIndex());
                            }
                        }
                        returnValue[0] = startLocation;
                        returnValue[1] = theIterator.getEndIndex() - theIterator.getBeginIndex();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        int[] nArray = returnValue;
        synchronized (returnValue) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] markedRange() {
        if (this.fCurrentText == null) {
            return null;
        }
        final int[] returnValue = new int[2];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray = returnValue;
                    synchronized (returnValue) {
                        returnValue[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        returnValue[1] = this.fCurrentTextLength;
        int[] nArray = returnValue;
        synchronized (returnValue) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] firstRectForCharacterRange(final int absoluteTextOffset) {
        final int[] rect = new int[4];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray = rect;
                    synchronized (rect) {
                        Rectangle r2;
                        int insertOffset = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        int composedTextOffset = absoluteTextOffset - insertOffset;
                        if (composedTextOffset < 0) {
                            composedTextOffset = 0;
                        }
                        Rectangle r = CInputMethod.this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(composedTextOffset));
                        rect[0] = r.x;
                        rect[1] = r.y;
                        rect[2] = r.width;
                        rect[3] = r.height;
                        if (composedTextOffset > 0 && CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent && r.equals(r2 = CInputMethod.this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(0)))) {
                            String inProgressSubstring = CInputMethod.this.fCurrentTextAsString.substring(0, composedTextOffset);
                            Graphics g = CInputMethod.this.fAwtFocussedComponent.getGraphics();
                            int xOffset = g.getFontMetrics().stringWidth(inProgressSubstring);
                            rect[0] = rect[0] + xOffset;
                            g.dispose();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        int[] nArray = rect;
        synchronized (rect) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return rect;
        }
    }

    private synchronized int characterIndexForPoint(final int screenX, final int screenY) {
        final TextHitInfo[] offsetInfo = new TextHitInfo[1];
        final int[] insertPositionOffset = new int[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TextHitInfo[] textHitInfoArray = offsetInfo;
                    synchronized (offsetInfo) {
                        offsetInfo[0] = CInputMethod.this.fIMContext.getLocationOffset(screenX, screenY);
                        insertPositionOffset[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        if (offsetInfo[0] == null) {
            return insertPositionOffset[0];
        }
        int returnValue = offsetInfo[0].getCharIndex() + insertPositionOffset[0];
        if (offsetInfo[0].getCharIndex() == this.fCurrentTextLength) {
            --returnValue;
        }
        return returnValue;
    }

    @Override
    public void disableInputMethod() {
    }

    @Override
    public String getNativeInputMethodInfo() {
        return CInputMethod.nativeGetCurrentInputMethodInfo();
    }

    private native void nativeNotifyPeer(long var1, CInputMethod var3);

    private native void nativeEndComposition(long var1);

    private native void nativeHandleEvent(LWComponentPeer var1, AWTEvent var2);

    static native Locale getNativeLocale();

    static native boolean setNativeLocale(String var0, boolean var1);

    static native String nativeGetCurrentInputMethodInfo();

    static native void nativeInit();

    static {
        Map[] styles = new Map[4];
        HashMap<TextAttribute, Integer> map = new HashMap<TextAttribute, Integer>(1);
        map.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        styles[0] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        styles[1] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        styles[2] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
        styles[3] = Collections.unmodifiableMap(map);
        sHighlightStyles = styles;
        CInputMethod.nativeInit();
    }
}

