/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.List;
import java.util.Locale;
import sun.lwawt.macosx.CInputMethod;

public class CInputMethodDescriptor
implements InputMethodDescriptor {
    @Override
    public Locale[] getAvailableLocales() {
        Object[] locales = CInputMethodDescriptor.getAvailableLocalesInternal();
        Locale[] tmp = new Locale[locales.length];
        System.arraycopy(locales, 0, tmp, 0, locales.length);
        return tmp;
    }

    static Object[] getAvailableLocalesInternal() {
        List<Object> workList = CInputMethodDescriptor.nativeGetAvailableLocales();
        Locale currentLocale = CInputMethod.getNativeLocale();
        if (workList == null || workList.isEmpty()) {
            return new Object[]{currentLocale != null ? currentLocale : Locale.getDefault()};
        }
        if (currentLocale != null && !workList.contains(currentLocale)) {
            workList.add(currentLocale);
        }
        return workList.toArray();
    }

    @Override
    public boolean hasDynamicLocaleList() {
        return false;
    }

    @Override
    public synchronized String getInputMethodDisplayName(Locale inputLocale, Locale displayLanguage) {
        String name = "System Input Methods";
        if (Locale.getDefault().equals(displayLanguage)) {
            name = Toolkit.getProperty("AWT.HostInputMethodDisplayName", name);
        }
        return name;
    }

    @Override
    public Image getInputMethodIcon(Locale inputLocale) {
        return null;
    }

    @Override
    public InputMethod createInputMethod() throws Exception {
        return new CInputMethod();
    }

    public String toString() {
        Locale[] loc = this.getAvailableLocales();
        String locnames = null;
        for (int i = 0; i < loc.length; ++i) {
            locnames = locnames == null ? loc[i].toString() : locnames + "," + loc[i];
        }
        return this.getClass().getName() + "[locales=" + locnames + ",localelist=" + (this.hasDynamicLocaleList() ? "dynamic" : "static") + "]";
    }

    private static native void nativeInit();

    private static native List<Object> nativeGetAvailableLocales();

    static {
        CInputMethodDescriptor.nativeInit();
    }
}

