/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.LWCToolkit;

public class CMenu
extends CMenuItem
implements MenuPeer {
    public CMenu(Menu target) {
        super(target);
    }

    @Override
    protected final void initialize(MenuItem target) {
        this.setLabel(target.getLabel());
        this.setEnabled(target.isEnabled());
    }

    @Override
    public final void setEnabled(boolean b) {
        super.setEnabled(b);
        Menu target = (Menu)this.getTarget();
        int count = target.getItemCount();
        for (int i = 0; i < count; ++i) {
            MenuItem item = target.getItem(i);
            MenuItemPeer p = (MenuItemPeer)LWCToolkit.targetToPeer(item);
            if (p == null) continue;
            p.setEnabled(b && item.isEnabled());
        }
    }

    @Override
    long createModel() {
        CMenuComponent parent = (CMenuComponent)LWCToolkit.targetToPeer(this.getTarget().getParent());
        if (parent instanceof CMenu) {
            return parent.executeGet(this::nativeCreateSubMenu);
        }
        if (parent instanceof CMenuBar) {
            MenuBar parentContainer = (MenuBar)this.getTarget().getParent();
            boolean isHelpMenu = parentContainer.getHelpMenu() == this.getTarget();
            int insertionLocation = ((CMenuBar)parent).getNextInsertionIndex();
            return parent.executeGet(ptr -> this.nativeCreateMenu(ptr, isHelpMenu, insertionLocation));
        }
        throw new InternalError("Parent must be CMenu or CMenuBar");
    }

    @Override
    public final void addItem(MenuItem item) {
    }

    @Override
    public final void delItem(int index) {
        this.execute(ptr -> this.nativeDeleteItem(ptr, index));
    }

    @Override
    public final void setLabel(String label) {
        this.execute(ptr -> this.nativeSetMenuTitle(ptr, label));
        super.setLabel(label);
    }

    @Override
    public final void addSeparator() {
        this.execute(this::nativeAddSeparator);
    }

    public final long getNativeMenu() {
        return this.executeGet(this::nativeGetNSMenu);
    }

    private native long nativeCreateMenu(long var1, boolean var3, int var4);

    private native long nativeCreateSubMenu(long var1);

    private native void nativeSetMenuTitle(long var1, String var3);

    private native void nativeAddSeparator(long var1);

    private native void nativeDeleteItem(long var1, int var3);

    private native long nativeGetNSMenu(long var1);
}

