/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Image;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.SunToolkit;
import sun.lwawt.LWToolkit;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CThreading;

public class CMenuItem
extends CMenuComponent
implements MenuItemPeer {
    private final AtomicBoolean enabled = new AtomicBoolean(true);

    public CMenuItem(MenuItem target) {
        super(target);
        this.initialize(target);
    }

    protected void initialize(MenuItem target) {
        if (!this.isSeparator()) {
            this.setLabel(target.getLabel());
            this.setEnabled(target.isEnabled());
        }
    }

    private boolean isSeparator() {
        String label = ((MenuItem)this.getTarget()).getLabel();
        return label != null && label.equals("-");
    }

    @Override
    long createModel() {
        CMenuComponent parent = (CMenuComponent)LWToolkit.targetToPeer(this.getTarget().getParent());
        return parent.executeGet(ptr -> this.nativeCreate(ptr, this.isSeparator()));
    }

    public void setLabel(String label, char keyChar, int keyCode, int modifiers) {
        MenuShortcut shortcut;
        int keyMask = modifiers;
        if (keyCode == 0 && (shortcut = ((MenuItem)this.getTarget()).getShortcut()) != null) {
            keyCode = shortcut.getKey();
            keyMask |= 4;
            if (shortcut.usesShiftModifier()) {
                keyMask |= 1;
            }
        }
        if (label == null) {
            label = "";
        }
        if (keyChar == '\uffff') {
            keyChar = '\u0000';
        }
        String finalLabel = label;
        char finalKeyChar = keyChar;
        int finalKeyCode = keyCode;
        int finalKeyMask = keyMask;
        this.execute(ptr -> this.nativeSetLabel(ptr, finalLabel, finalKeyChar, finalKeyCode, finalKeyMask));
    }

    @Override
    public void setLabel(String label) {
        this.setLabel(label, '\u0000', 0, 0);
    }

    public final void setImage(Image img) {
        CImage cimg = CImage.getCreator().createFromImage(img);
        this.execute(ptr -> {
            if (cimg == null) {
                this.nativeSetImage(ptr, 0L);
            } else {
                cimg.execute(imgPtr -> this.nativeSetImage(ptr, imgPtr));
            }
        });
    }

    public final void setToolTipText(String text) {
        this.execute(ptr -> this.nativeSetTooltip(ptr, text));
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public final boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean b) {
        Object parent = LWToolkit.targetToPeer(this.getTarget().getParent());
        if (parent instanceof CMenuItem) {
            b &= ((CMenuItem)parent).isEnabled();
        }
        if (this.enabled.compareAndSet(!b, b)) {
            boolean finalB = b;
            this.execute(ptr -> this.nativeSetEnabled(ptr, finalB));
        }
    }

    private native long nativeCreate(long var1, boolean var3);

    private native void nativeSetLabel(long var1, String var3, char var4, int var5, int var6);

    private native void nativeSetImage(long var1, long var3);

    private native void nativeSetTooltip(long var1, String var3);

    private native void nativeSetEnabled(long var1, boolean var3);

    void handleAction(final long when, final int modifiers) {
        assert (CThreading.assertAppKit());
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable(){

            @Override
            public void run() {
                String cmd = ((MenuItem)CMenuItem.this.getTarget()).getActionCommand();
                ActionEvent event = new ActionEvent(CMenuItem.this.getTarget(), 1001, cmd, when, modifiers);
                SunToolkit.postEvent(SunToolkit.targetToAppContext(CMenuItem.this.getTarget()), event);
            }
        });
    }
}

