/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

class CMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final int fMotionThreshold = CMouseDragGestureRecognizer.getMotionThreshold();
    private static final int kDefaultMotionThreshold = 3;
    protected static final int ButtonMask = 7168;

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception e) {
            return 3;
        }
    }

    protected CMouseDragGestureRecognizer(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
    }

    protected CMouseDragGestureRecognizer(DragSource ds, Component c, int act) {
        this(ds, c, act, null);
    }

    protected CMouseDragGestureRecognizer(DragSource ds, Component c) {
        this(ds, c, 0);
    }

    protected CMouseDragGestureRecognizer(DragSource ds) {
        this(ds, null);
    }

    protected int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        int btns = mods & 0x1C00;
        return SunDragSourceContextPeer.convertModifiersToDropAction(mods, this.getSourceActions());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(e) != 0) {
            this.appendEvent(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.events.clear();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.events.clear();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int dragAction;
        if (!this.events.isEmpty() && (dragAction = this.mapDragOperationFromModifiers(e)) == 0) {
            this.events.clear();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.events.isEmpty()) {
            int dop = this.mapDragOperationFromModifiers(e);
            if (dop == 0) {
                return;
            }
            MouseEvent trigger = (MouseEvent)this.events.get(0);
            Point origin = trigger.getPoint();
            Point current = e.getPoint();
            int dx = Math.abs(origin.x - current.x);
            int dy = Math.abs(origin.y - current.y);
            if (dx >= fMotionThreshold || dy >= fMotionThreshold) {
                this.fireDragGestureRecognized(dop, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

