/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Window;
import sun.awt.CausedFocusEvent;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.util.logging.PlatformLogger;

public class CPlatformEmbeddedFrame
implements PlatformWindow {
    private static final PlatformLogger focusLogger = PlatformLogger.getLogger("sun.lwawt.macosx.focus.CPlatformEmbeddedFrame");
    private CGLLayer windowLayer;
    private LWWindowPeer peer;
    private CEmbeddedFrame target;
    private volatile int screenX = 0;
    private volatile int screenY = 0;

    @Override
    public void initialize(Window target, LWWindowPeer peer, PlatformWindow owner) {
        this.peer = peer;
        this.windowLayer = new CGLLayer(peer);
        this.target = (CEmbeddedFrame)target;
    }

    @Override
    public LWWindowPeer getPeer() {
        return this.peer;
    }

    @Override
    public long getLayerPtr() {
        return this.windowLayer.getPointer();
    }

    @Override
    public void dispose() {
        this.windowLayer.dispose();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.screenX = x;
        this.screenY = y;
        this.peer.notifyReshape(x, y, w, h);
    }

    @Override
    public GraphicsDevice getGraphicsDevice() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getDefaultScreenDevice();
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.screenX, this.screenY);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public SurfaceData getScreenSurface() {
        return this.windowLayer.getSurfaceData();
    }

    @Override
    public SurfaceData replaceSurfaceData() {
        return this.windowLayer.replaceSurfaceData();
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void toFront() {
    }

    @Override
    public void toBack() {
    }

    @Override
    public void setMenuBar(MenuBar mb) {
    }

    @Override
    public void setAlwaysOnTop(boolean value) {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public boolean rejectFocusRequest(CausedFocusEvent.Cause cause) {
        if (cause != CausedFocusEvent.Cause.MOUSE_EVENT && !this.target.isParentWindowActive()) {
            focusLogger.fine("the embedder is inactive, so the request is rejected");
            return true;
        }
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        CEmbeddedFrame.updateGlobalFocusedWindow(this.target);
        this.target.synthesizeWindowActivation(true);
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void setSizeConstraints(int minW, int minH, int maxW, int maxH) {
    }

    @Override
    public Graphics transformGraphics(Graphics g) {
        return g;
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    public void enterFullScreenMode() {
    }

    @Override
    public void exitFullScreenMode() {
    }

    @Override
    public boolean isFullScreenMode() {
        return false;
    }

    @Override
    public void setWindowState(int windowState) {
    }

    @Override
    public void setModalBlocked(boolean blocked) {
    }

    @Override
    public boolean isUnderMouse() {
        throw new RuntimeException("Not implemented");
    }
}

