/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Toolkit;
import java.util.Locale;
import sun.awt.SunToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;

final class CPlatformResponder {
    private final PlatformEventNotifier eventNotifier;
    private final boolean isNpapiCallback;
    private int lastKeyPressCode = 0;
    private final DeltaAccumulator deltaAccumulatorX = new DeltaAccumulator();
    private final DeltaAccumulator deltaAccumulatorY = new DeltaAccumulator();

    CPlatformResponder(PlatformEventNotifier eventNotifier, boolean isNpapiCallback) {
        this.eventNotifier = eventNotifier;
        this.isNpapiCallback = isNpapiCallback;
    }

    void handleMouseEvent(int eventType, int modifierFlags, int buttonNumber, int clickCount, int x, int y, int absoluteX, int absoluteY) {
        SunToolkit tk = (SunToolkit)Toolkit.getDefaultToolkit();
        if (buttonNumber > 2 && !tk.areExtraMouseButtonsEnabled() || buttonNumber > tk.getNumberOfButtons() - 1) {
            return;
        }
        int jeventType = this.isNpapiCallback ? NSEvent.npToJavaEventType(eventType) : NSEvent.nsToJavaEventType(eventType);
        int jbuttonNumber = 0;
        int jclickCount = 0;
        if (jeventType != 503 && jeventType != 504 && jeventType != 505) {
            jbuttonNumber = NSEvent.nsToJavaButton(buttonNumber);
            jclickCount = clickCount;
        }
        int jmodifiers = NSEvent.nsToJavaMouseModifiers(buttonNumber, modifierFlags);
        boolean jpopupTrigger = NSEvent.isPopupTrigger(jmodifiers);
        this.eventNotifier.notifyMouseEvent(jeventType, System.currentTimeMillis(), jbuttonNumber, x, y, absoluteX, absoluteY, jmodifiers, jclickCount, jpopupTrigger, null);
    }

    void handleScrollEvent(int x, int y, int modifierFlags, double deltaX, double deltaY, int scrollPhase) {
        int roundDelta;
        int buttonNumber = 2;
        int jmodifiers = NSEvent.nsToJavaMouseModifiers(2, modifierFlags);
        boolean isShift = (jmodifiers & 0x40) != 0;
        int roundDeltaX = this.deltaAccumulatorX.getRoundedDelta(deltaX, scrollPhase);
        int roundDeltaY = this.deltaAccumulatorY.getRoundedDelta(deltaY, scrollPhase);
        if (!(isShift || deltaY == 0.0 && roundDeltaY == 0)) {
            this.dispatchScrollEvent(x, y, jmodifiers, roundDeltaY, deltaY);
        }
        double delta = isShift && deltaY != 0.0 ? deltaY : deltaX;
        int n = roundDelta = isShift && roundDeltaY != 0 ? roundDeltaY : roundDeltaX;
        if (delta != 0.0 || roundDelta != 0) {
            this.dispatchScrollEvent(x, y, jmodifiers |= 0x40, roundDelta, delta);
        }
    }

    private void dispatchScrollEvent(int x, int y, int modifiers, int roundDelta, double delta) {
        long when = System.currentTimeMillis();
        boolean scrollType = false;
        boolean scrollAmount = true;
        this.eventNotifier.notifyMouseWheelEvent(when, x, y, modifiers, 0, 1, -roundDelta, -delta, null);
    }

    void handleKeyEvent(int eventType, int modifierFlags, String chars, String charsIgnoringModifiers, short keyCode, boolean needsKeyTyped, boolean needsKeyReleased) {
        boolean isDeadChar;
        boolean isFlagsChangedEvent = this.isNpapiCallback ? eventType == 10 : eventType == 12;
        int jeventType = 401;
        int jkeyCode = 0;
        int jkeyLocation = 0;
        boolean postsTyped = false;
        int testChar = 65535;
        boolean bl = isDeadChar = chars != null && chars.length() == 0;
        if (isFlagsChangedEvent) {
            int[] in = new int[]{modifierFlags, keyCode};
            int[] out = new int[3];
            NSEvent.nsKeyModifiersToJavaKeyInfo(in, out);
            jkeyCode = out[0];
            jkeyLocation = out[1];
            jeventType = out[2];
        } else {
            int[] out;
            if (chars != null && chars.length() > 0) {
                testChar = chars.charAt(0);
            }
            int testCharIgnoringModifiers = charsIgnoringModifiers != null && charsIgnoringModifiers.length() > 0 ? (int)charsIgnoringModifiers.charAt(0) : 65535;
            int[] in = new int[]{testCharIgnoringModifiers, isDeadChar ? 1 : 0, modifierFlags, keyCode};
            postsTyped = NSEvent.nsToJavaKeyInfo(in, out = new int[3]);
            if (!postsTyped) {
                testChar = 65535;
            }
            if (isDeadChar && (testChar = (int)((char)out[2])) == 0) {
                return;
            }
            LWCToolkit lwcToolkit = (LWCToolkit)Toolkit.getDefaultToolkit();
            if (lwcToolkit.getLockingKeyState(20) && Locale.SIMPLIFIED_CHINESE.equals(lwcToolkit.getDefaultKeyboardLocale())) {
                testChar = testCharIgnoringModifiers;
            }
            jkeyCode = out[0];
            jkeyLocation = out[1];
            jeventType = this.isNpapiCallback ? NSEvent.npToJavaEventType(eventType) : NSEvent.nsToJavaEventType(eventType);
        }
        char javaChar = NSEvent.nsToJavaChar((char)testChar, modifierFlags);
        if (javaChar == '\uffff') {
            postsTyped = false;
        }
        int jmodifiers = NSEvent.nsToJavaKeyModifiers(modifierFlags);
        long when = System.currentTimeMillis();
        if (jeventType == 401) {
            this.lastKeyPressCode = jkeyCode;
        }
        this.eventNotifier.notifyKeyEvent(jeventType, when, jmodifiers, jkeyCode, javaChar, jkeyLocation);
        if (jeventType == 401 && (postsTyped &= needsKeyTyped) && (jmodifiers & 0x100) == 0) {
            if (needsKeyReleased && (jkeyCode == 10 || jkeyCode == 32)) {
                return;
            }
            this.eventNotifier.notifyKeyEvent(400, when, jmodifiers, 0, javaChar, 0);
            if (needsKeyReleased) {
                this.eventNotifier.notifyKeyEvent(402, when, jmodifiers, jkeyCode, javaChar, 0);
            }
        }
    }

    void handleInputEvent(String text) {
        if (text != null) {
            int length = text.length();
            char c = '\u0000';
            for (int index = 0; index < length; ++index) {
                c = text.charAt(index);
                this.eventNotifier.notifyKeyEvent(400, System.currentTimeMillis(), 0, 0, c, 0);
            }
            this.eventNotifier.notifyKeyEvent(402, System.currentTimeMillis(), 0, this.lastKeyPressCode, c, 0);
        }
    }

    void handleWindowFocusEvent(boolean gained, LWWindowPeer opposite) {
        this.eventNotifier.notifyActivation(gained, opposite);
    }

    static class DeltaAccumulator {
        double accumulatedDelta;
        boolean accumulate;

        DeltaAccumulator() {
        }

        int getRoundedDelta(double delta, int scrollPhase) {
            int roundDelta = (int)Math.round(delta);
            if (scrollPhase == 1) {
                if (roundDelta == 0 && delta != 0.0) {
                    roundDelta = delta > 0.0 ? 1 : -1;
                }
            } else {
                if (scrollPhase == 2) {
                    this.accumulatedDelta = 0.0;
                    this.accumulate = true;
                } else if (scrollPhase == 4) {
                    this.accumulate = true;
                }
                if (this.accumulate) {
                    this.accumulatedDelta += delta;
                    roundDelta = (int)Math.round(this.accumulatedDelta);
                    this.accumulatedDelta -= (double)roundDelta;
                    if (scrollPhase == 5) {
                        this.accumulate = false;
                    }
                }
            }
            return roundDelta;
        }
    }
}

