/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;

public class CPlatformView
extends CFRetainedResource {
    private LWWindowPeer peer;
    private SurfaceData surfaceData;
    private CGLLayer windowLayer;
    private CPlatformResponder responder;

    private native long nativeCreateView(int var1, int var2, int var3, int var4, long var5);

    private static native void nativeSetAutoResizable(long var0, boolean var2);

    private static native int nativeGetNSViewDisplayID(long var0);

    private static native Rectangle2D nativeGetLocationOnScreen(long var0);

    private static native boolean nativeIsViewUnderMouse(long var0);

    public CPlatformView() {
        super(0L, true);
    }

    public void initialize(LWWindowPeer peer, CPlatformResponder responder) {
        this.initializeBase(peer, responder);
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer = this.createCGLayer();
        }
        this.setPtr(this.nativeCreateView(0, 0, 0, 0, this.getWindowLayerPtr()));
    }

    public CGLLayer createCGLayer() {
        return new CGLLayer(this.peer);
    }

    protected void initializeBase(LWWindowPeer peer, CPlatformResponder responder) {
        this.peer = peer;
        this.responder = responder;
    }

    public long getAWTView() {
        return this.ptr;
    }

    public boolean isOpaque() {
        return !this.peer.isTranslucent();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.execute(ptr -> CWrapper.NSView.setFrame(ptr, x, y, width, height));
    }

    public Rectangle getBounds() {
        return this.peer.getBounds();
    }

    public Object getDestination() {
        return this.peer;
    }

    public void setToolTip(String msg) {
        this.execute(ptr -> CWrapper.NSView.setToolTip(ptr, msg));
    }

    public SurfaceData replaceSurfaceData() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.surfaceData = this.windowLayer.replaceSurfaceData();
        } else if (this.surfaceData == null) {
            CGraphicsConfig graphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
            this.surfaceData = graphicsConfig.createSurfaceData(this);
        } else {
            this.validateSurface();
        }
        return this.surfaceData;
    }

    private void validateSurface() {
        if (this.surfaceData != null) {
            ((CGLSurfaceData)this.surfaceData).validate();
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.peer.getGraphicsConfiguration();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    @Override
    public void dispose() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer.dispose();
        }
        super.dispose();
    }

    public long getWindowLayerPtr() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            return this.windowLayer.getPointer();
        }
        return 0L;
    }

    public void setAutoResizable(boolean toResize) {
        this.execute(ptr -> CPlatformView.nativeSetAutoResizable(ptr, toResize));
    }

    public boolean isUnderMouse() {
        AtomicBoolean ref = new AtomicBoolean();
        this.execute(ptr -> ref.set(CPlatformView.nativeIsViewUnderMouse(ptr)));
        return ref.get();
    }

    public GraphicsDevice getGraphicsDevice() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        CGraphicsEnvironment cge = (CGraphicsEnvironment)ge;
        AtomicInteger ref = new AtomicInteger();
        this.execute(ptr -> ref.set(CPlatformView.nativeGetNSViewDisplayID(ptr)));
        GraphicsDevice gd = cge.getScreenDevice(ref.get());
        if (gd == null) {
            gd = ge.getDefaultScreenDevice();
        }
        return gd;
    }

    public Point getLocationOnScreen() {
        AtomicReference ref = new AtomicReference();
        this.execute(ptr -> ref.set(CPlatformView.nativeGetLocationOnScreen(ptr).getBounds()));
        Rectangle r = (Rectangle)ref.get();
        if (r != null) {
            return new Point(r.x, r.y);
        }
        return new Point(0, 0);
    }

    private void deliverResize(int x, int y, int w, int h) {
        this.peer.notifyReshape(x, y, w, h);
    }

    private void deliverMouseEvent(NSEvent event) {
        int x = event.getX();
        int y = this.getBounds().height - event.getY();
        if (event.getType() == 22) {
            this.responder.handleScrollEvent(x, y, event.getModifierFlags(), event.getScrollDeltaX(), event.getScrollDeltaY(), event.getScrollPhase());
        } else {
            this.responder.handleMouseEvent(event.getType(), event.getModifierFlags(), event.getButtonNumber(), event.getClickCount(), x, y, event.getAbsX(), event.getAbsY());
        }
    }

    private void deliverKeyEvent(NSEvent event) {
        this.responder.handleKeyEvent(event.getType(), event.getModifierFlags(), event.getCharacters(), event.getCharactersIgnoringModifiers(), event.getKeyCode(), true, false);
    }

    private void deliverWindowDidExposeEvent() {
        this.peer.notifyExpose(this.peer.getSize());
    }
}

