/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import com.apple.laf.ClientPropertyApplicator;
import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.CGraphicsDevice;
import sun.awt.CausedFocusEvent;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWLightweightFramePeer;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPrinterDialogPeer;
import sun.lwawt.macosx.CThreading;
import sun.lwawt.macosx.CViewPlatformEmbeddedFrame;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.util.logging.PlatformLogger;

public class CPlatformWindow
extends CFRetainedResource
implements PlatformWindow {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.lwawt.macosx.CPlatformWindow");
    private static final PlatformLogger focusLogger = PlatformLogger.getLogger("sun.lwawt.macosx.focus.CPlatformWindow");
    public static final String WINDOW_BRUSH_METAL_LOOK = "apple.awt.brushMetalLook";
    public static final String WINDOW_DRAGGABLE_BACKGROUND = "apple.awt.draggableWindowBackground";
    public static final String WINDOW_ALPHA = "Window.alpha";
    public static final String WINDOW_SHADOW = "Window.shadow";
    public static final String WINDOW_STYLE = "Window.style";
    public static final String WINDOW_SHADOW_REVALIDATE_NOW = "apple.awt.windowShadow.revalidateNow";
    public static final String WINDOW_DOCUMENT_MODIFIED = "Window.documentModified";
    public static final String WINDOW_DOCUMENT_FILE = "Window.documentFile";
    public static final String WINDOW_CLOSEABLE = "Window.closeable";
    public static final String WINDOW_MINIMIZABLE = "Window.minimizable";
    public static final String WINDOW_ZOOMABLE = "Window.zoomable";
    public static final String WINDOW_HIDES_ON_DEACTIVATE = "Window.hidesOnDeactivate";
    public static final String WINDOW_DOC_MODAL_SHEET = "apple.awt.documentModalSheet";
    public static final String WINDOW_FADE_DELEGATE = "apple.awt._windowFadeDelegate";
    public static final String WINDOW_FADE_IN = "apple.awt._windowFadeIn";
    public static final String WINDOW_FADE_OUT = "apple.awt._windowFadeOut";
    public static final String WINDOW_FULLSCREENABLE = "apple.awt.fullscreenable";
    static final int MODELESS = 0;
    static final int DOCUMENT_MODAL = 1;
    static final int APPLICATION_MODAL = 2;
    static final int TOOLKIT_MODAL = 3;
    static final int _RESERVED_FOR_DATA = 1;
    static final int DECORATED = 2;
    static final int TEXTURED = 4;
    static final int UNIFIED = 8;
    static final int UTILITY = 16;
    static final int HUD = 32;
    static final int SHEET = 64;
    static final int CLOSEABLE = 128;
    static final int MINIMIZABLE = 256;
    static final int RESIZABLE = 512;
    static final int NONACTIVATING = 0x1000000;
    static final int IS_DIALOG = 0x2000000;
    static final int IS_MODAL = 0x4000000;
    static final int IS_POPUP = 0x8000000;
    static final int _STYLE_PROP_BITMASK = 1022;
    static final int HAS_SHADOW = 1024;
    static final int ZOOMABLE = 2048;
    static final int ALWAYS_ON_TOP = 32768;
    static final int HIDES_ON_DEACTIVATE = 131072;
    static final int DRAGGABLE_BACKGROUND = 524288;
    static final int DOCUMENT_MODIFIED = 0x200000;
    static final int FULLSCREENABLE = 0x800000;
    static final int _METHOD_PROP_BITMASK = 11177472;
    static final int SHOULD_BECOME_KEY = 4096;
    static final int SHOULD_BECOME_MAIN = 8192;
    static final int MODAL_EXCLUDED = 65536;
    static final int _CALLBACK_PROP_BITMASK = 77824;
    static ClientPropertyApplicator<JRootPane, CPlatformWindow> CLIENT_PROPERTY_APPLICATOR = new ClientPropertyApplicator<JRootPane, CPlatformWindow>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentModified"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(0x200000, value == null ? false : Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.brushMetalLook"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(4, Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.alpha"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            AWTUtilities.setWindowOpacity(c.target, value == null ? 1.0f : Float.parseFloat(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.shadow"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(1024, value == null ? true : Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.minimizable"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(256, Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.closeable"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(128, Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.zoomable"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(2048, Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.fullscreenable"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.setStyleBits(0x800000, Boolean.parseBoolean(value.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.windowShadow.revalidateNow"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            c.execute(ptr -> CPlatformWindow.nativeRevalidateNSWindowShadow(ptr));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentFile"){

        @Override
        public void applyProperty(CPlatformWindow c, Object value) {
            if (value == null || !(value instanceof File)) {
                c.execute(ptr -> CPlatformWindow.nativeSetNSWindowRepresentedFilename(ptr, null));
                return;
            }
            String filename = ((File)value).getAbsolutePath();
            c.execute(ptr -> CPlatformWindow.nativeSetNSWindowRepresentedFilename(ptr, filename));
        }
    }}){

        @Override
        public CPlatformWindow convertJComponentToTarget(JRootPane p) {
            Component root = SwingUtilities.getRoot(p);
            if (root == null || (LWWindowPeer)root.getPeer() == null) {
                return null;
            }
            return (CPlatformWindow)((LWWindowPeer)root.getPeer()).getPlatformWindow();
        }
    };
    private Rectangle nativeBounds = new Rectangle(0, 0, 0, 0);
    private volatile boolean isFullScreenMode;
    private boolean isFullScreenAnimationOn;
    private volatile boolean isIconifyAnimationActive;
    private volatile boolean isZoomed;
    private Window target;
    private LWWindowPeer peer;
    protected CPlatformView contentView;
    protected CPlatformWindow owner;
    protected boolean visible = false;
    private boolean undecorated;
    private Rectangle normalBounds = null;
    private CPlatformResponder responder;

    private native long nativeCreateNSWindow(long var1, long var3, long var5, double var7, double var9, double var11, double var13);

    private static native void nativeSetNSWindowStyleBits(long var0, int var2, int var3);

    private static native void nativeSetNSWindowMenuBar(long var0, long var2);

    private static native Insets nativeGetNSWindowInsets(long var0);

    private static native void nativeSetNSWindowBounds(long var0, double var2, double var4, double var6, double var8);

    private static native void nativeSetNSWindowMinMax(long var0, double var2, double var4, double var6, double var8);

    private static native void nativePushNSWindowToBack(long var0);

    private static native void nativePushNSWindowToFront(long var0);

    private static native void nativeSetNSWindowTitle(long var0, String var2);

    private static native void nativeRevalidateNSWindowShadow(long var0);

    private static native void nativeSetNSWindowMinimizedIcon(long var0, long var2);

    private static native void nativeSetNSWindowRepresentedFilename(long var0, String var2);

    private static native void nativeSetEnabled(long var0, boolean var2);

    private static native void nativeSynthesizeMouseEnteredExitedEvents();

    private static native void nativeSynthesizeMouseEnteredExitedEvents(long var0, int var2);

    private static native void nativeDispose(long var0);

    private static native void nativeEnterFullScreenMode(long var0);

    private static native void nativeExitFullScreenMode(long var0);

    static native CPlatformWindow nativeGetTopmostPlatformWindowUnderMouse();

    static int SET(int bits, int mask, boolean value) {
        if (value) {
            return bits | mask;
        }
        return bits & ~mask;
    }

    static boolean IS(int bits, int mask) {
        return (bits & mask) != 0;
    }

    public CPlatformWindow() {
        super(0L, true);
    }

    @Override
    public void initialize(Window _target, LWWindowPeer _peer, PlatformWindow _owner) {
        JRootPane rootpane;
        this.initializeBase(_target, _peer, _owner, new CPlatformView());
        int styleBits = this.getInitialStyleBits();
        this.responder = this.createPlatformResponder();
        this.contentView = this.createContentView();
        this.contentView.initialize(this.peer, this.responder);
        Rectangle bounds = !CPlatformWindow.IS(2, styleBits) ? new Rectangle(0, 0, 1, 1) : _peer.constrainBounds(_target.getBounds());
        AtomicLong ref = new AtomicLong();
        this.contentView.execute(viewPtr -> {
            boolean hasOwnerPtr = false;
            if (this.owner != null) {
                boolean bl = hasOwnerPtr = 0L != this.owner.executeGet(ownerPtr -> {
                    ref.set(this.nativeCreateNSWindow(viewPtr, ownerPtr, styleBits, bounds.x, bounds.y, bounds.width, bounds.height));
                    return 1L;
                });
            }
            if (!hasOwnerPtr) {
                ref.set(this.nativeCreateNSWindow(viewPtr, 0L, styleBits, bounds.x, bounds.y, bounds.width, bounds.height));
            }
        });
        this.setPtr(ref.get());
        if (this.target instanceof RootPaneContainer && (rootpane = ((RootPaneContainer)((Object)this.target)).getRootPane()) != null) {
            rootpane.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CLIENT_PROPERTY_APPLICATOR.attachAndApplyClientProperties(rootpane);
                    rootpane.removePropertyChangeListener("ancestor", this);
                }
            });
        }
        this.validateSurface();
    }

    protected void initializeBase(Window target, LWWindowPeer peer, PlatformWindow owner, CPlatformView view) {
        this.peer = peer;
        this.target = target;
        if (owner instanceof CPlatformWindow) {
            this.owner = (CPlatformWindow)owner;
        }
        this.contentView = view;
    }

    protected CPlatformResponder createPlatformResponder() {
        return new CPlatformResponder(this.peer, false);
    }

    protected CPlatformView createContentView() {
        return new CPlatformView();
    }

    protected int getInitialStyleBits() {
        boolean isPopup;
        int styleBits = 3970;
        if (this.isNativelyFocusableWindow()) {
            styleBits = CPlatformWindow.SET(styleBits, 4096, true);
            styleBits = CPlatformWindow.SET(styleBits, 8192, true);
        }
        boolean isFrame = this.target instanceof Frame;
        boolean isDialog = this.target instanceof Dialog;
        boolean bl = isPopup = this.target.getType() == Window.Type.POPUP;
        if (isDialog) {
            styleBits = CPlatformWindow.SET(styleBits, 256, false);
        }
        boolean bl2 = isFrame ? ((Frame)this.target).isUndecorated() : (this.undecorated = isDialog ? ((Dialog)this.target).isUndecorated() : true);
        if (this.undecorated) {
            styleBits = CPlatformWindow.SET(styleBits, 2, false);
        }
        boolean resizable = isFrame ? ((Frame)this.target).isResizable() : (isDialog ? ((Dialog)this.target).isResizable() : false);
        styleBits = CPlatformWindow.SET(styleBits, 512, resizable);
        if (!resizable) {
            styleBits = CPlatformWindow.SET(styleBits, 2048, false);
        }
        if (this.target.isAlwaysOnTop()) {
            styleBits = CPlatformWindow.SET(styleBits, 32768, true);
        }
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            styleBits = CPlatformWindow.SET(styleBits, 65536, true);
        }
        if (isPopup) {
            styleBits = CPlatformWindow.SET(styleBits, 4, false);
            styleBits = CPlatformWindow.SET(styleBits, 0x1000000, true);
            styleBits = CPlatformWindow.SET(styleBits, 0x8000000, true);
        }
        if (Window.Type.UTILITY.equals((Object)this.target.getType())) {
            styleBits = CPlatformWindow.SET(styleBits, 16, true);
        }
        if (this.target instanceof RootPaneContainer) {
            JRootPane rootpane = ((RootPaneContainer)((Object)this.target)).getRootPane();
            Object prop = null;
            prop = rootpane.getClientProperty(WINDOW_BRUSH_METAL_LOOK);
            if (prop != null) {
                styleBits = CPlatformWindow.SET(styleBits, 4, Boolean.parseBoolean(prop.toString()));
            }
            if (isDialog && ((Dialog)this.target).getModalityType() == Dialog.ModalityType.DOCUMENT_MODAL && (prop = rootpane.getClientProperty(WINDOW_DOC_MODAL_SHEET)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 64, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_STYLE)) != null) {
                if ("small".equals(prop)) {
                    styleBits = CPlatformWindow.SET(styleBits, 16, true);
                    if (this.target.isAlwaysOnTop() && rootpane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE) == null) {
                        styleBits = CPlatformWindow.SET(styleBits, 131072, true);
                    }
                }
                if ("textured".equals(prop)) {
                    styleBits = CPlatformWindow.SET(styleBits, 4, true);
                }
                if ("unified".equals(prop)) {
                    styleBits = CPlatformWindow.SET(styleBits, 8, true);
                }
                if ("hud".equals(prop)) {
                    styleBits = CPlatformWindow.SET(styleBits, 32, true);
                }
            }
            if ((prop = rootpane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 131072, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_CLOSEABLE)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 128, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_MINIMIZABLE)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 256, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_ZOOMABLE)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 2048, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_FULLSCREENABLE)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 0x800000, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_SHADOW)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 1024, Boolean.parseBoolean(prop.toString()));
            }
            if ((prop = rootpane.getClientProperty(WINDOW_DRAGGABLE_BACKGROUND)) != null) {
                styleBits = CPlatformWindow.SET(styleBits, 524288, Boolean.parseBoolean(prop.toString()));
            }
        }
        if (isDialog) {
            styleBits = CPlatformWindow.SET(styleBits, 0x2000000, true);
            if (((Dialog)this.target).isModal()) {
                styleBits = CPlatformWindow.SET(styleBits, 0x4000000, true);
            }
        }
        this.peer.setTextured(CPlatformWindow.IS(4, styleBits));
        return styleBits;
    }

    private void setStyleBits(int mask, boolean value) {
        this.execute(ptr -> CPlatformWindow.nativeSetNSWindowStyleBits(ptr, mask, value ? mask : 0));
    }

    private native void _toggleFullScreenMode(long var1);

    public void toggleFullScreen() {
        this.execute(this::_toggleFullScreenMode);
    }

    @Override
    public void setMenuBar(MenuBar mb) {
        CMenuBar mbPeer = (CMenuBar)LWToolkit.targetToPeer(mb);
        this.execute(nsWindowPtr -> {
            if (mbPeer != null) {
                mbPeer.execute(ptr -> CPlatformWindow.nativeSetNSWindowMenuBar(nsWindowPtr, ptr));
            } else {
                CPlatformWindow.nativeSetNSWindowMenuBar(nsWindowPtr, 0L);
            }
        });
    }

    @Override
    public void dispose() {
        this.contentView.dispose();
        this.execute(CPlatformWindow::nativeDispose);
        CPlatformWindow.super.dispose();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        new RuntimeException("unimplemented").printStackTrace();
        return null;
    }

    @Override
    public Insets getInsets() {
        AtomicReference ref = new AtomicReference();
        this.execute(ptr -> ref.set(CPlatformWindow.nativeGetNSWindowInsets(ptr)));
        return ref.get() != null ? (Insets)ref.get() : new Insets(0, 0, 0, 0);
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.nativeBounds.x, this.nativeBounds.y);
    }

    @Override
    public GraphicsDevice getGraphicsDevice() {
        return this.contentView.getGraphicsDevice();
    }

    @Override
    public SurfaceData getScreenSurface() {
        return null;
    }

    @Override
    public SurfaceData replaceSurfaceData() {
        return this.contentView.replaceSurfaceData();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.execute(ptr -> CPlatformWindow.nativeSetNSWindowBounds(ptr, x, y, w, h));
    }

    private boolean isMaximized() {
        if (this.undecorated) {
            return this.normalBounds != null;
        }
        return this.isZoomed;
    }

    private void maximize() {
        if (this.peer == null || this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.execute(CWrapper.NSWindow::zoom);
        } else {
            this.deliverZoom(true);
            LWCToolkit.flushNativeSelectors();
            this.normalBounds = this.peer.getBounds();
            GraphicsConfiguration config = this.getPeer().getGraphicsConfiguration();
            Insets i = ((CGraphicsDevice)config.getDevice()).getScreenInsets();
            Rectangle toBounds = config.getBounds();
            this.setBounds(toBounds.x + i.left, toBounds.y + i.top, toBounds.width - i.left - i.right, toBounds.height - i.top - i.bottom);
        }
    }

    private void unmaximize() {
        if (!this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.execute(CWrapper.NSWindow::zoom);
        } else {
            this.deliverZoom(false);
            Rectangle toBounds = this.normalBounds;
            this.normalBounds = null;
            this.setBounds(toBounds.x, toBounds.y, toBounds.width, toBounds.height);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        LWWindowPeer blocker;
        this.updateIconImages();
        this.updateFocusabilityForAutoRequestFocus(false);
        boolean wasMaximized = this.isMaximized();
        LWWindowPeer lWWindowPeer = blocker = this.peer == null ? null : this.peer.getBlocker();
        if (blocker == null || !visible) {
            if (visible) {
                this.contentView.execute(viewPtr -> this.execute(ptr -> CWrapper.NSWindow.makeFirstResponder(ptr, viewPtr)));
                boolean isPopup = this.target.getType() == Window.Type.POPUP;
                this.execute(ptr -> {
                    LWLightweightFramePeer peer;
                    long ownerWindowPtr;
                    if (isPopup) {
                        CWrapper.NSWindow.orderFrontRegardless(ptr);
                    } else {
                        CWrapper.NSWindow.orderFront(ptr);
                    }
                    boolean isKeyWindow = CWrapper.NSWindow.isKeyWindow(ptr);
                    if (!isKeyWindow) {
                        CWrapper.NSWindow.makeKeyWindow(ptr);
                    }
                    if (this.owner != null && this.owner.getPeer() instanceof LWLightweightFramePeer && (ownerWindowPtr = (peer = (LWLightweightFramePeer)this.owner.getPeer()).getOverriddenWindowHandle()) != 0L) {
                        CWrapper.NSWindow.addChildWindow(ownerWindowPtr, ptr, 1);
                    }
                });
            } else {
                this.execute(ptr -> {
                    CWrapper.NSWindow.orderOut(ptr);
                    CWrapper.NSWindow.close(ptr);
                });
            }
        } else {
            CPlatformWindow bw = (CPlatformWindow)blocker.getPlatformWindow();
            bw.execute(blockerPtr -> this.execute(ptr -> CWrapper.NSWindow.orderWindow(ptr, -1, blockerPtr)));
        }
        this.visible = visible;
        if (visible && this.target instanceof Frame) {
            if (!wasMaximized && this.isMaximized()) {
                this.deliverZoom(true);
            } else {
                int frameState = ((Frame)this.target).getExtendedState();
                if ((frameState & 1) != 0) {
                    frameState = 1;
                }
                switch (frameState) {
                    case 1: {
                        this.execute(CWrapper.NSWindow::miniaturize);
                        break;
                    }
                    case 6: {
                        this.maximize();
                        break;
                    }
                    default: {
                        this.unmaximize();
                    }
                }
            }
        }
        CPlatformWindow.nativeSynthesizeMouseEnteredExitedEvents();
        this.updateFocusabilityForAutoRequestFocus(true);
        if (visible) {
            if (this.owner != null && this.owner.isVisible()) {
                this.owner.execute(ownerPtr -> this.execute(ptr -> CWrapper.NSWindow.orderWindow(ptr, 1, ownerPtr)));
                this.applyWindowLevel(this.target);
            }
            for (Window w : this.target.getOwnedWindows()) {
                CPlatformWindow pw;
                WindowPeer p = (WindowPeer)w.getPeer();
                if (!(p instanceof LWWindowPeer) || (pw = (CPlatformWindow)((LWWindowPeer)p).getPlatformWindow()) == null || !pw.isVisible()) continue;
                pw.execute(childPtr -> this.execute(ptr -> CWrapper.NSWindow.orderWindow(childPtr, 1, ptr)));
                pw.applyWindowLevel(w);
            }
        }
        if (blocker != null && visible) {
            ((CPlatformWindow)blocker.getPlatformWindow()).orderAboveSiblings();
        }
    }

    @Override
    public void setTitle(String title) {
        this.execute(ptr -> CPlatformWindow.nativeSetNSWindowTitle(ptr, title));
    }

    @Override
    public void updateIconImages() {
        CImage cImage = this.getImageForTarget();
        this.execute(ptr -> {
            if (cImage == null) {
                CPlatformWindow.nativeSetNSWindowMinimizedIcon(ptr, 0L);
            } else {
                cImage.execute(imagePtr -> CPlatformWindow.nativeSetNSWindowMinimizedIcon(ptr, imagePtr));
            }
        });
    }

    public SurfaceData getSurfaceData() {
        return this.contentView.getSurfaceData();
    }

    @Override
    public void toBack() {
        this.execute(CPlatformWindow::nativePushNSWindowToBack);
    }

    @Override
    public void toFront() {
        LWCToolkit lwcToolkit = (LWCToolkit)Toolkit.getDefaultToolkit();
        Window w = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w != null && w.getPeer() != null && ((LWWindowPeer)w.getPeer()).getPeerType() == LWWindowPeer.PeerType.EMBEDDED_FRAME && !lwcToolkit.isApplicationActive()) {
            lwcToolkit.activateApplicationIgnoringOtherApps();
        }
        this.updateFocusabilityForAutoRequestFocus(false);
        this.execute(CPlatformWindow::nativePushNSWindowToFront);
        this.updateFocusabilityForAutoRequestFocus(true);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.setStyleBits(512, resizable);
    }

    @Override
    public void setSizeConstraints(int minW, int minH, int maxW, int maxH) {
        this.execute(ptr -> CPlatformWindow.nativeSetNSWindowMinMax(ptr, minW, minH, maxW, maxH));
    }

    @Override
    public boolean rejectFocusRequest(CausedFocusEvent.Cause cause) {
        if (cause != CausedFocusEvent.Cause.MOUSE_EVENT && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the request is rejected");
            return true;
        }
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        this.execute(ptr -> {
            if (CWrapper.NSWindow.canBecomeMainWindow(ptr)) {
                CWrapper.NSWindow.makeMainWindow(ptr);
            }
            CWrapper.NSWindow.makeKeyAndOrderFront(ptr);
        });
        return true;
    }

    @Override
    public boolean isActive() {
        AtomicBoolean ref = new AtomicBoolean();
        this.execute(ptr -> ref.set(CWrapper.NSWindow.isKeyWindow(ptr)));
        return ref.get();
    }

    @Override
    public void updateFocusableWindowState() {
        boolean isFocusable = this.isNativelyFocusableWindow();
        this.setStyleBits(12288, isFocusable);
    }

    @Override
    public Graphics transformGraphics(Graphics g) {
        return g;
    }

    @Override
    public void setAlwaysOnTop(boolean isAlwaysOnTop) {
        this.setStyleBits(32768, isAlwaysOnTop);
    }

    @Override
    public void setOpacity(float opacity) {
        this.execute(ptr -> CWrapper.NSWindow.setAlphaValue(ptr, opacity));
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        boolean isTextured;
        this.execute(ptr -> CWrapper.NSWindow.setOpaque(ptr, isOpaque));
        boolean bl = isTextured = this.peer == null ? false : this.peer.isTextured();
        if (!isTextured) {
            Color color;
            if (!isOpaque) {
                this.execute(ptr -> CWrapper.NSWindow.setBackgroundColor(ptr, 0));
            } else if (this.peer != null && (color = this.peer.getBackground()) != null) {
                int rgb = color.getRGB();
                this.execute(ptr -> CWrapper.NSWindow.setBackgroundColor(ptr, rgb));
            }
        }
        SwingUtilities.invokeLater(this::invalidateShadow);
    }

    @Override
    public void enterFullScreenMode() {
        this.isFullScreenMode = true;
        this.execute(CPlatformWindow::nativeEnterFullScreenMode);
    }

    @Override
    public void exitFullScreenMode() {
        this.execute(CPlatformWindow::nativeExitFullScreenMode);
        this.isFullScreenMode = false;
    }

    @Override
    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    @Override
    public void setWindowState(int windowState) {
        if (this.peer == null || !this.peer.isVisible()) {
            return;
        }
        int prevWindowState = this.peer.getState();
        if (prevWindowState == windowState) {
            return;
        }
        if ((windowState & 1) != 0) {
            windowState = 1;
        }
        switch (windowState) {
            case 1: {
                if (prevWindowState == 6) {
                    this.unmaximize();
                }
                this.execute(CWrapper.NSWindow::miniaturize);
                break;
            }
            case 6: {
                if (prevWindowState == 1) {
                    this.execute(CWrapper.NSWindow::deminiaturize);
                }
                this.maximize();
                break;
            }
            case 0: {
                if (prevWindowState == 1) {
                    this.execute(CWrapper.NSWindow::deminiaturize);
                    break;
                }
                if (prevWindowState != 6) break;
                this.unmaximize();
                break;
            }
            default: {
                throw new RuntimeException("Unknown window state: " + windowState);
            }
        }
    }

    @Override
    public void setModalBlocked(boolean blocked) {
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            return;
        }
        if (blocked) {
            this.execute(ptr -> CPlatformWindow.nativeSynthesizeMouseEnteredExitedEvents(ptr, 9));
        }
        this.execute(ptr -> CPlatformWindow.nativeSetEnabled(ptr, !blocked));
        this.checkBlockingAndOrder();
    }

    public final void invalidateShadow() {
        this.execute(ptr -> CPlatformWindow.nativeRevalidateNSWindowShadow(ptr));
    }

    private CImage getImageForTarget() {
        CImage icon = null;
        try {
            icon = CImage.getCreator().createFromImages(this.target.getIconImages());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    @Override
    public LWWindowPeer getPeer() {
        return this.peer;
    }

    @Override
    public boolean isUnderMouse() {
        return this.contentView.isUnderMouse();
    }

    public CPlatformView getContentView() {
        return this.contentView;
    }

    @Override
    public long getLayerPtr() {
        return this.contentView.getWindowLayerPtr();
    }

    private void validateSurface() {
        SurfaceData surfaceData = this.getSurfaceData();
        if (surfaceData instanceof CGLSurfaceData) {
            ((CGLSurfaceData)surfaceData).validate();
        }
    }

    void flushBuffers() {
        if (this.isVisible() && !this.nativeBounds.isEmpty() && !this.isFullScreenMode) {
            try {
                LWCToolkit.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                }, (Component)this.target);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static long getNativeViewPtr(PlatformWindow platformWindow) {
        long nativePeer = 0L;
        if (platformWindow instanceof CPlatformWindow) {
            nativePeer = ((CPlatformWindow)platformWindow).getContentView().getAWTView();
        } else if (platformWindow instanceof CViewPlatformEmbeddedFrame) {
            nativePeer = ((CViewPlatformEmbeddedFrame)platformWindow).getNSViewPtr();
        }
        return nativePeer;
    }

    private void deliverWindowFocusEvent(boolean gained, CPlatformWindow opposite) {
        if (gained && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the notification is ignored");
            return;
        }
        LWWindowPeer oppositePeer = opposite == null ? null : opposite.getPeer();
        this.responder.handleWindowFocusEvent(gained, oppositePeer);
    }

    protected void deliverMoveResizeEvent(int x, int y, int width, int height, boolean byUser) {
        AtomicBoolean ref = new AtomicBoolean();
        this.execute(ptr -> ref.set(CWrapper.NSWindow.isZoomed(ptr)));
        this.isZoomed = ref.get();
        this.checkZoom();
        Rectangle oldB = this.nativeBounds;
        this.nativeBounds = new Rectangle(x, y, width, height);
        if (this.peer != null) {
            this.peer.notifyReshape(x, y, width, height);
            if (byUser && !oldB.getSize().equals(this.nativeBounds.getSize()) || this.isFullScreenAnimationOn) {
                this.flushBuffers();
            }
        }
    }

    private void deliverWindowClosingEvent() {
        if (this.peer != null && this.peer.getBlocker() == null) {
            this.peer.postEvent(new WindowEvent(this.target, 201));
        }
    }

    private void deliverIconify(boolean iconify) {
        if (this.peer != null) {
            this.peer.notifyIconify(iconify);
        }
        if (iconify) {
            this.isIconifyAnimationActive = false;
        }
    }

    private void deliverZoom(boolean isZoomed) {
        if (this.peer != null) {
            this.peer.notifyZoom(isZoomed);
        }
    }

    private void checkZoom() {
        if (this.target instanceof Frame && this.isVisible()) {
            Frame targetFrame = (Frame)this.target;
            if (targetFrame.getExtendedState() != 6 && this.isMaximized()) {
                this.deliverZoom(true);
            } else if (targetFrame.getExtendedState() == 6 && !this.isMaximized()) {
                this.deliverZoom(false);
            }
        }
    }

    private void deliverNCMouseDown() {
        if (this.peer != null) {
            this.peer.notifyNCMouseDown();
        }
    }

    private boolean isNativelyFocusableWindow() {
        if (this.peer == null) {
            return false;
        }
        return !this.peer.isSimpleWindow() && this.target.getFocusableWindowState();
    }

    private boolean isBlocked() {
        LWWindowPeer blocker = this.peer != null ? this.peer.getBlocker() : null;
        return blocker != null;
    }

    private void updateFocusabilityForAutoRequestFocus(boolean isFocusable) {
        if (this.target.isAutoRequestFocus() || !this.isNativelyFocusableWindow()) {
            return;
        }
        this.setStyleBits(12288, isFocusable);
    }

    private boolean checkBlockingAndOrder() {
        LWWindowPeer blocker;
        LWWindowPeer lWWindowPeer = blocker = this.peer == null ? null : this.peer.getBlocker();
        if (blocker == null) {
            return false;
        }
        if (blocker instanceof CPrinterDialogPeer) {
            return true;
        }
        CPlatformWindow pWindow = (CPlatformWindow)blocker.getPlatformWindow();
        pWindow.orderAboveSiblings();
        pWindow.execute(ptr -> {
            CWrapper.NSWindow.orderFrontRegardless(ptr);
            CWrapper.NSWindow.makeKeyAndOrderFront(ptr);
            CWrapper.NSWindow.makeMainWindow(ptr);
        });
        return true;
    }

    private boolean isIconified() {
        int state;
        boolean isIconified = false;
        if (this.target instanceof Frame && ((state = ((Frame)this.target).getExtendedState()) & 1) != 0) {
            isIconified = true;
        }
        return this.isIconifyAnimationActive || isIconified;
    }

    private boolean isOneOfOwnersOrSelf(CPlatformWindow window) {
        while (window != null) {
            if (this == window) {
                return true;
            }
            window = window.owner;
        }
        return false;
    }

    private CPlatformWindow getRootOwner() {
        CPlatformWindow rootOwner = this;
        while (rootOwner.owner != null) {
            rootOwner = rootOwner.owner;
        }
        return rootOwner;
    }

    private void orderAboveSiblings() {
        CPlatformWindow rootOwner = this.getRootOwner();
        if (rootOwner.isVisible() && !rootOwner.isIconified() && !rootOwner.isActive()) {
            rootOwner.execute(CWrapper.NSWindow::orderFront);
        }
        if (!rootOwner.isIconified()) {
            AWTAccessor.WindowAccessor windowAccessor = AWTAccessor.getWindowAccessor();
            this.orderAboveSiblingsImpl(windowAccessor.getOwnedWindows(rootOwner.target));
        }
    }

    private void orderAboveSiblingsImpl(Window[] windows2) {
        ArrayList<Window> childWindows = new ArrayList<Window>();
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        AWTAccessor.WindowAccessor windowAccessor = AWTAccessor.getWindowAccessor();
        for (Window w : windows2) {
            boolean iconified = false;
            ComponentPeer p = componentAccessor.getPeer(w);
            if (p instanceof LWWindowPeer) {
                CPlatformWindow pw = (CPlatformWindow)((LWWindowPeer)p).getPlatformWindow();
                iconified = this.isIconified();
                if (pw != null && pw.isVisible() && !iconified) {
                    if (pw.isOneOfOwnersOrSelf(this)) {
                        pw.execute(CWrapper.NSWindow::orderFront);
                    } else {
                        pw.owner.execute(ownerPtr -> pw.execute(ptr -> CWrapper.NSWindow.orderWindow(ptr, 1, ownerPtr)));
                    }
                    pw.applyWindowLevel(w);
                }
            }
            if (iconified) continue;
            childWindows.addAll(Arrays.asList(windowAccessor.getOwnedWindows(w)));
        }
        if (!childWindows.isEmpty()) {
            this.orderAboveSiblingsImpl(childWindows.toArray(new Window[0]));
        }
    }

    protected void applyWindowLevel(Window target) {
        if (target.isAlwaysOnTop() && target.getType() != Window.Type.POPUP) {
            this.execute(ptr -> CWrapper.NSWindow.setLevel(ptr, 1));
        } else if (target.getType() == Window.Type.POPUP) {
            this.execute(ptr -> CWrapper.NSWindow.setLevel(ptr, 2));
        }
    }

    private Window getOwnerFrameOrDialog(Window window) {
        Window owner;
        for (owner = window.getOwner(); owner != null && !(owner instanceof Frame) && !(owner instanceof Dialog); owner = owner.getOwner()) {
        }
        return owner;
    }

    private boolean isSimpleWindowOwnedByEmbeddedFrame() {
        if (this.peer != null && this.peer.isSimpleWindow()) {
            return this.getOwnerFrameOrDialog(this.target) instanceof CEmbeddedFrame;
        }
        return false;
    }

    private void windowWillMiniaturize() {
        this.isIconifyAnimationActive = true;
    }

    private void windowDidBecomeMain() {
        assert (CThreading.assertAppKit());
        if (this.checkBlockingAndOrder()) {
            return;
        }
        this.orderAboveSiblings();
    }

    private void windowWillEnterFullScreen() {
        this.isFullScreenAnimationOn = true;
    }

    private void windowDidEnterFullScreen() {
        this.isFullScreenAnimationOn = false;
    }

    private void windowWillExitFullScreen() {
        this.isFullScreenAnimationOn = true;
    }

    private void windowDidExitFullScreen() {
        this.isFullScreenAnimationOn = false;
    }
}

