/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.lwawt.macosx.CPrinterGraphics;
import sun.lwawt.macosx.CPrinterJobDialog;
import sun.lwawt.macosx.CPrinterPageDialog;
import sun.lwawt.macosx.CPrinterSurfaceData;
import sun.lwawt.macosx.LWCToolkit;
import sun.print.PeekGraphics;
import sun.print.RasterPrinterJob;
import sun.print.SunPageSelection;

public final class CPrinterJob
extends RasterPrinterJob {
    private static String sShouldNotReachHere = "Should not reach here.";
    private volatile SecondaryLoop printingLoop;
    private boolean noDefaultPrinter = false;
    private static Font defaultFont;
    private long fNSPrintInfo = -1L;
    private Object fNSPrintInfoLock = new Object();
    volatile boolean onEventThread;

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (this.getPrintService() instanceof StreamPrintService) {
            return super.printDialog(this.attributes);
        }
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return page;
        }
        if (this.getPrintService() instanceof StreamPrintService) {
            return super.pageDialog(page);
        }
        PageFormat pageClone = (PageFormat)page.clone();
        boolean doIt = this.pageSetup(pageClone, null);
        return doIt ? pageClone : page;
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        PageFormat newPage = (PageFormat)page.clone();
        this.getDefaultPage(newPage);
        return newPage;
    }

    @Override
    protected void setAttributes(PrintRequestAttributeSet attributes) throws PrinterException {
        SunPageSelection rangeSelect;
        super.setAttributes(attributes);
        if (attributes == null) {
            return;
        }
        PageRanges pageRangesAttr = (PageRanges)attributes.get(PageRanges.class);
        if (this.isSupportedValue(pageRangesAttr, attributes) && ((rangeSelect = (SunPageSelection)attributes.get(SunPageSelection.class)) == null || rangeSelect == SunPageSelection.RANGE)) {
            int[][] range = pageRangesAttr.getMembers();
            this.setPageRange(range[0][0] - 1, range[0][1] - 1);
        }
    }

    @Override
    protected void cancelDoc() throws PrinterAbortException {
        super.cancelDoc();
        if (this.printingLoop != null) {
            this.printingLoop.exit();
        }
    }

    private void completePrintLoop() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    CPrinterJob.this.performingPrinting = false;
                }
                if (CPrinterJob.this.printingLoop != null) {
                    CPrinterJob.this.printingLoop.exit();
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintRequestAttributeSet attributes) throws PrinterException {
        int totalPages2;
        PrintService psvc = this.getPrintService();
        if (psvc == null) {
            throw new PrinterException("No print service found.");
        }
        if (psvc instanceof StreamPrintService) {
            this.spoolToService(psvc, attributes);
            return;
        }
        this.setAttributes(attributes);
        if (this.destinationAttr != null) {
            this.validateDestination(this.destinationAttr);
        }
        int firstPage = this.getFirstPage();
        int lastPage = this.getLastPage();
        if (lastPage == -1 && (totalPages2 = this.mDocument.getNumberOfPages()) != -1) {
            lastPage = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            CPrinterJob totalPages2 = this;
            synchronized (totalPages2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            PageRanges pr = attributes == null ? null : (PageRanges)attributes.get(PageRanges.class);
            int[][] prMembers = pr == null ? new int[0][0] : pr.getMembers();
            int loopi = 0;
            do {
                if (EventQueue.isDispatchThread()) {
                    this.onEventThread = true;
                    this.printingLoop = AccessController.doPrivileged(new PrivilegedAction<SecondaryLoop>(){

                        @Override
                        public SecondaryLoop run() {
                            return Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                        }
                    });
                    try {
                        if (this.printLoop(false, firstPage, lastPage)) {
                            this.printingLoop.enter();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.onEventThread = false;
                    try {
                        this.printLoop(true, firstPage, lastPage);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (++loopi >= prMembers.length) continue;
                firstPage = prMembers[loopi][0] - 1;
                lastPage = prMembers[loopi][1] - 1;
            } while (loopi < prMembers.length);
        }
        finally {
            CPrinterJob cPrinterJob = this;
            synchronized (cPrinterJob) {
                this.performingPrinting = false;
                this.notify();
            }
            if (this.printingLoop != null) {
                this.printingLoop.exit();
            }
        }
    }

    @Override
    protected double getXRes() {
        return 0.0;
    }

    @Override
    protected double getYRes() {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableX(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableY(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPageWidth(Paper p) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPageHeight(Paper p) {
        return 0.0;
    }

    protected void startPage(PageFormat format, Printable painter, int index) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void endPage(PageFormat format, Printable painter, int index) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void printBand(byte[] data, int x, int y, int width, int height) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void startDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected void endDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    @Override
    protected native void abortDoc();

    public boolean pageSetup(PageFormat page, Printable painter) {
        CPrinterPageDialog printerDialog = new CPrinterPageDialog(null, this, page, painter);
        printerDialog.setVisible(true);
        boolean result = printerDialog.getRetVal();
        printerDialog.dispose();
        return result;
    }

    private boolean jobSetup(Pageable doc, boolean allowPrintToFile) {
        CPrinterJobDialog printerDialog = new CPrinterJobDialog(null, this, doc, allowPrintToFile);
        printerDialog.setVisible(true);
        boolean result = printerDialog.getRetVal();
        printerDialog.dispose();
        return result;
    }

    private native void getDefaultPage(PageFormat var1);

    @Override
    protected native void validatePaper(Paper var1, Paper var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo != -1L) {
                this.dispose(this.fNSPrintInfo);
            }
            this.fNSPrintInfo = -1L;
        }
    }

    private native long createNSPrintInfo();

    private native void dispose(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNSPrintInfo() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo == -1L) {
                this.fNSPrintInfo = this.createNSPrintInfo();
            }
            return this.fNSPrintInfo;
        }
    }

    private native boolean printLoop(boolean var1, int var2, int var3) throws PrinterException;

    private PageFormat getPageFormat(int pageIndex) {
        PageFormat page;
        try {
            page = this.getPageable().getPageFormat(pageIndex);
        }
        catch (Exception e) {
            return null;
        }
        return page;
    }

    private Printable getPrintable(int pageIndex) {
        Printable painter;
        try {
            painter = this.getPageable().getPrintable(pageIndex);
        }
        catch (Exception e) {
            return null;
        }
        return painter;
    }

    private String getPrinterName() {
        PrintService service = this.getPrintService();
        if (service == null) {
            return null;
        }
        return service.getName();
    }

    private void setPrinterServiceFromNative(String printerName) {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        for (int i = 0; i < services.length; ++i) {
            PrintService service = services[i];
            if (!printerName.equals(service.getName())) continue;
            try {
                this.setPrintService(service);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return;
        }
    }

    private Rectangle2D getPageFormatArea(PageFormat page) {
        Rectangle2D.Double pageFormatArea = new Rectangle2D.Double(page.getImageableX(), page.getImageableY(), page.getImageableWidth(), page.getImageableHeight());
        return pageFormatArea;
    }

    private boolean cancelCheck() {
        boolean cancelled;
        boolean bl = cancelled = this.performingPrinting && this.userCancelled;
        if (cancelled) {
            try {
                LWCToolkit.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CPrinterJob.this.cancelDoc();
                        }
                        catch (PrinterAbortException printerAbortException) {
                            // empty catch block
                        }
                    }
                }, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return cancelled;
    }

    private PeekGraphics createFirstPassGraphics(PrinterJob printerJob, PageFormat page) {
        BufferedImage bimg = new BufferedImage((int)Math.round(page.getWidth()), (int)Math.round(page.getHeight()), 3);
        PeekGraphics peekGraphics = this.createPeekGraphics(bimg.createGraphics(), printerJob);
        Rectangle2D pageFormatArea = this.getPageFormatArea(page);
        this.initPrinterGraphics(peekGraphics, pageFormatArea);
        return peekGraphics;
    }

    private void printToPathGraphics(PeekGraphics graphics, final PrinterJob printerJob, final Printable painter, final PageFormat page, final int pageIndex, final long context) throws PrinterException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    SurfaceData sd = CPrinterSurfaceData.createData(page, context);
                    if (defaultFont == null) {
                        defaultFont = new Font("Dialog", 0, 12);
                    }
                    SunGraphics2D delegate = new SunGraphics2D(sd, Color.black, Color.white, defaultFont);
                    CPrinterGraphics pathGraphics = new CPrinterGraphics(delegate, printerJob);
                    Rectangle2D pageFormatArea = CPrinterJob.this.getPageFormatArea(page);
                    CPrinterJob.this.initPrinterGraphics(pathGraphics, pageFormatArea);
                    painter.print(pathGraphics, page, pageIndex);
                    ((Graphics)delegate).dispose();
                    Object var2_3 = null;
                }
                catch (PrinterException pe) {
                    throw new UndeclaredThrowableException(pe);
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InvocationTargetException ite) {
                Throwable te = ite.getTargetException();
                if (te instanceof PrinterException) {
                    throw (PrinterException)te;
                }
                te.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getPageformatPrintablePeekgraphics(final int pageIndex) {
        final Object[] ret = new Object[3];
        final CPrinterJob printerJob = this;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] objectArray = ret;
                synchronized (ret) {
                    try {
                        Printable printable;
                        Pageable pageable = CPrinterJob.this.getPageable();
                        PageFormat pageFormat = pageable.getPageFormat(pageIndex);
                        if (pageFormat != null && (printable = pageable.getPrintable(pageIndex)) != null) {
                            BufferedImage bimg = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
                            PeekGraphics peekGraphics = CPrinterJob.this.createPeekGraphics(bimg.createGraphics(), printerJob);
                            Rectangle2D pageFormatArea = CPrinterJob.this.getPageFormatArea(pageFormat);
                            CPrinterJob.this.initPrinterGraphics(peekGraphics, pageFormatArea);
                            ret[0] = pageFormat;
                            ret[1] = printable;
                            ret[2] = peekGraphics;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            r.run();
        }
        Object[] objectArray = ret;
        synchronized (ret) {
            if (ret[2] != null) {
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return ret;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D printAndGetPageFormatArea(final Printable printable, final Graphics graphics, final PageFormat pageFormat, final int pageIndex) {
        final Rectangle2D[] ret = new Rectangle2D[1];
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Rectangle2D[] rectangle2DArray = ret;
                synchronized (ret) {
                    try {
                        int pageResult = printable.print(graphics, pageFormat, pageIndex);
                        if (pageResult != 1) {
                            ret[0] = CPrinterJob.this.getPageFormatArea(pageFormat);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            r.run();
        }
        Rectangle2D[] rectangle2DArray = ret;
        synchronized (ret) {
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return ret[0];
        }
    }

    private static void detachPrintLoop(final long target, final long arg) {
        new Thread(){

            @Override
            public void run() {
                CPrinterJob._safePrintLoop(target, arg);
            }
        }.start();
    }

    private static native void _safePrintLoop(long var0, long var2);

    @Override
    protected void startPage(PageFormat arg0, Printable arg1, int arg2, boolean arg3) throws PrinterException {
    }

    @Override
    protected MediaSize getMediaSize(Media media, PrintService service, PageFormat page) {
        if (media == null || !(media instanceof MediaSizeName)) {
            return this.getDefaultMediaSize(page);
        }
        MediaSize size = MediaSize.getMediaSizeForName((MediaSizeName)media);
        return size != null ? size : this.getDefaultMediaSize(page);
    }

    private MediaSize getDefaultMediaSize(PageFormat page) {
        int inch = 72;
        Paper paper = page.getPaper();
        float width = (float)(paper.getWidth() / 72.0);
        float height = (float)(paper.getHeight() / 72.0);
        return new MediaSize(width, height, 25400);
    }

    @Override
    protected MediaPrintableArea getDefaultPrintableArea(PageFormat page, double w, double h) {
        float dpi = 72.0f;
        Paper paper = page.getPaper();
        return new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
    }

    static {
        Toolkit.getDefaultToolkit();
    }
}

