/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.peer.RobotPeer;
import sun.awt.CGraphicsDevice;
import sun.lwawt.macosx.CCursorManager;

class CRobot
implements RobotPeer {
    private static final int MOUSE_LOCATION_UNKNOWN = -1;
    private final CGraphicsDevice fDevice;
    private int mouseLastX = -1;
    private int mouseLastY = -1;
    private int mouseButtonsState = 0;

    public CRobot(Robot r, CGraphicsDevice d) {
        this.fDevice = d;
        this.initRobot();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void mouseMove(int x, int y) {
        this.mouseLastX = x;
        this.mouseLastY = y;
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, this.mouseButtonsState, true, true);
    }

    @Override
    public void mousePress(int buttons) {
        this.mouseButtonsState |= buttons;
        this.checkMousePos();
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, buttons, true, false);
    }

    @Override
    public void mouseRelease(int buttons) {
        this.mouseButtonsState &= ~buttons;
        this.checkMousePos();
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, buttons, false, false);
    }

    private void checkMousePos() {
        if (this.mouseLastX == -1 || this.mouseLastY == -1) {
            Rectangle deviceBounds = this.fDevice.getDefaultConfiguration().getBounds();
            Point mousePos = CCursorManager.getInstance().getCursorPosition();
            if (mousePos.x < deviceBounds.x) {
                mousePos.x = deviceBounds.x;
            } else if (mousePos.x > deviceBounds.x + deviceBounds.width) {
                mousePos.x = deviceBounds.x + deviceBounds.width;
            }
            if (mousePos.y < deviceBounds.y) {
                mousePos.y = deviceBounds.y;
            } else if (mousePos.y > deviceBounds.y + deviceBounds.height) {
                mousePos.y = deviceBounds.y + deviceBounds.height;
            }
            this.mouseLastX = mousePos.x;
            this.mouseLastY = mousePos.y;
        }
    }

    @Override
    public native void mouseWheel(int var1);

    @Override
    public void keyPress(int keycode) {
        this.keyEvent(keycode, true);
    }

    @Override
    public void keyRelease(int keycode) {
        this.keyEvent(keycode, false);
    }

    @Override
    public int getRGBPixel(int x, int y) {
        int[] c = new int[1];
        this.getScreenPixels(new Rectangle(x, y, 1, 1), c);
        return c[0];
    }

    @Override
    public int[] getRGBPixels(Rectangle bounds) {
        int[] c = new int[bounds.width * bounds.height];
        this.getScreenPixels(bounds, c);
        return c;
    }

    private native void initRobot();

    private native void mouseEvent(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

    private native void keyEvent(int var1, boolean var2);

    private void getScreenPixels(Rectangle r, int[] pixels) {
        this.nativeGetScreenPixels(r.x, r.y, r.width, r.height, pixels);
    }

    private native void nativeGetScreenPixels(int var1, int var2, int var3, int var4, int[] var5);
}

