/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.SunHints;
import sun.font.CStrike;
import sun.font.FontStrike;
import sun.java2d.OSXSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.TextPipe;

public class CTextPipe
implements TextPipe {
    public native void doDrawString(SurfaceData var1, long var2, String var4, double var5, double var7);

    public native void doDrawGlyphs(SurfaceData var1, long var2, GlyphVector var4, float var5, float var6);

    public native void doUnicodes(SurfaceData var1, long var2, char[] var4, int var5, int var6, float var7, float var8);

    public native void doOneUnicode(SurfaceData var1, long var2, char var4, float var5, float var6);

    long getNativeStrikePtr(SunGraphics2D sg2d) {
        FontStrike fontStrike = sg2d.getFontInfo().fontStrike;
        if (!(fontStrike instanceof CStrike)) {
            return 0L;
        }
        return ((CStrike)fontStrike).getNativeStrikePtr();
    }

    void drawGlyphVectorAsShape(SunGraphics2D sg2d, GlyphVector gv, float x, float y) {
        int length = gv.getNumGlyphs();
        for (int i = 0; i < length; ++i) {
            Shape glyph = gv.getGlyphOutline(i, x, y);
            sg2d.fill(glyph);
        }
    }

    void drawTextAsShape(SunGraphics2D sg2d, String s, double x, double y) {
        Object oldAliasingHint = sg2d.getRenderingHint(SunHints.KEY_ANTIALIASING);
        FontRenderContext frc = sg2d.getFontRenderContext();
        sg2d.setRenderingHint(SunHints.KEY_ANTIALIASING, frc.isAntiAliased() ? SunHints.VALUE_ANTIALIAS_ON : SunHints.VALUE_ANTIALIAS_OFF);
        Font font = sg2d.getFont();
        GlyphVector gv = font.createGlyphVector(frc, s);
        int length = gv.getNumGlyphs();
        for (int i = 0; i < length; ++i) {
            Shape glyph = gv.getGlyphOutline(i, (float)x, (float)y);
            sg2d.fill(glyph);
        }
        sg2d.setRenderingHint(SunHints.KEY_ANTIALIASING, oldAliasingHint);
    }

    @Override
    public void drawString(SunGraphics2D sg2d, String s, double x, double y) {
        long nativeStrikePtr = this.getNativeStrikePtr(sg2d);
        if (OSXSurfaceData.IsSimpleColor(sg2d.paint) && nativeStrikePtr != 0L) {
            OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
            surfaceData.drawString(this, sg2d, nativeStrikePtr, s, x, y);
        } else {
            this.drawTextAsShape(sg2d, s, x, y);
        }
    }

    @Override
    public void drawGlyphVector(SunGraphics2D sg2d, GlyphVector gV, float x, float y) {
        Font prevFont = sg2d.getFont();
        sg2d.setFont(gV.getFont());
        long nativeStrikePtr = this.getNativeStrikePtr(sg2d);
        if (OSXSurfaceData.IsSimpleColor(sg2d.paint) && nativeStrikePtr != 0L) {
            OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
            surfaceData.drawGlyphs(this, sg2d, nativeStrikePtr, gV, x, y);
        } else {
            this.drawGlyphVectorAsShape(sg2d, gV, x, y);
        }
        sg2d.setFont(prevFont);
    }

    @Override
    public void drawChars(SunGraphics2D sg2d, char[] data, int offset, int length, int x, int y) {
        long nativeStrikePtr = this.getNativeStrikePtr(sg2d);
        if (OSXSurfaceData.IsSimpleColor(sg2d.paint) && nativeStrikePtr != 0L) {
            OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
            surfaceData.drawUnicodes(this, sg2d, nativeStrikePtr, data, offset, length, x, y);
        } else {
            this.drawTextAsShape(sg2d, new String(data, offset, length), x, y);
        }
    }

    public CTextPipe traceWrap() {
        return new Tracer();
    }

    public static class Tracer
    extends CTextPipe {
        void doDrawString(SurfaceData sData, long nativeStrikePtr, String s, float x, float y) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawString");
            super.doDrawString(sData, nativeStrikePtr, s, x, y);
        }

        @Override
        public void doDrawGlyphs(SurfaceData sData, long nativeStrikePtr, GlyphVector gV, float x, float y) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawGlyphs");
            super.doDrawGlyphs(sData, nativeStrikePtr, gV, x, y);
        }

        @Override
        public void doUnicodes(SurfaceData sData, long nativeStrikePtr, char[] unicodes, int offset, int length, float x, float y) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicodes");
            super.doUnicodes(sData, nativeStrikePtr, unicodes, offset, length, x, y);
        }

        @Override
        public void doOneUnicode(SurfaceData sData, long nativeStrikePtr, char aUnicode, float x, float y) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicode");
            super.doOneUnicode(sData, nativeStrikePtr, aUnicode, x, y);
        }
    }
}

