/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.peer.TrayIconPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CPopupMenu;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;

public class CTrayIcon
extends CFRetainedResource
implements TrayIconPeer {
    private TrayIcon target;
    private PopupMenu popup;
    private JDialog messageDialog = null;
    private DialogEventHandler handler = null;
    private final Frame dummyFrame;
    private static int mouseClickButtons = 0;

    CTrayIcon(TrayIcon target) {
        super(0L, true);
        this.target = target;
        this.popup = target.getPopupMenu();
        this.dummyFrame = new Frame();
        this.setPtr(this.createModel());
        this.checkAndCreatePopupPeer();
        this.updateImage();
    }

    private CPopupMenu checkAndCreatePopupPeer() {
        CPopupMenu menuPeer = null;
        if (this.popup != null) {
            try {
                menuPeer = (CPopupMenu)this.popup.getPeer();
                if (menuPeer == null) {
                    this.popup.addNotify();
                    menuPeer = (CPopupMenu)this.popup.getPeer();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return menuPeer;
    }

    private long createModel() {
        return this.nativeCreate();
    }

    private native long nativeCreate();

    public long getPopupMenuModel() {
        if (this.popup == null) {
            PopupMenu popupMenu = this.target.getPopupMenu();
            if (popupMenu != null) {
                this.popup = popupMenu;
            } else {
                return 0L;
            }
        }
        return this.checkAndCreatePopupPeer().ptr;
    }

    @Override
    public void displayMessage(final String caption, final String text, final String messageType) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.displayMessageOnEDT(caption, text, messageType);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CTrayIcon.this.displayMessageOnEDT(caption, text, messageType);
                    }
                });
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.messageDialog != null) {
            this.disposeMessageDialog();
        }
        this.dummyFrame.dispose();
        if (this.popup != null) {
            this.popup.removeNotify();
        }
        LWCToolkit.targetDisposedPeer(this.target, this);
        this.target = null;
        super.dispose();
    }

    @Override
    public void setToolTip(String tooltip) {
        this.execute(ptr -> this.nativeSetToolTip(ptr, tooltip));
    }

    private native void nativeSetToolTip(long var1, String var3);

    @Override
    public void showPopupMenu(int x, int y) {
    }

    @Override
    public void updateImage() {
        Image image = this.target.getImage();
        if (image == null) {
            return;
        }
        MediaTracker tracker = new MediaTracker(new Button(""));
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return;
        }
        CImage cimage = CImage.getCreator().createFromImage(image);
        boolean imageAutoSize = this.target.isImageAutoSize();
        cimage.execute(imagePtr -> this.execute(ptr -> this.setNativeImage(ptr, imagePtr, imageAutoSize)));
    }

    private native void setNativeImage(long var1, long var3, boolean var5);

    private void postEvent(final AWTEvent event) {
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(CTrayIcon.this.target), event);
            }
        });
    }

    private void handleMouseEvent(NSEvent nsEvent) {
        int buttonNumber = nsEvent.getButtonNumber();
        SunToolkit tk = (SunToolkit)Toolkit.getDefaultToolkit();
        if (buttonNumber > 2 && !tk.areExtraMouseButtonsEnabled() || buttonNumber > tk.getNumberOfButtons() - 1) {
            return;
        }
        int jeventType = NSEvent.nsToJavaEventType(nsEvent.getType());
        int jbuttonNumber = 0;
        int jclickCount = 0;
        if (jeventType != 503) {
            jbuttonNumber = NSEvent.nsToJavaButton(buttonNumber);
            jclickCount = nsEvent.getClickCount();
        }
        int jmodifiers = NSEvent.nsToJavaMouseModifiers(buttonNumber, nsEvent.getModifierFlags());
        boolean isPopupTrigger = NSEvent.isPopupTrigger(jmodifiers);
        int eventButtonMask = jbuttonNumber > 0 ? MouseEvent.getMaskForButton(jbuttonNumber) : 0;
        long when = System.currentTimeMillis();
        if (jeventType == 501) {
            mouseClickButtons |= eventButtonMask;
        } else if (jeventType == 506) {
            mouseClickButtons = 0;
        }
        int absX = nsEvent.getAbsX();
        int absY = nsEvent.getAbsY();
        MouseEvent mouseEvent = new MouseEvent(this.dummyFrame, jeventType, when, jmodifiers, absX, absY, absX, absY, jclickCount, isPopupTrigger, jbuttonNumber);
        mouseEvent.setSource(this.target);
        this.postEvent(mouseEvent);
        if (jeventType == 501 && isPopupTrigger) {
            String cmd = this.target.getActionCommand();
            ActionEvent event = new ActionEvent(this.target, 1001, cmd);
            this.postEvent(event);
        }
        if (jeventType == 502) {
            if ((mouseClickButtons & eventButtonMask) != 0) {
                MouseEvent clickEvent = new MouseEvent(this.dummyFrame, 500, when, jmodifiers, absX, absY, absX, absY, jclickCount, isPopupTrigger, jbuttonNumber);
                clickEvent.setSource(this.target);
                this.postEvent(clickEvent);
            }
            mouseClickButtons &= ~eventButtonMask;
        }
    }

    private native Point2D nativeGetIconLocation(long var1);

    public void displayMessageOnEDT(String caption, String text, String messageType) {
        Icon icon;
        if (this.messageDialog != null) {
            this.disposeMessageDialog();
        }
        if ((icon = CTrayIcon.getIconForMessageType(messageType)) != null) {
            icon = new ImageIcon(CTrayIcon.scaleIcon(icon, 0.75));
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int textWidth = screenSize.width / 8;
        this.messageDialog = this.createMessageDialog(caption, text, textWidth, icon);
        this.showMessageDialog();
    }

    private JDialog createMessageDialog(String caption, String text, int textWidth, Icon icon) {
        this.handler = new DialogEventHandler();
        JTextArea captionArea = null;
        if (caption != null) {
            captionArea = CTrayIcon.createTextArea(caption, textWidth, false, true);
        }
        JTextArea textArea = null;
        if (text != null) {
            textArea = CTrayIcon.createTextArea(text, textWidth, true, false);
        }
        Object[] panels = null;
        if (captionArea != null) {
            panels = textArea != null ? new Object[]{captionArea, new JLabel(), textArea} : new Object[]{captionArea};
        } else if (textArea != null) {
            panels = new Object[]{textArea};
        }
        JOptionPane op = new JOptionPane(panels);
        op.setIcon(icon);
        op.addPropertyChangeListener(this.handler);
        try {
            JPanel buttonPanel = (JPanel)op.getComponent(1);
            JButton ok = (JButton)buttonPanel.getComponent(0);
            ok.putClientProperty("JComponent.sizeVariant", "small");
        }
        catch (Throwable buttonPanel) {
            // empty catch block
        }
        JDialog dialog = new JDialog((Dialog)null);
        JRootPane rp = dialog.getRootPane();
        rp.putClientProperty("Window.style", "small");
        rp.putClientProperty("Window.zoomable", "false");
        dialog.setDefaultCloseOperation(0);
        dialog.setModal(false);
        dialog.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        dialog.setAlwaysOnTop(true);
        dialog.setAutoRequestFocus(false);
        dialog.setResizable(false);
        dialog.setContentPane(op);
        dialog.addWindowListener(this.handler);
        AWTAccessor.getWindowAccessor().setTrayIconWindow(dialog, true);
        dialog.pack();
        return dialog;
    }

    private void showMessageDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        AtomicReference ref = new AtomicReference();
        this.execute(ptr -> ref.set(this.nativeGetIconLocation(ptr)));
        Point2D iconLoc = (Point2D)ref.get();
        if (iconLoc == null) {
            return;
        }
        int dialogY = (int)iconLoc.getY();
        int dialogX = (int)iconLoc.getX();
        if (dialogX + this.messageDialog.getWidth() > screenSize.width) {
            dialogX = screenSize.width - this.messageDialog.getWidth();
        }
        this.messageDialog.setLocation(dialogX, dialogY);
        this.messageDialog.setVisible(true);
    }

    private void disposeMessageDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeMessageDialogOnEDT();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CTrayIcon.this.disposeMessageDialogOnEDT();
                    }
                });
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void disposeMessageDialogOnEDT() {
        if (this.messageDialog != null) {
            this.messageDialog.removeWindowListener(this.handler);
            this.messageDialog.removePropertyChangeListener(this.handler);
            this.messageDialog.dispose();
            this.messageDialog = null;
            this.handler = null;
        }
    }

    private static BufferedImage scaleIcon(Icon icon, double scaleFactor) {
        if (icon == null) {
            return null;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage iconImage = gc.createCompatibleImage(w, h, 3);
        Graphics2D g = iconImage.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        int scaledW = (int)((double)w * scaleFactor);
        int scaledH = (int)((double)h * scaleFactor);
        BufferedImage scaledImage = gc.createCompatibleImage(scaledW, scaledH, 3);
        g = scaledImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(iconImage, 0, 0, scaledW, scaledH, null);
        g.dispose();
        return scaledImage;
    }

    private static Icon getIconForMessageType(String messageType) {
        if (messageType.equals("ERROR")) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        if (messageType.equals("WARNING")) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    private static JTextArea createTextArea(String text, int width, boolean isSmall, boolean isBold) {
        JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setBorder(null);
        textArea.setBackground(new JLabel().getBackground());
        if (isSmall) {
            textArea.putClientProperty("JComponent.sizeVariant", "small");
        }
        if (isBold) {
            Font font = textArea.getFont();
            Font boldFont = new Font(font.getName(), 1, font.getSize());
            textArea.setFont(boldFont);
        }
        textArea.setSize(width, 1);
        return textArea;
    }

    private final class DialogEventHandler
    extends WindowAdapter
    implements PropertyChangeListener {
        private DialogEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            CTrayIcon.this.disposeMessageDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (CTrayIcon.this.messageDialog == null) {
                return;
            }
            String prop = e.getPropertyName();
            Container cp = CTrayIcon.this.messageDialog.getContentPane();
            if (CTrayIcon.this.messageDialog.isVisible() && e.getSource() == cp && prop.equals("value")) {
                CTrayIcon.this.disposeMessageDialog();
            }
        }
    }
}

