/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_security_icon_bw16_png;
import sun.awt.AWTIcon32_security_icon_bw24_png;
import sun.awt.AWTIcon32_security_icon_bw32_png;
import sun.awt.AWTIcon32_security_icon_bw48_png;
import sun.awt.AWTIcon32_security_icon_interim16_png;
import sun.awt.AWTIcon32_security_icon_interim24_png;
import sun.awt.AWTIcon32_security_icon_interim32_png;
import sun.awt.AWTIcon32_security_icon_interim48_png;
import sun.awt.AWTIcon32_security_icon_yellow16_png;
import sun.awt.AWTIcon32_security_icon_yellow24_png;
import sun.awt.AWTIcon32_security_icon_yellow32_png;
import sun.awt.AWTIcon32_security_icon_yellow48_png;
import sun.awt.IconInfo;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.SecurityWarningWindow;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.CWrapper;

public final class CWarningWindow
extends CPlatformWindow
implements SecurityWarningWindow,
PlatformEventNotifier {
    private final Lock lock = new Lock();
    private static final int SHOWING_DELAY = 300;
    private static final int HIDING_DELAY = 2000;
    private Rectangle bounds = new Rectangle();
    private final WeakReference<LWWindowPeer> ownerPeer;
    private final Window ownerWindow;
    private volatile int currentIcon = 0;
    private int currentSize = -1;
    private static IconInfo[][] icons;
    private final Runnable hidingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CWarningWindow.this.lock;
            synchronized (object) {
                CWarningWindow.this.setVisible(false);
            }
            object = CWarningWindow.this.scheduler;
            synchronized (object) {
                CWarningWindow.this.hidingTaskHandle = null;
            }
        }
    };
    private final Runnable showingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CWarningWindow.this.lock;
            synchronized (object) {
                if (!CWarningWindow.this.isVisible()) {
                    CWarningWindow.this.setVisible(true);
                }
                CWarningWindow.this.repaint();
            }
            object = CWarningWindow.this.scheduler;
            synchronized (object) {
                if (CWarningWindow.this.currentIcon > 0) {
                    CWarningWindow.this.currentIcon--;
                    CWarningWindow.this.showingTaskHandle = CWarningWindow.this.scheduler.schedule(CWarningWindow.this.showingTask, 300L, TimeUnit.MILLISECONDS);
                } else {
                    CWarningWindow.this.showingTaskHandle = null;
                }
            }
        }
    };
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture hidingTaskHandle;
    private ScheduledFuture showingTaskHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IconInfo getSecurityIconInfo(int size, int num) {
        Class<CWarningWindow> clazz = CWarningWindow.class;
        synchronized (CWarningWindow.class) {
            if (icons == null) {
                icons = new IconInfo[4][3];
                CWarningWindow.icons[0][0] = new IconInfo(AWTIcon32_security_icon_bw16_png.security_icon_bw16_png);
                CWarningWindow.icons[0][1] = new IconInfo(AWTIcon32_security_icon_interim16_png.security_icon_interim16_png);
                CWarningWindow.icons[0][2] = new IconInfo(AWTIcon32_security_icon_yellow16_png.security_icon_yellow16_png);
                CWarningWindow.icons[1][0] = new IconInfo(AWTIcon32_security_icon_bw24_png.security_icon_bw24_png);
                CWarningWindow.icons[1][1] = new IconInfo(AWTIcon32_security_icon_interim24_png.security_icon_interim24_png);
                CWarningWindow.icons[1][2] = new IconInfo(AWTIcon32_security_icon_yellow24_png.security_icon_yellow24_png);
                CWarningWindow.icons[2][0] = new IconInfo(AWTIcon32_security_icon_bw32_png.security_icon_bw32_png);
                CWarningWindow.icons[2][1] = new IconInfo(AWTIcon32_security_icon_interim32_png.security_icon_interim32_png);
                CWarningWindow.icons[2][2] = new IconInfo(AWTIcon32_security_icon_yellow32_png.security_icon_yellow32_png);
                CWarningWindow.icons[3][0] = new IconInfo(AWTIcon32_security_icon_bw48_png.security_icon_bw48_png);
                CWarningWindow.icons[3][1] = new IconInfo(AWTIcon32_security_icon_interim48_png.security_icon_interim48_png);
                CWarningWindow.icons[3][2] = new IconInfo(AWTIcon32_security_icon_yellow48_png.security_icon_yellow48_png);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int sizeIndex = size % icons.length;
            return icons[sizeIndex][num % icons[sizeIndex].length];
        }
    }

    public CWarningWindow(Window _ownerWindow, LWWindowPeer _ownerPeer) {
        this.ownerPeer = new WeakReference<LWWindowPeer>(_ownerPeer);
        this.ownerWindow = _ownerWindow;
        this.initialize(null, null, _ownerPeer.getPlatformWindow());
        this.setOpaque(false);
        String warningString = this.ownerWindow.getWarningString();
        if (warningString != null) {
            this.contentView.setToolTip(this.ownerWindow.getWarningString());
        }
        this.updateIconSize();
    }

    @Override
    public void reposition(int x, int y, int w, int h) {
        Point2D point = AWTAccessor.getWindowAccessor().calculateSecurityWarningPosition(this.ownerWindow, x, y, w, h);
        this.setBounds((int)point.getX(), (int)point.getY(), this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible, boolean doSchedule) {
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        synchronized (scheduledExecutorService) {
            if (this.showingTaskHandle != null) {
                this.showingTaskHandle.cancel(false);
                this.showingTaskHandle = null;
            }
            if (this.hidingTaskHandle != null) {
                this.hidingTaskHandle.cancel(false);
                this.hidingTaskHandle = null;
            }
            if (visible) {
                this.currentIcon = this.isVisible() ? 0 : 2;
                this.showingTaskHandle = this.scheduler.schedule(this.showingTask, 50L, TimeUnit.MILLISECONDS);
            } else {
                if (!this.isVisible()) {
                    return;
                }
                this.hidingTaskHandle = doSchedule ? this.scheduler.schedule(this.hidingTask, 2000L, TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.hidingTask, 50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void notifyIconify(boolean iconify) {
    }

    @Override
    public void notifyZoom(boolean isZoomed) {
    }

    @Override
    public void notifyExpose(Rectangle r) {
        this.repaint();
    }

    @Override
    public void notifyReshape(int x, int y, int w, int h) {
    }

    @Override
    public void notifyUpdateCursor() {
    }

    @Override
    public void notifyActivation(boolean activation, LWWindowPeer opposite) {
    }

    @Override
    public void notifyNCMouseDown() {
    }

    @Override
    public void notifyMouseEvent(int id, long when, int button, int x, int y, int screenX, int screenY, int modifiers, int clickCount, boolean popupTrigger, byte[] bdata) {
        LWWindowPeer peer = (LWWindowPeer)this.ownerPeer.get();
        if (id == 505) {
            if (peer != null) {
                peer.updateSecurityWarningVisibility();
            }
        } else if (id == 504 && peer != null) {
            peer.updateSecurityWarningVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.bounds.getBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.execute(ptr -> {
                if (visible) {
                    CWrapper.NSWindow.orderFront(ptr);
                } else {
                    CWrapper.NSWindow.orderOut(ptr);
                }
            });
            this.visible = visible;
            if (visible && this.owner != null && this.owner.isVisible()) {
                this.owner.execute(ownerPtr -> this.execute(ptr -> CWrapper.NSWindow.orderWindow(ptr, 1, ownerPtr)));
                this.applyWindowLevel(this.ownerWindow);
            }
        }
    }

    @Override
    public void notifyMouseWheelEvent(long when, int x, int y, int modifiers, int scrollType, int scrollAmount, int wheelRotation, double preciseWheelRotation, byte[] bdata) {
    }

    @Override
    public void notifyKeyEvent(int id, long when, int modifiers, int keyCode, char keyChar, int keyLocation) {
    }

    @Override
    protected int getInitialStyleBits() {
        int styleBits = 0;
        CPlatformWindow.SET(styleBits, 16, true);
        return styleBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deliverMoveResizeEvent(int x, int y, int width, int height, boolean byUser) {
        boolean isResize;
        Lock lock = this.lock;
        synchronized (lock) {
            isResize = this.bounds.width != width || this.bounds.height != height;
            this.bounds = new Rectangle(x, y, width, height);
        }
        if (isResize) {
            this.replaceSurface();
        }
        super.deliverMoveResizeEvent(x, y, width, height, byUser);
    }

    @Override
    protected CPlatformResponder createPlatformResponder() {
        return new CPlatformResponder(this, false);
    }

    @Override
    protected CPlatformView createContentView() {
        return new CPlatformView(){

            @Override
            public GraphicsConfiguration getGraphicsConfiguration() {
                LWWindowPeer peer = (LWWindowPeer)CWarningWindow.this.ownerPeer.get();
                return peer.getGraphicsConfiguration();
            }

            @Override
            public Rectangle getBounds() {
                return CWarningWindow.this.getBounds();
            }

            @Override
            public CGLLayer createCGLayer() {
                return new CGLLayer(null){

                    @Override
                    public Rectangle getBounds() {
                        return CWarningWindow.this.getBounds();
                    }

                    @Override
                    public GraphicsConfiguration getGraphicsConfiguration() {
                        LWWindowPeer peer = (LWWindowPeer)CWarningWindow.this.ownerPeer.get();
                        return peer.getGraphicsConfiguration();
                    }

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIconSize() {
        int newSize = -1;
        if (this.ownerWindow != null) {
            Insets insets = this.ownerWindow.getInsets();
            int max = Math.max(insets.top, Math.max(insets.bottom, Math.max(insets.left, insets.right)));
            newSize = max < 24 ? 0 : (max < 32 ? 1 : (max < 48 ? 2 : 3));
        }
        if (newSize == -1) {
            newSize = 0;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            if (newSize != this.currentSize) {
                this.currentSize = newSize;
                IconInfo ico = CWarningWindow.getSecurityIconInfo(this.currentSize, 0);
                AWTAccessor.getWindowAccessor().setSecurityWarningSize(this.ownerWindow, ico.getWidth(), ico.getHeight());
            }
        }
    }

    private final Graphics getGraphics() {
        SurfaceData sd = this.contentView.getSurfaceData();
        if (this.ownerWindow == null || sd == null) {
            return null;
        }
        return this.transformGraphics(new SunGraphics2D(sd, SystemColor.windowText, SystemColor.window, this.ownerWindow.getFont()));
    }

    private void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                ((Graphics2D)g).setComposite(AlphaComposite.Src);
                g.drawImage(this.getSecurityIconInfo().getImage(), 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void replaceSurface() {
        SurfaceData oldData = this.contentView.getSurfaceData();
        this.replaceSurfaceData();
        if (oldData != null && oldData != this.contentView.getSurfaceData()) {
            oldData.flush();
        }
    }

    private int getWidth() {
        return this.getSecurityIconInfo().getWidth();
    }

    private int getHeight() {
        return this.getSecurityIconInfo().getHeight();
    }

    private IconInfo getSecurityIconInfo() {
        return CWarningWindow.getSecurityIconInfo(this.currentSize, this.currentIcon);
    }

    private static class Lock {
        private Lock() {
        }
    }
}

