/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.InvocationEvent;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsDevice;
import sun.awt.LightweightFrame;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.java2d.opengl.OGLRenderQueue;
import sun.lwawt.LWCursorManager;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.lwawt.macosx.CCheckboxMenuItem;
import sun.lwawt.macosx.CClipboard;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CCustomCursor;
import sun.lwawt.macosx.CDataTransferer;
import sun.lwawt.macosx.CDesktopPeer;
import sun.lwawt.macosx.CDragSourceContextPeer;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.lwawt.macosx.CFileDialog;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CInputMethod;
import sun.lwawt.macosx.CInputMethodDescriptor;
import sun.lwawt.macosx.CMenu;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.CMouseDragGestureRecognizer;
import sun.lwawt.macosx.CPlatformComponent;
import sun.lwawt.macosx.CPlatformEmbeddedFrame;
import sun.lwawt.macosx.CPlatformLWComponent;
import sun.lwawt.macosx.CPlatformLWWindow;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.CPopupMenu;
import sun.lwawt.macosx.CPrinterDialog;
import sun.lwawt.macosx.CPrinterDialogPeer;
import sun.lwawt.macosx.CRobot;
import sun.lwawt.macosx.CSystemTray;
import sun.lwawt.macosx.CThreading;
import sun.lwawt.macosx.CTrayIcon;
import sun.lwawt.macosx.CViewEmbeddedFrame;
import sun.lwawt.macosx.CViewPlatformEmbeddedFrame;
import sun.lwawt.macosx.CWarningWindow;
import sun.lwawt.macosx.NamedCursor;
import sun.security.action.GetBooleanAction;
import sun.util.CoreResourceBundleControl;

public final class LWCToolkit
extends LWToolkit {
    private static final int BUTTONS = 5;
    private static CInputMethodDescriptor sInputMethodDescriptor;
    private static final boolean inAWT;
    private static final int NUM_APPLE_COLORS = 3;
    public static final int KEYBOARD_FOCUS_COLOR = 0;
    public static final int INACTIVE_SELECTION_BACKGROUND_COLOR = 1;
    public static final int INACTIVE_SELECTION_FOREGROUND_COLOR = 2;
    private static int[] appleColors;
    private static boolean areExtraMouseButtonsEnabled;
    private static final String nsImagePrefix = "NSImage://";
    private static Boolean sunAwtDisableCALayers;

    private static native void initIDs();

    public LWCToolkit() {
        areExtraMouseButtonsEnabled = Boolean.parseBoolean(System.getProperty("sun.awt.enableExtraMouseButtons", "true"));
        System.setProperty("sun.awt.enableExtraMouseButtons", "" + areExtraMouseButtonsEnabled);
    }

    private native void loadNativeColors(int[] var1, int[] var2);

    @Override
    protected void loadSystemColors(int[] systemColors) {
        if (systemColors == null) {
            return;
        }
        this.loadNativeColors(systemColors, appleColors);
    }

    public static Color getAppleColor(int color) {
        return new AppleSpecificColor(color);
    }

    static void systemColorsChanged() {
        EventQueue.invokeLater(() -> AccessController.doPrivileged(() -> {
            AWTAccessor.getSystemColorAccessor().updateSystemColors();
            return null;
        }));
    }

    public static LWCToolkit getLWCToolkit() {
        return (LWCToolkit)Toolkit.getDefaultToolkit();
    }

    @Override
    protected PlatformWindow createPlatformWindow(LWWindowPeer.PeerType peerType) {
        if (peerType == LWWindowPeer.PeerType.EMBEDDED_FRAME) {
            return new CPlatformEmbeddedFrame();
        }
        if (peerType == LWWindowPeer.PeerType.VIEW_EMBEDDED_FRAME) {
            return new CViewPlatformEmbeddedFrame();
        }
        if (peerType == LWWindowPeer.PeerType.LW_FRAME) {
            return new CPlatformLWWindow();
        }
        assert (peerType == LWWindowPeer.PeerType.SIMPLEWINDOW || peerType == LWWindowPeer.PeerType.DIALOG || peerType == LWWindowPeer.PeerType.FRAME);
        return new CPlatformWindow();
    }

    LWWindowPeer createEmbeddedFrame(CEmbeddedFrame target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.EMBEDDED_FRAME);
        return this.createDelegatedPeer(target, platformComponent, platformWindow, LWWindowPeer.PeerType.EMBEDDED_FRAME);
    }

    LWWindowPeer createEmbeddedFrame(CViewEmbeddedFrame target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.VIEW_EMBEDDED_FRAME);
        return this.createDelegatedPeer(target, platformComponent, platformWindow, LWWindowPeer.PeerType.VIEW_EMBEDDED_FRAME);
    }

    private CPrinterDialogPeer createCPrinterDialog(CPrinterDialog target) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.DIALOG);
        CPrinterDialogPeer peer = new CPrinterDialogPeer(target, platformComponent, platformWindow);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        if (target instanceof CPrinterDialog) {
            return this.createCPrinterDialog((CPrinterDialog)target);
        }
        return super.createDialog(target);
    }

    @Override
    protected SecurityWarningWindow createSecurityWarning(Window ownerWindow, LWWindowPeer ownerPeer) {
        return new CWarningWindow(ownerWindow, ownerPeer);
    }

    @Override
    protected PlatformComponent createPlatformComponent() {
        return new CPlatformComponent();
    }

    @Override
    protected PlatformComponent createLwPlatformComponent() {
        return new CPlatformLWComponent();
    }

    @Override
    protected FileDialogPeer createFileDialogPeer(FileDialog target) {
        return new CFileDialog(target);
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        CMenu peer = new CMenu(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        CMenuBar peer = new CMenuBar(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        CMenuItem peer = new CMenuItem(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        CCheckboxMenuItem peer = new CCheckboxMenuItem(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        CPopupMenu peer = new CPopupMenu(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray target) {
        return new CSystemTray();
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon target) {
        CTrayIcon peer = new CTrayIcon(target);
        LWCToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    protected DesktopPeer createDesktopPeer(Desktop target) {
        return new CDesktopPeer();
    }

    @Override
    public LWCursorManager getCursorManager() {
        return CCursorManager.getInstance();
    }

    @Override
    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException, HeadlessException {
        return new CCustomCursor(cursor, hotSpot, name);
    }

    @Override
    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) throws HeadlessException {
        return CCustomCursor.getBestCursorSize(preferredWidth, preferredHeight);
    }

    @Override
    protected void platformCleanup() {
    }

    @Override
    protected void platformInit() {
    }

    @Override
    protected void platformRunMessage() {
    }

    @Override
    protected void platformShutdown() {
    }

    @Override
    public FontPeer getFontPeer(String name, int style) {
        return new OSXPlatformFont(name, style);
    }

    @Override
    protected int getScreenHeight() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().height;
    }

    @Override
    protected int getScreenWidth() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().width;
    }

    @Override
    protected void initializeDesktopProperties() {
        super.initializeDesktopProperties();
        HashMap<RenderingHints.Key, Object> fontHints = new HashMap<RenderingHints.Key, Object>();
        fontHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        this.desktopProperties.put("awt.font.desktophints", fontHints);
        this.desktopProperties.put("awt.mouse.numButtons", 5);
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        this.desktopProperties.put("DnD.isDragImageSupported", new Boolean(true));
        this.desktopProperties.put("DnD.Cursor.CopyDrop", new NamedCursor("DnD.Cursor.CopyDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveDrop", new NamedCursor("DnD.Cursor.MoveDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkDrop", new NamedCursor("DnD.Cursor.LinkDrop"));
        this.desktopProperties.put("DnD.Cursor.CopyNoDrop", new NamedCursor("DnD.Cursor.CopyNoDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveNoDrop", new NamedCursor("DnD.Cursor.MoveNoDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkNoDrop", new NamedCursor("DnD.Cursor.LinkNoDrop"));
    }

    @Override
    protected boolean syncNativeQueue(long timeout) {
        return this.nativeSyncQueue(timeout);
    }

    @Override
    public native void beep();

    @Override
    public int getScreenResolution() throws HeadlessException {
        return (int)((CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getXResolution();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration gc) {
        return ((CGraphicsConfig)gc).getDevice().getScreenInsets();
    }

    @Override
    public void sync() {
        OGLRenderQueue.sync();
        LWCToolkit.flushNativeSelectors();
    }

    @Override
    public RobotPeer createRobot(Robot target, GraphicsDevice screen) {
        return new CRobot(target, (CGraphicsDevice)screen);
    }

    private native boolean isCapsLockOn();

    @Override
    public boolean getLockingKeyState(int keyCode) throws UnsupportedOperationException {
        switch (keyCode) {
            case 144: 
            case 145: 
            case 262: {
                throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
            }
            case 20: {
                return this.isCapsLockOn();
            }
        }
        throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
    }

    @Override
    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        return areExtraMouseButtonsEnabled;
    }

    @Override
    public int getNumberOfButtons() {
        return 5;
    }

    @Override
    public boolean isTraySupported() {
        return true;
    }

    @Override
    public DataTransferer getDataTransferer() {
        return CDataTransferer.getInstanceImpl();
    }

    @Override
    public boolean isAlwaysOnTopSupported() {
        return true;
    }

    private static void installToolkitThreadInJava() {
        Thread.currentThread().setName(CThreading.APPKIT_THREAD_NAME);
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(null);
            return null;
        });
    }

    @Override
    public boolean isWindowOpacitySupported() {
        return true;
    }

    @Override
    public boolean isFrameStateSupported(int state) throws HeadlessException {
        switch (state) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMenuShortcutKeyMask() {
        return 4;
    }

    @Override
    public Image getImage(String filename) {
        Image nsImage = this.checkForNSImage(filename);
        if (nsImage != null) {
            return nsImage;
        }
        if (LWCToolkit.imageCached(filename)) {
            return super.getImage(filename);
        }
        String filename2x = LWCToolkit.getScaledImageName(filename);
        return LWCToolkit.imageExists(filename2x) ? this.getImageWithResolutionVariant(filename, filename2x) : super.getImage(filename);
    }

    @Override
    public Image getImage(URL url) {
        if (LWCToolkit.imageCached(url)) {
            return super.getImage(url);
        }
        URL url2x = LWCToolkit.getScaledImageURL(url);
        return LWCToolkit.imageExists(url2x) ? this.getImageWithResolutionVariant(url, url2x) : super.getImage(url);
    }

    private Image checkForNSImage(String imageName) {
        if (imageName == null) {
            return null;
        }
        if (!imageName.startsWith(nsImagePrefix)) {
            return null;
        }
        return CImage.getCreator().createImageFromName(imageName.substring(nsImagePrefix.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doEquals(final Object a, final Object b, Component c) {
        if (a == b) {
            return true;
        }
        final boolean[] ret = new boolean[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean[] blArray = ret;
                    synchronized (ret) {
                        ret[0] = a.equals(b);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean[] blArray = ret;
        synchronized (ret) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return ret[0];
        }
    }

    public static <T> T invokeAndWait(Callable<T> callable, Component component) throws Exception {
        CallableWrapper<T> wrapper = new CallableWrapper<T>(callable);
        LWCToolkit.invokeAndWait(wrapper, component);
        return wrapper.getResult();
    }

    public static void invokeAndWait(Runnable runnable, Component component) throws InvocationTargetException {
        long mediator = LWCToolkit.createAWTRunLoopMediator();
        InvocationEvent invocationEvent = new InvocationEvent(component != null ? component : Toolkit.getDefaultToolkit(), runnable, () -> {
            if (mediator != 0L) {
                LWCToolkit.stopAWTRunLoop(mediator);
            }
        }, true);
        if (component != null) {
            AppContext appContext = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent(appContext, invocationEvent);
            SunToolkit.flushPendingEvents(appContext);
        } else {
            ((LWCToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(invocationEvent);
        }
        LWCToolkit.doAWTRunLoop(mediator, false);
        Throwable eventException = invocationEvent.getException();
        if (eventException != null) {
            if (eventException instanceof UndeclaredThrowableException) {
                eventException = ((UndeclaredThrowableException)eventException).getUndeclaredThrowable();
            }
            throw new InvocationTargetException(eventException);
        }
    }

    public static void invokeLater(Runnable event, Component component) throws InvocationTargetException {
        InvocationEvent invocationEvent = new InvocationEvent(component != null ? component : Toolkit.getDefaultToolkit(), event);
        if (component != null) {
            AppContext appContext = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent(appContext, invocationEvent);
            SunToolkit.flushPendingEvents(appContext);
        } else {
            ((LWCToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(invocationEvent);
        }
        Exception eventException = invocationEvent.getException();
        if (eventException == null) {
            return;
        }
        if (eventException instanceof UndeclaredThrowableException) {
            throw new InvocationTargetException(((UndeclaredThrowableException)eventException).getUndeclaredThrowable());
        }
        throw new InvocationTargetException(eventException);
    }

    EventQueue getSystemEventQueueForInvokeAndWait() {
        return this.getSystemEventQueueImpl();
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        LightweightFrame f = SunToolkit.getLightweightFrame(dge.getComponent());
        if (f != null) {
            return f.createDragSourceContextPeer(dge);
        }
        return CDragSourceContextPeer.createDragSourceContextPeer(dge);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        LightweightFrame f = SunToolkit.getLightweightFrame(c);
        if (f != null) {
            return f.createDragGestureRecognizer(abstractRecognizerClass, ds, c, srcActions, dgl);
        }
        CMouseDragGestureRecognizer dgr = null;
        if (MouseDragGestureRecognizer.class.equals(abstractRecognizerClass)) {
            dgr = new CMouseDragGestureRecognizer(ds, c, srcActions, dgl);
        }
        return (T)dgr;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        Locale locale = CInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        if (sInputMethodDescriptor == null) {
            sInputMethodDescriptor = new CInputMethodDescriptor();
        }
        return sInputMethodDescriptor;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        return CInputMethod.mapInputMethodHighlight(highlight);
    }

    @Override
    public int getFocusAcceleratorKeyMask() {
        return 10;
    }

    @Override
    public boolean isPrintableCharacterModifiersMask(int mods) {
        return (mods & 6) == 0;
    }

    @Override
    public boolean canPopupOverlapTaskBar() {
        return false;
    }

    public static synchronized boolean getSunAwtDisableCALayers() {
        if (sunAwtDisableCALayers == null) {
            sunAwtDisableCALayers = AccessController.doPrivileged(new GetBooleanAction("sun.awt.disableCALayers"));
        }
        return sunAwtDisableCALayers;
    }

    native boolean isApplicationActive();

    public static native boolean isEmbedded();

    public native void activateApplicationIgnoringOtherApps();

    static native long createAWTRunLoopMediator();

    static void doAWTRunLoop(long mediator, boolean processEvents) {
        LWCToolkit.doAWTRunLoopImpl(mediator, processEvents, inAWT);
    }

    private static native void doAWTRunLoopImpl(long var0, boolean var2, boolean var3);

    static native void stopAWTRunLoop(long var0);

    private native boolean nativeSyncQueue(long var1);

    static native void flushNativeSelectors();

    @Override
    public Clipboard createPlatformClipboard() {
        return new CClipboard("System");
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType exclusionType) {
        return exclusionType == null || exclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || exclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || exclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isWindowShapingSupported() {
        return true;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration gc) {
        return true;
    }

    @Override
    public boolean isSwingBackbufferTranslucencySupported() {
        return true;
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    private static URL getScaledImageURL(URL url) {
        try {
            String scaledImagePath = LWCToolkit.getScaledImageName(url.getPath());
            return scaledImagePath == null ? null : new URL(url.getProtocol(), url.getHost(), url.getPort(), scaledImagePath);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String getScaledImageName(String path) {
        String name;
        if (!LWCToolkit.isValidPath(path)) {
            return null;
        }
        int slash = path.lastIndexOf(47);
        String string = name = slash < 0 ? path : path.substring(slash + 1);
        if (name.contains("@2x")) {
            return null;
        }
        int dot = name.lastIndexOf(46);
        String name2x = dot < 0 ? name + "@2x" : name.substring(0, dot) + "@2x" + name.substring(dot);
        return slash < 0 ? name2x : path.substring(0, slash + 1) + name2x;
    }

    private static boolean isValidPath(String path) {
        return path != null && !path.isEmpty() && !path.endsWith("/") && !path.endsWith(".");
    }

    @Override
    protected PlatformWindow getPlatformWindowUnderMouse() {
        return CPlatformWindow.nativeGetTopmostPlatformWindowUnderMouse();
    }

    static {
        System.err.flush();
        ResourceBundle platformResources = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                ResourceBundle platformResources = null;
                try {
                    platformResources = ResourceBundle.getBundle("sun.awt.resources.awtosx", CoreResourceBundleControl.getRBControlInstance());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                System.loadLibrary("awt");
                System.loadLibrary("fontmanager");
                return platformResources;
            }
        });
        AWTAccessor.getToolkitAccessor().setPlatformResources(platformResources);
        if (!GraphicsEnvironment.isHeadless()) {
            LWCToolkit.initIDs();
        }
        inAWT = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !Boolean.parseBoolean(System.getProperty("javafx.embed.singleThread", "false"));
            }
        });
        appleColors = new int[]{-8355712, -4144960, -13619152};
        areExtraMouseButtonsEnabled = true;
        sunAwtDisableCALayers = null;
    }

    static final class CallableWrapper<T>
    implements Runnable {
        final Callable<T> callable;
        T object;
        Exception e;

        CallableWrapper(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.object = this.callable.call();
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public T getResult() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
            return this.object;
        }
    }

    class OSXPlatformFont
    extends PlatformFont {
        OSXPlatformFont(String name, int style) {
            super(name, style);
        }

        @Override
        protected char getMissingGlyphCharacter() {
            return '\ufff8';
        }
    }

    private static class AppleSpecificColor
    extends Color {
        private final int index;

        AppleSpecificColor(int index) {
            super(appleColors[index]);
            this.index = index;
        }

        @Override
        public int getRGB() {
            return appleColors[this.index];
        }
    }
}

