/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

final class NSEvent {
    static final int SCROLL_PHASE_UNSUPPORTED = 1;
    static final int SCROLL_PHASE_BEGAN = 2;
    static final int SCROLL_PHASE_CONTINUED = 3;
    static final int SCROLL_PHASE_MOMENTUM_BEGAN = 4;
    static final int SCROLL_PHASE_ENDED = 5;
    private int type;
    private int modifierFlags;
    private int clickCount;
    private int buttonNumber;
    private int x;
    private int y;
    private double scrollDeltaY;
    private double scrollDeltaX;
    private int scrollPhase;
    private int absX;
    private int absY;
    private short keyCode;
    private String characters;
    private String charactersIgnoringModifiers;

    NSEvent(int type, int modifierFlags, short keyCode, String characters, String charactersIgnoringModifiers) {
        this.type = type;
        this.modifierFlags = modifierFlags;
        this.keyCode = keyCode;
        this.characters = characters;
        this.charactersIgnoringModifiers = charactersIgnoringModifiers;
    }

    NSEvent(int type, int modifierFlags, int clickCount, int buttonNumber, int x, int y, int absX, int absY, double scrollDeltaY, double scrollDeltaX, int scrollPhase) {
        this.type = type;
        this.modifierFlags = modifierFlags;
        this.clickCount = clickCount;
        this.buttonNumber = buttonNumber;
        this.x = x;
        this.y = y;
        this.absX = absX;
        this.absY = absY;
        this.scrollDeltaY = scrollDeltaY;
        this.scrollDeltaX = scrollDeltaX;
        this.scrollPhase = scrollPhase;
    }

    int getType() {
        return this.type;
    }

    int getModifierFlags() {
        return this.modifierFlags;
    }

    int getClickCount() {
        return this.clickCount;
    }

    int getButtonNumber() {
        return this.buttonNumber;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    double getScrollDeltaY() {
        return this.scrollDeltaY;
    }

    double getScrollDeltaX() {
        return this.scrollDeltaX;
    }

    int getScrollPhase() {
        return this.scrollPhase;
    }

    int getAbsX() {
        return this.absX;
    }

    int getAbsY() {
        return this.absY;
    }

    short getKeyCode() {
        return this.keyCode;
    }

    String getCharactersIgnoringModifiers() {
        return this.charactersIgnoringModifiers;
    }

    String getCharacters() {
        return this.characters;
    }

    public String toString() {
        return "NSEvent[" + this.getType() + " ," + this.getModifierFlags() + " ," + this.getClickCount() + " ," + this.getButtonNumber() + " ," + this.getX() + " ," + this.getY() + " ," + this.getAbsX() + " ," + this.getAbsY() + " ," + this.getKeyCode() + " ," + this.getCharacters() + " ," + this.getCharactersIgnoringModifiers() + "]";
    }

    static int nsToJavaButton(int buttonNumber) {
        int jbuttonNumber = buttonNumber + 1;
        switch (buttonNumber) {
            case 0: {
                jbuttonNumber = 1;
                break;
            }
            case 1: {
                jbuttonNumber = 3;
                break;
            }
            case 2: {
                jbuttonNumber = 2;
            }
        }
        return jbuttonNumber;
    }

    static int npToJavaEventType(int npEventType) {
        int jeventType = 0;
        switch (npEventType) {
            case 2: {
                jeventType = 501;
                break;
            }
            case 3: {
                jeventType = 502;
                break;
            }
            case 4: {
                jeventType = 503;
                break;
            }
            case 5: {
                jeventType = 504;
                break;
            }
            case 6: {
                jeventType = 505;
                break;
            }
            case 7: {
                jeventType = 506;
                break;
            }
            case 8: {
                jeventType = 401;
                break;
            }
            case 9: {
                jeventType = 402;
            }
        }
        return jeventType;
    }

    static int nsToJavaEventType(int nsEventType) {
        int jeventType = 0;
        switch (nsEventType) {
            case 1: 
            case 3: 
            case 25: {
                jeventType = 501;
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                jeventType = 502;
                break;
            }
            case 5: {
                jeventType = 503;
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                jeventType = 506;
                break;
            }
            case 8: {
                jeventType = 504;
                break;
            }
            case 9: {
                jeventType = 505;
                break;
            }
            case 22: {
                jeventType = 507;
                break;
            }
            case 10: {
                jeventType = 401;
                break;
            }
            case 11: {
                jeventType = 402;
            }
        }
        return jeventType;
    }

    static native int nsToJavaMouseModifiers(int var0, int var1);

    static native int nsToJavaKeyModifiers(int var0);

    static native boolean nsToJavaKeyInfo(int[] var0, int[] var1);

    static native void nsKeyModifiersToJavaKeyInfo(int[] var0, int[] var1);

    static native char nsToJavaChar(char var0, int var1);

    static boolean isPopupTrigger(int jmodifiers) {
        boolean isRightButtonDown = (jmodifiers & 0x1000) != 0;
        boolean isLeftButtonDown = (jmodifiers & 0x400) != 0;
        boolean isControlDown = (jmodifiers & 0x80) != 0;
        return isRightButtonDown || isControlDown && isLeftButtonDown;
    }
}

