/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.management.counter.perf.InstrumentationException;
import sun.management.counter.perf.PerfDataType;

class PerfDataEntry {
    private String name;
    private int entryStart;
    private int entryLength;
    private int vectorLength;
    private PerfDataType dataType;
    private int flags;
    private Units unit;
    private Variability variability;
    private int dataOffset;
    private int dataSize;
    private ByteBuffer data;

    PerfDataEntry(ByteBuffer b) {
        byte c;
        this.entryStart = b.position();
        this.entryLength = b.getInt();
        if (this.entryLength <= 0 || this.entryLength > b.limit()) {
            throw new InstrumentationException("Invalid entry length:  entryLength = " + this.entryLength);
        }
        if (this.entryStart + this.entryLength > b.limit()) {
            throw new InstrumentationException("Entry extends beyond end of buffer:  entryStart = " + this.entryStart + " entryLength = " + this.entryLength + " buffer limit = " + b.limit());
        }
        b.position(this.entryStart + 4);
        int nameOffset = b.getInt();
        if (this.entryStart + nameOffset > b.limit()) {
            throw new InstrumentationException("Invalid name offset:  entryStart = " + this.entryStart + " nameOffset = " + nameOffset + " buffer limit = " + b.limit());
        }
        b.position(this.entryStart + 8);
        this.vectorLength = b.getInt();
        b.position(this.entryStart + 12);
        this.dataType = PerfDataType.toPerfDataType(b.get());
        b.position(this.entryStart + 13);
        this.flags = b.get();
        b.position(this.entryStart + 14);
        this.unit = Units.toUnits(b.get());
        b.position(this.entryStart + 15);
        this.variability = Variability.toVariability(b.get());
        b.position(this.entryStart + 16);
        this.dataOffset = b.getInt();
        b.position(this.entryStart + nameOffset);
        int nameLength = 0;
        while ((c = b.get()) != 0) {
            ++nameLength;
        }
        byte[] symbolBytes = new byte[nameLength];
        b.position(this.entryStart + nameOffset);
        for (int i = 0; i < nameLength; ++i) {
            symbolBytes[i] = b.get();
        }
        try {
            this.name = new String(symbolBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.getMessage(), e);
        }
        if (this.variability == Variability.INVALID) {
            throw new InstrumentationException("Invalid variability attribute: name = " + this.name);
        }
        if (this.unit == Units.INVALID) {
            throw new InstrumentationException("Invalid units attribute:  name = " + this.name);
        }
        this.dataSize = this.vectorLength > 0 ? this.vectorLength * this.dataType.size() : this.dataType.size();
        if (this.entryStart + this.dataOffset + this.dataSize > b.limit()) {
            throw new InstrumentationException("Data extends beyond end of buffer:  entryStart = " + this.entryStart + " dataOffset = " + this.dataOffset + " dataSize = " + this.dataSize + " buffer limit = " + b.limit());
        }
        b.position(this.entryStart + this.dataOffset);
        this.data = b.slice();
        this.data.order(b.order());
        this.data.limit(this.dataSize);
    }

    public int size() {
        return this.entryLength;
    }

    public String name() {
        return this.name;
    }

    public PerfDataType type() {
        return this.dataType;
    }

    public Units units() {
        return this.unit;
    }

    public int flags() {
        return this.flags;
    }

    public int vectorLength() {
        return this.vectorLength;
    }

    public Variability variability() {
        return this.variability;
    }

    public ByteBuffer byteData() {
        this.data.position(0);
        assert (this.data.remaining() == this.vectorLength());
        return this.data.duplicate();
    }

    public LongBuffer longData() {
        LongBuffer lb = this.data.asLongBuffer();
        return lb;
    }

    private class EntryFieldOffset {
        private static final int SIZEOF_BYTE = 1;
        private static final int SIZEOF_INT = 4;
        private static final int SIZEOF_LONG = 8;
        private static final int ENTRY_LENGTH_SIZE = 4;
        private static final int NAME_OFFSET_SIZE = 4;
        private static final int VECTOR_LENGTH_SIZE = 4;
        private static final int DATA_TYPE_SIZE = 1;
        private static final int FLAGS_SIZE = 1;
        private static final int DATA_UNIT_SIZE = 1;
        private static final int DATA_VAR_SIZE = 1;
        private static final int DATA_OFFSET_SIZE = 4;
        static final int ENTRY_LENGTH = 0;
        static final int NAME_OFFSET = 4;
        static final int VECTOR_LENGTH = 8;
        static final int DATA_TYPE = 12;
        static final int FLAGS = 13;
        static final int DATA_UNIT = 14;
        static final int DATA_VAR = 15;
        static final int DATA_OFFSET = 16;

        private EntryFieldOffset() {
        }
    }
}

