/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.security.action.GetPropertyAction;

class KQueueArrayWrapper {
    static short EVFILT_READ;
    static short EVFILT_WRITE;
    static short SIZEOF_KEVENT;
    static short FD_OFFSET;
    static short FILTER_OFFSET;
    static final int NUM_KEVENTS = 128;
    static boolean is64bit;
    private AllocatedNativeObject keventArray = null;
    private long keventArrayAddress;
    private int kq = -1;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private LinkedList<Update> updateList = new LinkedList();

    KQueueArrayWrapper() {
        int allocationSize = SIZEOF_KEVENT * 128;
        this.keventArray = new AllocatedNativeObject(allocationSize, true);
        this.keventArrayAddress = this.keventArray.address();
        this.kq = this.init();
    }

    void initInterrupt(int fd0, int fd1) {
        this.outgoingInterruptFD = fd1;
        this.incomingInterruptFD = fd0;
        this.register0(this.kq, fd0, 1, 0);
    }

    int getReventOps(int index) {
        int result = 0;
        int offset = SIZEOF_KEVENT * index + FILTER_OFFSET;
        short filter = this.keventArray.getShort(offset);
        if (filter == EVFILT_READ) {
            result |= Net.POLLIN;
        } else if (filter == EVFILT_WRITE) {
            result |= Net.POLLOUT;
        }
        return result;
    }

    int getDescriptor(int index) {
        int offset = SIZEOF_KEVENT * index + FD_OFFSET;
        if (is64bit) {
            long fd = this.keventArray.getLong(offset);
            assert (fd <= Integer.MAX_VALUE);
            return (int)fd;
        }
        return this.keventArray.getInt(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(SelChImpl channel, int events) {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Update(channel, events));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(SelChImpl channel) {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            Iterator it = this.updateList.iterator();
            while (it.hasNext()) {
                if (((Update)it.next()).channel != channel) continue;
                it.remove();
            }
            this.register0(this.kq, channel.getFDVal(), 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            Update u = null;
            while ((u = this.updateList.poll()) != null) {
                SelChImpl ch = u.channel;
                if (!ch.isOpen()) continue;
                this.register0(this.kq, ch.getFDVal(), u.events & Net.POLLIN, u.events & Net.POLLOUT);
            }
        }
    }

    void close() throws IOException {
        if (this.keventArray != null) {
            this.keventArray.free();
            this.keventArray = null;
        }
        if (this.kq >= 0) {
            FileDispatcherImpl.closeIntFD(this.kq);
            this.kq = -1;
        }
    }

    int poll(long timeout) {
        this.updateRegistrations();
        int updated = this.kevent0(this.kq, this.keventArrayAddress, 128, timeout);
        return updated;
    }

    void interrupt() {
        KQueueArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    private native int init();

    private static native void initStructSizes();

    private native void register0(int var1, int var2, int var3, int var4);

    private native int kevent0(int var1, long var2, int var4, long var5);

    private static native void interrupt(int var0);

    static {
        is64bit = false;
        IOUtil.load();
        KQueueArrayWrapper.initStructSizes();
        String datamodel = AccessController.doPrivileged(new GetPropertyAction("sun.arch.data.model"));
        is64bit = datamodel.equals("64");
    }

    private static class Update {
        SelChImpl channel;
        int events;

        Update(SelChImpl channel, int events) {
            this.channel = channel;
            this.events = events;
        }
    }
}

