/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.KQueueArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class KQueueSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    KQueueArrayWrapper kqueueWrapper;
    private int totalChannels;
    private HashMap<Integer, MapEntry> fdMap;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;
    private long updateCount;

    KQueueSelectorImpl(SelectorProvider sp) {
        super(sp);
        long fds = IOUtil.makePipe(false);
        this.fd0 = (int)(fds >>> 32);
        this.fd1 = (int)fds;
        try {
            this.kqueueWrapper = new KQueueArrayWrapper();
            this.kqueueWrapper.initInterrupt(this.fd0, this.fd1);
            this.fdMap = new HashMap();
            this.totalChannels = 1;
        }
        catch (Throwable t) {
            try {
                FileDispatcherImpl.closeIntFD(this.fd0);
            }
            catch (IOException ioe0) {
                t.addSuppressed(ioe0);
            }
            try {
                FileDispatcherImpl.closeIntFD(this.fd1);
            }
            catch (IOException ioe1) {
                t.addSuppressed(ioe1);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long timeout) throws IOException {
        int entries = 0;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            entries = this.kqueueWrapper.poll(timeout);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        return this.updateSelectedKeys(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateSelectedKeys(int entries) throws IOException {
        int numKeysUpdated = 0;
        boolean interrupted = false;
        ++this.updateCount;
        for (int i = 0; i < entries; ++i) {
            int nextFD = this.kqueueWrapper.getDescriptor(i);
            if (nextFD == this.fd0) {
                interrupted = true;
                continue;
            }
            MapEntry me = this.fdMap.get(nextFD);
            if (me == null) continue;
            int rOps = this.kqueueWrapper.getReventOps(i);
            SelectionKeyImpl ski = me.ski;
            if (this.selectedKeys.contains(ski)) {
                if (me.updateCount != this.updateCount) {
                    if (!ski.channel.translateAndSetReadyOps(rOps, ski)) continue;
                    ++numKeysUpdated;
                    me.updateCount = this.updateCount;
                    continue;
                }
                ski.channel.translateAndUpdateReadyOps(rOps, ski);
                continue;
            }
            ski.channel.translateAndSetReadyOps(rOps, ski);
            if ((ski.nioReadyOps() & ski.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(ski);
            ++numKeysUpdated;
            me.updateCount = this.updateCount;
        }
        if (interrupted) {
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Object object = this.interruptLock;
            synchronized (object) {
                this.interruptTriggered = true;
            }
            FileDispatcherImpl.closeIntFD(this.fd0);
            FileDispatcherImpl.closeIntFD(this.fd1);
            if (this.kqueueWrapper != null) {
                this.kqueueWrapper.close();
                this.kqueueWrapper = null;
                this.selectedKeys = null;
                Iterator i = this.keys.iterator();
                while (i.hasNext()) {
                    SelectionKeyImpl ski = (SelectionKeyImpl)i.next();
                    this.deregister(ski);
                    SelectableChannel selch = ski.channel();
                    if (!selch.isOpen() && !selch.isRegistered()) {
                        ((SelChImpl)((Object)selch)).kill();
                    }
                    i.remove();
                }
                this.totalChannels = 0;
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        int fd = IOUtil.fdVal(ski.channel.getFD());
        this.fdMap.put(fd, new MapEntry(ski));
        ++this.totalChannels;
        this.keys.add(ski);
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        int fd = ski.channel.getFDVal();
        this.fdMap.remove(fd);
        this.kqueueWrapper.release(ski.channel);
        --this.totalChannels;
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    @Override
    public void putEventOps(SelectionKeyImpl ski, int ops) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.kqueueWrapper.setInterest(ski.channel, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.kqueueWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    private static class MapEntry {
        SelectionKeyImpl ski;
        long updateCount;

        MapEntry(SelectionKeyImpl ski) {
            this.ski = ski;
        }
    }
}

