/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.util.Arrays;
import sun.nio.fs.BsdNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class BsdFileStore
extends UnixFileStore {
    BsdFileStore(UnixPath file) throws IOException {
        super(file);
    }

    BsdFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        super(fs, entry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        UnixFileSystem fs = this.file().getFileSystem();
        UnixPath path = null;
        try {
            byte[] rp = UnixNativeDispatcher.realpath(this.file());
            path = new UnixPath(fs, rp);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file());
        }
        byte[] dir = null;
        try {
            dir = BsdNativeDispatcher.getmntonname(path);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(path);
        }
        for (UnixMountEntry entry : fs.getMountEntries()) {
            if (!Arrays.equals(dir, entry.dir())) continue;
            return entry;
        }
        throw new IOException("Mount point not found in fstab");
    }
}

