/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.util.regex.Pattern;
import sun.nio.fs.BsdFileSystem;
import sun.nio.fs.MacOSXNativeDispatcher;
import sun.nio.fs.UnixFileSystemProvider;

class MacOSXFileSystem
extends BsdFileSystem {
    MacOSXFileSystem(UnixFileSystemProvider provider, String dir) {
        super(provider, dir);
    }

    @Override
    Pattern compilePathMatchPattern(String expr) {
        return Pattern.compile(expr, 128);
    }

    @Override
    char[] normalizeNativePath(char[] path) {
        for (char c : path) {
            if (c <= '\u0080') continue;
            return MacOSXNativeDispatcher.normalizepath(path, 0);
        }
        return path;
    }

    @Override
    String normalizeJavaPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) <= '\u0080') continue;
            return new String(MacOSXNativeDispatcher.normalizepath(path.toCharArray(), 2));
        }
        return path;
    }
}

